/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.GraphQuery;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;

public class QueryMapper {
    private GraphQuery query;
    private Node[] variables;
    private Graph graph;
    static final String varPrefix = "jqv:";

    public QueryMapper(Model m3, Resource[] variables) {
        this.graph = this.toQueryGraph(m3);
        this.query = new GraphQuery(this.graph);
        this.variables = this.toQueryVariables(variables);
    }

    public Node[] getVariables() {
        return this.variables;
    }

    public GraphQuery getQuery() {
        return this.query;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Graph toQueryGraph(Model m3) {
        StmtIterator st = m3.listStatements();
        Graph result = Factory.createDefaultGraph();
        while (st.hasNext()) {
            result.add(this.toQueryTriple(st.nextStatement()));
        }
        return result;
    }

    public Triple toQueryTriple(Statement s2) {
        return Triple.create(this.toQueryNode(s2.getSubject()), this.toQueryNode(s2.getPredicate()), this.toQueryNode(s2.getObject()));
    }

    public Node[] toQueryVariables(Resource[] vars) {
        Node[] result = new Node[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            result[i] = this.toQueryNode(vars[i]);
        }
        return result;
    }

    public Node toQueryNode(RDFNode rn) {
        Node n = rn.asNode();
        return n.isURI() && n.getURI().startsWith(varPrefix) ? Node.createVariable(n.getURI().substring(varPrefix.length())) : n;
    }
}

