/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy.artefact;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sf.jnati.ArtefactDescriptor;
import net.sf.jnati.config.Configuration;
import net.sf.jnati.deploy.artefact.ArtefactFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Artefact {
    private String id;
    private String version;
    private File path;
    private List<ArtefactFile> fileList;
    private List<URL> repositoryList;
    private Configuration config;

    public Artefact(String id, String version2) {
        if (id == null) {
            throw new NullPointerException("Null ID");
        }
        if (version2 == null) {
            throw new NullPointerException("Null version");
        }
        this.id = id;
        this.version = version2;
    }

    public Artefact(Artefact artefact) {
        this.id = artefact.getId();
        this.version = artefact.getVersion();
        this.config = artefact.getConfiguration();
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public File getPath() {
        return this.path;
    }

    public void setPath(File path) {
        this.path = path;
    }

    public List<ArtefactFile> getFileList() {
        return this.fileList == null ? null : new ArrayList<ArtefactFile>(this.fileList);
    }

    public void setFileList(List<ArtefactFile> fileList) {
        this.fileList = fileList == null ? null : new ArrayList<ArtefactFile>(fileList);
    }

    public List<URL> getRepositoryList() {
        return this.repositoryList == null ? null : new ArrayList<URL>(this.repositoryList);
    }

    public void setRepositoryList(List<URL> repositoryList) {
        this.repositoryList = repositoryList == null ? null : new ArrayList<URL>(repositoryList);
    }

    public String toString() {
        return this.id + "-" + this.version + "-" + this.getOsArch();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public String getProperty(String key) {
        return this.config.getProperty(key);
    }

    public String getOsArch() {
        return this.getProperty("jnati.osarch.${jnati.artefactId}.${jnati.artefactVersion}");
    }

    public File getLocalRepository() {
        String s2 = this.getProperty("jnati.localRepository");
        return s2 == null ? null : new File(s2);
    }

    public boolean getAutoDeploy() {
        String s2 = this.getProperty("jnati.autoDeploy");
        return Boolean.parseBoolean(s2);
    }

    public boolean isMultideployEnabled() {
        String s2 = this.getProperty("jnati.enableMultideploy.${jnati.artefactId}.${jnati.artefactVersion}");
        return Boolean.parseBoolean(s2);
    }

    public int getMaxMultideployCount() {
        String s2 = this.getProperty("jnati.maxMultideployCount.${jnati.artefactId}.${jnati.artefactVersion}");
        return Integer.parseInt(s2);
    }

    public boolean getAllowLocal() {
        String s2 = this.getProperty("jnati.allowDirectLoad");
        return Boolean.parseBoolean(s2);
    }

    public boolean getAllowDownload() {
        String s2 = this.getProperty("jnati.allowDownload");
        return Boolean.parseBoolean(s2);
    }

    public List<String> getRepositoryUrls() {
        String s2 = this.getProperty("jnati.repositoryUrls.${jnati.artefactId}.${jnati.artefactVersion}");
        ArrayList<String> list = new ArrayList<String>();
        for (String u : s2.split(";")) {
            if ((u = u.trim()).length() <= 0) continue;
            list.add(u);
        }
        return list;
    }

    public ArtefactDescriptor getArtefactLocation() {
        return new ArtefactDescriptor(this.id, this.version, this.getOsArch(), this.path);
    }
}

