/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.canonical;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Namespace;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Serializer;
import nu.xom.Text;
import nu.xom.XPathContext;
import nu.xom.canonical.CanonicalizationException;
import nu.xom.canonical.URIJoiner;
import org.xml.sax.helpers.NamespaceSupport;

public class Canonicalizer {
    private boolean withComments;
    private boolean exclusive = false;
    private boolean v11 = false;
    private CanonicalXMLSerializer serializer;
    private List<String> inclusiveNamespacePrefixes = new ArrayList<String>();
    private static Comparator<Attribute> comparator = new AttributeComparator();
    public static final String CANONICAL_XML = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String CANONICAL_XML_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String EXCLUSIVE_XML_CANONICALIZATION = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String EXCLUSIVE_XML_CANONICALIZATION_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String CANONICAL_XML_11 = "http://www.w3.org/2006/12/xml-c14n11";
    public static final String CANONICAL_XML_11_WITH_COMMENTS = "http://www.w3.org/2006/12/xml-c14n11#WithComments";

    public Canonicalizer(OutputStream outputStream) {
        this(outputStream, true, false);
    }

    public Canonicalizer(OutputStream outputStream, boolean bl) {
        this(outputStream, bl, false);
    }

    private Canonicalizer(OutputStream outputStream, boolean bl, boolean bl2) {
        this.serializer = new CanonicalXMLSerializer(outputStream);
        this.serializer.setLineSeparator("\n");
        this.withComments = bl;
        this.exclusive = bl2;
    }

    public Canonicalizer(OutputStream outputStream, String string) {
        if (string == null) {
            throw new NullPointerException("Null algorithm");
        }
        this.serializer = new CanonicalXMLSerializer(outputStream);
        this.serializer.setLineSeparator("\n");
        if (string.equals(CANONICAL_XML)) {
            this.withComments = false;
            this.exclusive = false;
        } else if (string.equals(CANONICAL_XML_WITH_COMMENTS)) {
            this.withComments = true;
            this.exclusive = false;
        } else if (string.equals(EXCLUSIVE_XML_CANONICALIZATION)) {
            this.withComments = false;
            this.exclusive = true;
        } else if (string.equals(EXCLUSIVE_XML_CANONICALIZATION_WITH_COMMENTS)) {
            this.withComments = true;
            this.exclusive = true;
        } else if (string.equals(CANONICAL_XML_11)) {
            this.withComments = false;
            this.exclusive = false;
            this.v11 = true;
        } else if (string.equals(CANONICAL_XML_11_WITH_COMMENTS)) {
            this.withComments = true;
            this.exclusive = false;
            this.v11 = true;
        } else {
            throw new CanonicalizationException("Unsupported canonicalization algorithm: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Node node) throws IOException {
        if (node instanceof Element) {
            Object object;
            Document document = node.getDocument();
            Element element = null;
            if (document == null) {
                element = new Element("pseudo");
                new Document(element);
                object = (ParentNode)node;
                while (((Node)object).getParent() != null) {
                    object = ((Node)object).getParent();
                }
                element.appendChild((Node)object);
            }
            try {
                object = node.query(".//. | .//@* | .//namespace::*");
                if (this.exclusive) {
                    String string;
                    Node node2;
                    int n;
                    HashSet<String> hashSet = new HashSet<String>(((Nodes)object).size());
                    for (n = 0; n < ((Nodes)object).size(); ++n) {
                        node2 = ((Nodes)object).get(n);
                        if (node2 instanceof Element) {
                            string = ((Element)node2).getNamespacePrefix();
                            hashSet.add(string);
                            continue;
                        }
                        if (!(node2 instanceof Attribute) || "".equals(string = ((Attribute)node2).getNamespacePrefix())) continue;
                        hashSet.add(string);
                    }
                    for (n = 0; n < ((Nodes)object).size(); ++n) {
                        node2 = ((Nodes)object).get(n);
                        if (!(node2 instanceof Namespace) || hashSet.contains(string = ((Namespace)node2).getPrefix())) continue;
                        ((Nodes)object).remove(n);
                        --n;
                    }
                }
                this.write((Nodes)object);
            }
            finally {
                if (element != null) {
                    element.removeChild(0);
                }
            }
        } else {
            this.serializer.nodes = null;
            this.serializer.write(node);
        }
        this.serializer.flush();
    }

    public final void write(Nodes nodes) throws IOException {
        if (nodes.size() > 0) {
            Document document = nodes.get(0).getDocument();
            if (document == null) {
                throw new CanonicalizationException("Canonicalization is not defined for detached nodes");
            }
            Nodes nodes2 = this.sort(nodes);
            this.serializer.nodes = nodes2;
            this.serializer.write(document);
            this.serializer.flush();
        }
    }

    public final void setInclusiveNamespacePrefixList(String string) {
        this.inclusiveNamespacePrefixes.clear();
        if (this.exclusive && string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.inclusiveNamespacePrefixes.add(stringTokenizer.nextToken());
            }
        }
    }

    private Nodes sort(Nodes nodes) {
        Document document = nodes.get(0).getDocument();
        if (nodes.size() > 1) {
            Nodes nodes2 = new Nodes();
            ArrayList<Node> arrayList = new ArrayList<Node>(nodes.size());
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                arrayList.add(node);
                if (!(node instanceof Namespace)) continue;
                arrayList2.add(node);
            }
            Canonicalizer.sort(arrayList, arrayList2, nodes2, document);
            if (!arrayList.isEmpty()) {
                for (Node node : arrayList) {
                    if (document == node.getDocument()) continue;
                    throw new CanonicalizationException("Cannot canonicalize subsets that contain nodes from more than one document");
                }
            }
            return nodes2;
        }
        return new Nodes(nodes.get(0));
    }

    private static String joinURIReferences(String string, String string2) {
        if ("..".equals(string)) {
            string = "../";
        }
        if ("..".equals(string2)) {
            string2 = "../";
        }
        if (string2 == null) {
            return string;
        }
        return URIJoiner.absolutize(string, string2);
    }

    private static void sort(List<Node> list, List<Node> list2, Nodes nodes, ParentNode parentNode) {
        if (list.isEmpty()) {
            return;
        }
        if (list.contains(parentNode)) {
            nodes.append(parentNode);
            list.remove(parentNode);
        }
        int n = parentNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node node = parentNode.getChild(i);
            if (node instanceof Element) {
                Node node2;
                Element element = (Element)node;
                if (list.contains(element)) {
                    nodes.append(element);
                    list.remove(element);
                }
                if (!list2.isEmpty()) {
                    Iterator<Node> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Namespace namespace;
                        node2 = iterator.next();
                        if (!(node2 instanceof Namespace) || element != (namespace = (Namespace)node2).getParent()) continue;
                        nodes.append(namespace);
                        iterator.remove();
                    }
                }
                for (int j = 0; j < element.getAttributeCount(); ++j) {
                    node2 = element.getAttribute(j);
                    if (!list.contains(node2)) continue;
                    nodes.append(node2);
                    list.remove(node2);
                    if (!list.isEmpty()) continue;
                    return;
                }
                Canonicalizer.sort(list, list2, nodes, element);
                continue;
            }
            if (!list.contains(node)) continue;
            nodes.append(node);
            list.remove(node);
            if (!list.isEmpty()) continue;
            return;
        }
    }

    private class CanonicalXMLSerializer
    extends Serializer {
        private Nodes nodes;
        private NamespaceSupport inScope;
        private final XPathContext xmlcontext;

        CanonicalXMLSerializer(OutputStream outputStream) {
            super(outputStream);
            this.xmlcontext = new XPathContext("xml", "http://www.w3.org/XML/1998/namespace");
            this.setLineSeparator("\n");
        }

        @Override
        public final void write(Document document) throws IOException {
            Node node;
            this.inScope = new NamespaceSupport();
            int n = 0;
            do {
                node = document.getChild(n);
                if (this.nodes == null || node instanceof Element || this.nodes.contains(node)) {
                    this.writeChild(node);
                    if (node instanceof ProcessingInstruction) {
                        this.breakLine();
                    } else if (node instanceof Comment && Canonicalizer.this.withComments) {
                        this.breakLine();
                    }
                }
                ++n;
            } while (!(node instanceof Element));
            for (int i = n; i < document.getChildCount(); ++i) {
                Node node2 = document.getChild(i);
                if (this.nodes != null && !(node2 instanceof Element) && !this.nodes.contains(node2)) continue;
                if (node2 instanceof ProcessingInstruction) {
                    this.breakLine();
                } else if (node2 instanceof Comment && Canonicalizer.this.withComments) {
                    this.breakLine();
                }
                this.writeChild(node2);
            }
            this.flush();
        }

        @Override
        protected final void write(Element element) throws IOException {
            if (element.getChildCount() == 0) {
                this.writeStartTag(element, false);
                this.writeEndTag(element);
            } else {
                Node node = element;
                boolean bl = false;
                int n = -1;
                int[] nArray = new int[10];
                int n2 = 0;
                nArray[0] = -1;
                while (true) {
                    if (!bl && ((Node)node).getChildCount() > 0) {
                        this.writeStartTag((Element)node, false);
                        node = ((Node)node).getChild(0);
                        n = 0;
                        nArray = this.grow(nArray, ++n2);
                        nArray[n2] = 0;
                        continue;
                    }
                    if (bl) {
                        this.writeEndTag((Element)node);
                        if (node == element) {
                            break;
                        }
                    } else {
                        this.writeChild(node);
                    }
                    bl = false;
                    ParentNode parentNode = node.getParent();
                    if (parentNode.getChildCount() - 1 == n) {
                        node = parentNode;
                        --n2;
                        if (node != element) {
                            n = nArray[n2];
                        }
                        bl = true;
                        continue;
                    }
                    nArray[n2] = ++n;
                    node = parentNode.getChild(n);
                }
            }
        }

        private int[] grow(int[] nArray, int n) {
            if (n < nArray.length) {
                return nArray;
            }
            int[] nArray2 = new int[nArray.length * 2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }

        protected void writeStartTag(Element element, boolean bl) throws IOException {
            String string;
            Object object;
            Attribute[] attributeArray;
            boolean bl2;
            boolean bl3 = bl2 = this.nodes == null || this.nodes.contains(element);
            if (bl2) {
                this.inScope.pushContext();
                this.writeRaw("<");
                this.writeRaw(element.getQualifiedName());
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            if (this.nodes == null) {
                attributeArray = element.getParent();
                Element element2 = null;
                if (attributeArray instanceof Element) {
                    element2 = (Element)attributeArray;
                }
                for (int i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
                    object = element.getNamespacePrefix(i);
                    string = element.getNamespaceURI((String)object);
                    if (string.equals(this.inScope.getURI((String)object))) continue;
                    if (Canonicalizer.this.exclusive) {
                        if (!this.needToDeclareNamespace(element, (String)object, string)) continue;
                        treeMap.put((String)object, string);
                        continue;
                    }
                    if (string.equals("")) {
                        if (element2 == null || "".equals(element2.getNamespaceURI(""))) continue;
                        treeMap.put((String)object, string);
                        continue;
                    }
                    treeMap.put((String)object, string);
                }
                this.writeNamespaceDeclarations(treeMap);
            } else {
                Object object2;
                int n = this.indexOf(element);
                if (n != -1 && "".equals(element.getNamespaceURI())) {
                    ParentNode parentNode = element.getParent();
                    while (parentNode instanceof Element && !this.nodes.contains(parentNode)) {
                        parentNode = parentNode.getParent();
                    }
                    if (parentNode instanceof Element && !"".equals(object2 = ((Element)parentNode).getNamespaceURI(""))) {
                        treeMap.put("", "");
                    }
                }
                for (int i = n + 1; i < this.nodes.size() && (object2 = this.nodes.get(i)) instanceof Namespace; ++i) {
                    object = (Namespace)object2;
                    string = ((Namespace)object).getPrefix();
                    String string2 = ((Namespace)object).getValue();
                    if (string2.equals(this.inScope.getURI(string))) continue;
                    if (Canonicalizer.this.exclusive) {
                        if (!this.needToDeclareNamespace(element, string, string2)) continue;
                        treeMap.put(string, string2);
                        continue;
                    }
                    treeMap.put(string, string2);
                }
                this.writeNamespaceDeclarations(treeMap);
            }
            attributeArray = this.sortAttributes(element);
            for (int i = 0; i < attributeArray.length; ++i) {
                if (this.nodes != null && !this.nodes.contains(attributeArray[i]) && (!attributeArray[i].getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace") || attributeArray[i].getParent() == element)) continue;
                this.write(attributeArray[i]);
            }
            if (bl2) {
                this.writeRaw(">");
            }
        }

        private void writeNamespaceDeclarations(SortedMap<String, String> sortedMap) throws IOException {
            for (Map.Entry<String, String> entry : sortedMap.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                this.writeRaw(" ");
                this.writeNamespaceDeclaration(string, string2);
                this.inScope.declarePrefix(string, string2);
            }
        }

        private boolean needToDeclareNamespace(Element element, String string, String string2) {
            boolean bl = this.visiblyUtilized(element, string, string2);
            if (bl || Canonicalizer.this.inclusiveNamespacePrefixes.contains(string)) {
                return this.noOutputAncestorUsesPrefix(element, string, string2);
            }
            return false;
        }

        private boolean visiblyUtilized(Element element, String string, String string2) {
            boolean bl = false;
            String string3 = element.getNamespacePrefix();
            String string4 = element.getNamespaceURI();
            if (string.equals(string3) && string4.equals(string2)) {
                bl = true;
            } else {
                for (int i = 0; i < element.getAttributeCount(); ++i) {
                    Attribute attribute = element.getAttribute(i);
                    if (this.nodes != null && !this.nodes.contains(attribute) || !string.equals(string3 = attribute.getNamespacePrefix())) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }

        private boolean noOutputAncestorUsesPrefix(Element element, String string, String string2) {
            ParentNode parentNode = element.getParent();
            if (parentNode instanceof Document && "".equals(string2)) {
                return false;
            }
            while (parentNode != null && !(parentNode instanceof Document)) {
                if (this.nodes == null || this.nodes.contains(parentNode)) {
                    Element element2 = (Element)parentNode;
                    String string3 = element2.getNamespacePrefix();
                    if (string3.equals(string)) {
                        String string4 = element2.getNamespaceURI(string);
                        return !string4.equals(string2);
                    }
                    for (int i = 0; i < element2.getAttributeCount(); ++i) {
                        Attribute attribute = element2.getAttribute(i);
                        String string5 = attribute.getNamespacePrefix();
                        if (!string5.equals(string)) continue;
                        String string6 = element2.getNamespaceURI(string);
                        return !string6.equals(string2);
                    }
                }
                parentNode = parentNode.getParent();
            }
            return true;
        }

        private int indexOf(Element element) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (this.nodes.get(i) != element) continue;
                return i;
            }
            return -1;
        }

        @Override
        protected void write(Attribute attribute) throws IOException {
            this.writeRaw(" ");
            this.writeRaw(attribute.getQualifiedName());
            this.writeRaw("=\"");
            this.writeRaw(this.prepareAttributeValue(attribute));
            this.writeRaw("\"");
        }

        @Override
        protected void writeEndTag(Element element) throws IOException {
            if (this.nodes == null || this.nodes.contains(element)) {
                this.writeRaw("</");
                this.writeRaw(element.getQualifiedName());
                this.writeRaw(">");
                this.inScope.popContext();
            }
        }

        private Attribute[] sortAttributes(Element element) {
            Object object;
            TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
            if (!Canonicalizer.this.exclusive && this.nodes != null && this.nodes.contains(element) && !this.nodes.contains(element.getParent())) {
                Object object2;
                Object object3;
                Object object4;
                Nodes nodes = element.query("ancestor::*/@xml:*", this.xmlcontext);
                if (nodes.size() != 0) {
                    for (int i = nodes.size() - 1; i >= 0; --i) {
                        object4 = (Attribute)nodes.get(i);
                        object3 = ((Attribute)object4).getLocalName();
                        if (element.getAttribute((String)object3, "http://www.w3.org/XML/1998/namespace") != null || Canonicalizer.this.v11 && "id".equals(object3) || treeMap.containsKey(object3) || Canonicalizer.this.v11 && !"lang".equals(object3) && !"space".equals(object3)) continue;
                        object2 = (Element)((Node)object4).getParent();
                        if (!this.nodes.contains((Node)object2)) {
                            treeMap.put(object3, object4);
                            continue;
                        }
                        treeMap.put(object3, null);
                    }
                }
                object = treeMap.values().iterator();
                while (object.hasNext()) {
                    object4 = (Attribute)object.next();
                    if (object4 != null) continue;
                    object.remove();
                }
                if (Canonicalizer.this.v11) {
                    object4 = this.getOmittedBases(element);
                    object3 = element.getAttribute("base", "http://www.w3.org/XML/1998/namespace");
                    object2 = "";
                    if (object3 != null) {
                        object2 = ((Attribute)object3).getValue();
                        element.removeAttribute((Attribute)object3);
                    }
                    if (!object4.isEmpty()) {
                        for (int i = 0; i < object4.size(); ++i) {
                            object2 = Canonicalizer.joinURIReferences((String)object4.get(i), (String)object2);
                        }
                    }
                    if (object2 != null && ((String)object2).length() > 0) {
                        treeMap.put("base", new Attribute("xml:base", "http://www.w3.org/XML/1998/namespace", (String)object2));
                    }
                }
            }
            int n = element.getAttributeCount();
            object = new Attribute[n + treeMap.size()];
            for (int i = 0; i < n; ++i) {
                object[i] = element.getAttribute(i);
            }
            Iterator iterator = treeMap.values().iterator();
            for (int i = n; i < ((Attribute[])object).length; ++i) {
                object[i] = (Attribute)iterator.next();
            }
            Arrays.sort(object, comparator);
            return object;
        }

        private List<String> getOmittedBases(Element element) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ParentNode parentNode = element.getParent();
            while (parentNode != null && parentNode instanceof Element && !this.nodes.contains(parentNode)) {
                Element element2 = (Element)parentNode;
                String string = element2.getAttributeValue("base", "http://www.w3.org/XML/1998/namespace");
                if (string != null) {
                    arrayList.add(string);
                }
                parentNode = element2.getParent();
            }
            return arrayList;
        }

        private String prepareAttributeValue(Attribute attribute) {
            String string = attribute.getValue();
            StringBuffer stringBuffer = new StringBuffer(string.length());
            if (attribute.getType().equals(Attribute.Type.CDATA) || attribute.getType().equals(Attribute.Type.UNDECLARED)) {
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    char c = cArray[i];
                    if (c == '\t') {
                        stringBuffer.append("&#x9;");
                        continue;
                    }
                    if (c == '\n') {
                        stringBuffer.append("&#xA;");
                        continue;
                    }
                    if (c == '\r') {
                        stringBuffer.append("&#xD;");
                        continue;
                    }
                    if (c == '\"') {
                        stringBuffer.append("&quot;");
                        continue;
                    }
                    if (c == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    stringBuffer.append(c);
                }
            } else {
                char[] cArray = string.toCharArray();
                boolean bl = false;
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] == ' ') {
                        if (i == cArray.length - 1 || cArray[i + 1] == ' ' || !bl) continue;
                        stringBuffer.append(cArray[i]);
                        continue;
                    }
                    bl = true;
                    if (cArray[i] == '\t') {
                        stringBuffer.append("&#x9;");
                        continue;
                    }
                    if (cArray[i] == '\n') {
                        stringBuffer.append("&#xA;");
                        continue;
                    }
                    if (cArray[i] == '\r') {
                        stringBuffer.append("&#xD;");
                        continue;
                    }
                    if (cArray[i] == '\"') {
                        stringBuffer.append("&quot;");
                        continue;
                    }
                    if (cArray[i] == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (cArray[i] == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    stringBuffer.append(cArray[i]);
                }
            }
            return stringBuffer.toString();
        }

        @Override
        protected final void write(Text text) throws IOException {
            if (this.nodes == null || this.nodes.contains(text)) {
                String string = text.getValue();
                StringBuffer stringBuffer = new StringBuffer(string.length());
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\r') {
                        stringBuffer.append("&#xD;");
                        continue;
                    }
                    if (c == '&') {
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        stringBuffer.append("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        stringBuffer.append("&gt;");
                        continue;
                    }
                    stringBuffer.append(c);
                }
                this.writeRaw(stringBuffer.toString());
            }
        }

        @Override
        protected final void write(Comment comment) throws IOException {
            if (Canonicalizer.this.withComments && (this.nodes == null || this.nodes.contains(comment))) {
                super.write(comment);
            }
        }

        @Override
        protected final void write(ProcessingInstruction processingInstruction) throws IOException {
            if (this.nodes == null || this.nodes.contains(processingInstruction)) {
                super.write(processingInstruction);
            }
        }

        @Override
        protected final void write(DocType docType) {
        }

        public void write(Node node) throws IOException {
            if (node instanceof Document) {
                this.write((Document)node);
            } else if (node instanceof Attribute) {
                this.write((Attribute)node);
            } else if (node instanceof Namespace) {
                this.write((Namespace)node);
            } else {
                this.writeChild(node);
            }
        }

        private void write(Namespace namespace) throws IOException {
            String string = namespace.getPrefix();
            String string2 = namespace.getValue();
            this.writeRaw(" xmlns");
            if (!"".equals(string)) {
                this.writeRaw(":");
                this.writeRaw(string);
            }
            this.writeRaw("=\"");
            this.writeAttributeValue(string2);
            this.writeRaw("\"");
        }
    }

    private static class AttributeComparator
    implements Comparator<Attribute> {
        private AttributeComparator() {
        }

        @Override
        public int compare(Attribute attribute, Attribute attribute2) {
            String string;
            String string2 = attribute.getNamespaceURI();
            if (string2.equals(string = attribute2.getNamespaceURI())) {
                return attribute.getLocalName().compareTo(attribute2.getLocalName());
            }
            if (string2.equals("")) {
                return -1;
            }
            if (string.equals("")) {
                return 1;
            }
            return string2.compareTo(string);
        }
    }
}

