/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.ImageEncoder;

public class EPSIEncoder
extends ImageEncoder {
    static final int maxBitsPerByte = 8;
    static final int maxBytesPerScan = 128;
    private int grayscaleBits;
    private boolean portrait;
    int width;
    int height;
    byte[][] grayPixels;
    Scanline scanline;
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final byte[] lowBitMask = new byte[]{0, 1, 3, 7, 15, 31, 63, 127, -1};

    public EPSIEncoder(Image img, OutputStream out, int grayscaleBits, boolean portrait) throws IOException {
        super(img, (DataOutput)new DataOutputStream(out));
        this.grayscaleBits = grayscaleBits;
        this.portrait = portrait;
    }

    public EPSIEncoder(ImageProducer prod, OutputStream out, int grayscaleBits, boolean portrait) throws IOException {
        super(prod, (DataOutput)new DataOutputStream(out));
        this.grayscaleBits = grayscaleBits;
        this.portrait = portrait;
    }

    @Override
    protected void encodeStart(int width, int height) throws IOException {
        int h2;
        int w;
        this.width = width;
        this.height = height;
        this.grayPixels = new byte[height][width];
        if (this.portrait) {
            w = width;
            h2 = height;
        } else {
            w = height;
            h2 = width;
        }
        int bitsPerScan = w * this.grayscaleBits;
        int bytesPerScan = bitsPerScan / 8 + (bitsPerScan % 8 == 0 ? 0 : 1);
        int linesPerScan = bytesPerScan / 128 + (bytesPerScan % 128 == 0 ? 0 : 1);
        int lines = linesPerScan * h2;
        this.scanline = new Scanline(bytesPerScan, this.grayscaleBits);
        this.putString("%%BeginPreview " + width + " " + height + " " + this.grayscaleBits + " " + lines + "\n");
    }

    @Override
    protected void encodePixels(int x, int y, int w, int h2, int[] rgbPixels, int off, int scansize) throws IOException {
        for (int row = 0; row < h2; ++row) {
            for (int column = 0; column < w; ++column) {
                this.grayPixels[y + row][column] = this.toGrayscale(rgbPixels[row * scansize + off + column]);
            }
        }
    }

    private byte toGrayscale(int argb) {
        int mask = 255;
        double blue = (double)(argb >> 0 & mask) / 255.0;
        double green = (double)(argb >> 8 & mask) / 255.0;
        double red = (double)(argb >> 16 & mask) / 255.0;
        return (byte)(255.0 * Math.max(0.0, 1.0 - (0.3 * red + 0.59 * green + 0.11 * blue)));
    }

    @Override
    protected void encodeDone() throws IOException {
        if (this.portrait) {
            for (int row = this.height - 1; row >= 0; --row) {
                this.scanline.reset();
                for (int col = 0; col < this.width; ++col) {
                    byte gray = this.grayPixels[row][col];
                    this.scanline.add(gray);
                }
                this.scanline.put();
            }
        } else {
            for (int col = this.width - 1; col >= 0; --col) {
                this.scanline.reset();
                for (int row = this.height - 1; row >= 0; --row) {
                    byte gray = this.grayPixels[row][col];
                    this.scanline.add(gray);
                }
                this.scanline.put();
            }
        }
        this.putString("%%EndPreview\n");
    }

    void putString(String s2) throws IOException {
        this.out.write(s2.getBytes());
    }

    void putChar(char c) throws IOException {
        this.out.write(c);
    }

    void putByte(byte b) throws IOException {
        int highNibble = b >> 4 & 0xF;
        int lowNibble = b & 0xF;
        this.out.write(hexDigit[highNibble]);
        this.out.write(hexDigit[lowNibble]);
    }

    private class Scanline {
        private byte[] line;
        private int nbits;
        private int currentByte;
        private int currentOffset;

        public Scanline(int size, int nbits) {
            this.line = new byte[size];
            this.nbits = nbits;
            this.reset();
        }

        public void reset() {
            this.currentByte = 0;
            this.currentOffset = 0;
            for (int i = 0; i < this.line.length; ++i) {
                this.line[i] = 0;
            }
        }

        public void add(byte b) {
            b = (byte)(b >> 8 - this.nbits);
            b = (byte)(b & lowBitMask[this.nbits]);
            int n = this.currentByte++;
            this.line[n] = (byte)(this.line[n] | b);
            if (8 - this.nbits - this.currentOffset == 0) {
                this.currentOffset = 0;
            } else {
                this.currentOffset += this.nbits;
                int n2 = this.currentByte;
                this.line[n2] = (byte)(this.line[n2] << this.nbits);
            }
        }

        public void put() throws IOException {
            while (8 - this.nbits - this.currentOffset > 0) {
                int n = this.line.length - 1;
                this.line[n] = (byte)(this.line[n] << this.nbits);
                this.currentOffset += this.nbits;
            }
            for (int i = 0; i < this.line.length; ++i) {
                if (i % 128 == 0) {
                    if (i != 0) {
                        EPSIEncoder.this.putChar('\n');
                    }
                    EPSIEncoder.this.putChar('%');
                }
                EPSIEncoder.this.putByte(this.line[i]);
            }
            EPSIEncoder.this.putChar('\n');
        }
    }
}

