/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.Ellipse2D;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingPanel;

public class TestResolution
extends TestingPanel {
    public TestResolution(String[] args) throws Exception {
        super(args);
        this.setName("Resolution");
    }

    @Override
    public void paintComponent(Graphics g2) {
        if (g2 == null) {
            return;
        }
        VectorGraphics vg = VectorGraphics.create(g2);
        Dimension dim = this.getSize();
        Insets insets = this.getInsets();
        vg.setColor(Color.white);
        vg.fillRect(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
        double w = dim.width / 3;
        double h2 = dim.height / 5;
        double s2 = 1.0E-7;
        for (int i = 0; i < 15; ++i) {
            VectorGraphics vgs = (VectorGraphics)vg.create();
            if (i < 5) {
                vgs.translate(0.0, (double)i * h2);
            } else if (i < 10) {
                vgs.translate(w, (double)(i - 5) * h2);
            } else {
                vgs.translate(2.0 * w, (double)(i - 10) * h2);
            }
            vgs.translate(w / 2.0, h2 / 2.0);
            double sc = 0.5 * Math.min(w, h2) / 2.0;
            vgs.scale(sc, sc);
            vgs.scale(1.0 / s2, 1.0 / s2);
            vgs.setStroke(new BasicStroke((float)(0.5 * s2), 1, 1));
            vgs.setColor(Color.black);
            vgs.draw(new Ellipse2D.Double(-1.0 * s2, -1.0 * s2, 2.0 * s2, 2.0 * s2));
            vgs.dispose();
            s2 *= 10.0;
        }
    }

    public static void main(String[] args) throws Exception {
        new TestResolution(args).runTest();
    }
}

