/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public abstract class IsotopeFactory {
    public static final IIsotope[] EMPTY_ISOTOPE_ARRAY = new IIsotope[0];
    private List<IIsotope>[] isotopes = new List[256];
    private IIsotope[] majorIsotope = new IIsotope[256];
    protected static ILoggingTool logger = LoggingToolFactory.createLoggingTool(IsotopeFactory.class);

    public int getSize() {
        int count = 0;
        for (List<IIsotope> isotope : this.isotopes) {
            if (isotope == null) continue;
            count += isotope.size();
        }
        return count;
    }

    protected void add(IIsotope isotope) {
        Integer atomicNum = isotope.getAtomicNumber();
        assert (atomicNum != null);
        List<IIsotope> isotopesForElement = this.isotopes[atomicNum];
        if (isotopesForElement == null) {
            this.isotopes[atomicNum.intValue()] = isotopesForElement = new ArrayList<IIsotope>();
        }
        isotopesForElement.add(isotope);
    }

    public IIsotope[] getIsotopes(int elem) {
        if (this.isotopes[elem] == null) {
            return EMPTY_ISOTOPE_ARRAY;
        }
        ArrayList<IIsotope> list = new ArrayList<IIsotope>();
        for (IIsotope isotope : this.isotopes[elem]) {
            list.add(this.clone(isotope));
        }
        return list.toArray(new IIsotope[0]);
    }

    public IIsotope[] getIsotopes(String symbol) {
        return this.getIsotopes(Elements.ofString(symbol).number());
    }

    public IIsotope[] getIsotopes() {
        ArrayList<IIsotope> list = new ArrayList<IIsotope>();
        for (List<IIsotope> isotopes : this.isotopes) {
            if (isotopes == null) continue;
            for (IIsotope isotope : isotopes) {
                list.add(this.clone(isotope));
            }
        }
        return list.toArray(new IIsotope[list.size()]);
    }

    public IIsotope[] getIsotopes(double exactMass, double difference) {
        ArrayList<IIsotope> list = new ArrayList<IIsotope>();
        for (List<IIsotope> isotopes : this.isotopes) {
            if (isotopes == null) continue;
            for (IIsotope isotope : isotopes) {
                if (!(Math.abs(isotope.getExactMass() - exactMass) <= difference)) continue;
                list.add(this.clone(isotope));
            }
        }
        return list.toArray(new IIsotope[list.size()]);
    }

    public IIsotope getIsotope(String symbol, int massNumber) {
        int elem = Elements.ofString(symbol).number();
        List<IIsotope> isotopes = this.isotopes[elem];
        if (isotopes == null) {
            return null;
        }
        for (IIsotope isotope : isotopes) {
            if (!isotope.getSymbol().equals(symbol) || isotope.getMassNumber() != massNumber) continue;
            return this.clone(isotope);
        }
        return null;
    }

    public IIsotope getIsotope(String symbol, double exactMass, double tolerance) {
        IIsotope ret = null;
        double minDiff = Double.MAX_VALUE;
        int elem = Elements.ofString(symbol).number();
        List<IIsotope> isotopes = this.isotopes[elem];
        if (isotopes == null) {
            return null;
        }
        for (IIsotope isotope : isotopes) {
            double diff = Math.abs(isotope.getExactMass() - exactMass);
            if (!isotope.getSymbol().equals(symbol) || !(diff <= tolerance) || !(diff < minDiff)) continue;
            ret = this.clone(isotope);
            minDiff = diff;
        }
        return ret;
    }

    public IIsotope getMajorIsotope(int elem) {
        IIsotope major = null;
        if (this.majorIsotope[elem] != null) {
            return this.clone(this.majorIsotope[elem]);
        }
        List<IIsotope> isotopes = this.isotopes[elem];
        if (isotopes != null) {
            for (IIsotope isotope : isotopes) {
                if (isotope.getNaturalAbundance() <= 0.0 || major != null && !(isotope.getNaturalAbundance() > major.getNaturalAbundance())) continue;
                major = isotope;
            }
            if (major != null) {
                this.majorIsotope[elem] = major;
            } else {
                logger.error("Could not find major isotope for: ", elem);
            }
        }
        return this.clone(major);
    }

    public double getMajorIsotopeMass(int elem) {
        if (this.majorIsotope[elem] != null) {
            return this.majorIsotope[elem].getExactMass();
        }
        IIsotope major = this.getMajorIsotope(elem);
        if (major == null) {
            logger.warn("No major isotope for elem" + elem);
            return 2 * elem;
        }
        return major.getExactMass();
    }

    public double getExactMass(Integer atomicNumber, Integer massNumber) {
        if (atomicNumber == null || massNumber == null) {
            return 0.0;
        }
        for (IIsotope isotope : this.isotopes[atomicNumber]) {
            if (!isotope.getMassNumber().equals(massNumber)) continue;
            return isotope.getExactMass();
        }
        return massNumber.intValue();
    }

    private IIsotope clone(IIsotope isotope) {
        if (isotope == null) {
            return null;
        }
        try {
            return (IIsotope)isotope.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new UnsupportedOperationException("Clone not supported");
        }
    }

    public boolean isElement(String elementName) {
        return this.getElement(elementName) != null;
    }

    public IIsotope getMajorIsotope(String symbol) {
        return this.getMajorIsotope(Elements.ofString(symbol).number());
    }

    public IElement getElement(String symbol) {
        return this.getMajorIsotope(symbol);
    }

    public IElement getElement(int atomicNumber) {
        return this.getMajorIsotope(atomicNumber);
    }

    public String getElementSymbol(int atomicNumber) {
        IIsotope isotope = this.getMajorIsotope(atomicNumber);
        return isotope.getSymbol();
    }

    public IAtom configure(IAtom atom) {
        if (atom.getMassNumber() == null) {
            return atom;
        }
        IIsotope isotope = this.getIsotope(atom.getSymbol(), atom.getMassNumber());
        if (isotope == null) {
            throw new IllegalArgumentException("Cannot configure an unrecognized element/mass: " + atom.getMassNumber() + " " + atom);
        }
        return this.configure(atom, isotope);
    }

    public IAtom configure(IAtom atom, IIsotope isotope) {
        atom.setMassNumber(isotope.getMassNumber());
        atom.setSymbol(isotope.getSymbol());
        atom.setExactMass(isotope.getExactMass());
        atom.setAtomicNumber(isotope.getAtomicNumber());
        atom.setNaturalAbundance(isotope.getNaturalAbundance());
        return atom;
    }

    public void configureAtoms(IAtomContainer container) {
        for (int f = 0; f < container.getAtomCount(); ++f) {
            this.configure(container.getAtom(f));
        }
    }

    public double getNaturalMass(int atomicNum) {
        List<IIsotope> isotopes = this.isotopes[atomicNum];
        if (isotopes == null) {
            return 0.0;
        }
        double summedAbundances = 0.0;
        double summedWeightedAbundances = 0.0;
        double getNaturalMass = 0.0;
        for (IIsotope isotope : isotopes) {
            getNaturalMass = (summedWeightedAbundances += isotope.getNaturalAbundance() * isotope.getExactMass()) / (summedAbundances += isotope.getNaturalAbundance().doubleValue());
        }
        return getNaturalMass;
    }

    public double getNaturalMass(IElement element) {
        return this.getNaturalMass(element.getAtomicNumber());
    }
}

