/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import java.awt.Dimension;
import java.util.List;
import org.openscience.cdk.depict.DepictionGenerator;
import org.openscience.cdk.renderer.elements.Bounds;

final class Dimensions {
    static final Dimensions AUTOMATIC = new Dimensions(DepictionGenerator.AUTOMATIC, DepictionGenerator.AUTOMATIC);
    final double w;
    final double h;

    public Dimensions(double w, double h2) {
        this.w = w;
        this.h = h2;
    }

    Dimensions add(double w, double h2) {
        return new Dimensions(this.w + w, this.h + h2);
    }

    Dimensions scale(double coef) {
        return new Dimensions(coef * this.w, coef * this.h);
    }

    static Dimensions ofRow(List<Bounds> elems) {
        return Dimensions.ofGrid(elems, 1, elems.size());
    }

    static Dimensions ofCol(List<Bounds> elems) {
        return Dimensions.ofGrid(elems, elems.size(), 1);
    }

    static Dimensions ofGrid(List<Bounds> bounds, int nRow, int nCol) {
        return Dimensions.ofGrid(bounds, new double[nRow + 1], new double[nCol + 1]);
    }

    static Dimensions ofGrid(List<Bounds> bounds, double[] yOffset, double[] xOffset) {
        int i;
        int nRow = yOffset.length - 1;
        int nCol = xOffset.length - 1;
        int nBounds = bounds.size();
        for (i = 0; i < nBounds; ++i) {
            int col = 1 + i % nCol;
            int row = 1 + i / nCol;
            Bounds bound = bounds.get(i);
            if (bound.isEmpty()) continue;
            double width = bound.width();
            double height = bound.height();
            if (width > xOffset[col]) {
                xOffset[col] = width;
            }
            if (!(height > yOffset[row])) continue;
            yOffset[row] = height;
        }
        for (i = 1; i < yOffset.length; ++i) {
            int n = i;
            yOffset[n] = yOffset[n] + yOffset[i - 1];
        }
        for (i = 1; i < xOffset.length; ++i) {
            int n = i;
            xOffset[n] = xOffset[n] + xOffset[i - 1];
        }
        return new Dimensions(xOffset[nCol], yOffset[nRow]);
    }

    static Dimension determineGrid(int nElem) {
        switch (nElem) {
            case 0: {
                return new Dimension(0, 0);
            }
            case 1: {
                return new Dimension(1, 1);
            }
            case 2: {
                return new Dimension(2, 1);
            }
            case 3: {
                return new Dimension(3, 1);
            }
            case 4: {
                return new Dimension(2, 2);
            }
            case 5: {
                return new Dimension(3, 2);
            }
            case 6: {
                return new Dimension(3, 2);
            }
            case 7: {
                return new Dimension(4, 2);
            }
            case 8: {
                return new Dimension(4, 2);
            }
            case 9: {
                return new Dimension(3, 3);
            }
        }
        int nrow = (int)Math.floor(Math.sqrt(nElem));
        int ncol = (int)Math.ceil((double)nElem / (double)nrow);
        return new Dimension(ncol, nrow);
    }

    public String toString() {
        return Math.ceil(this.w) + "x" + Math.ceil(this.h);
    }
}

