/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fragment;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fragment.FragmentUtils;
import org.openscience.cdk.fragment.IFragmenter;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.hash.HashGeneratorMaker;
import org.openscience.cdk.hash.MoleculeHashGenerator;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.ringsearch.RingSearch;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class MurckoFragmenter
implements IFragmenter {
    private static final String IS_SIDECHAIN_ATOM = "sidechain";
    private static final String IS_LINKER_ATOM = "linker";
    private static final String IS_CONNECTED_TO_RING = "rcon";
    MoleculeHashGenerator generator;
    SmilesGenerator smigen;
    Map<Long, IAtomContainer> frameMap = new HashMap<Long, IAtomContainer>();
    Map<Long, IAtomContainer> ringMap = new HashMap<Long, IAtomContainer>();
    boolean singleFrameworkOnly = false;
    boolean ringFragments = true;
    int minimumFragmentSize = 5;

    public MurckoFragmenter() {
        this(true, 5, null);
    }

    public MurckoFragmenter(boolean singleFrameworkOnly, int minimumFragmentSize) {
        this(singleFrameworkOnly, minimumFragmentSize, null);
    }

    public MurckoFragmenter(boolean singleFrameworkOnly, int minimumFragmentSize, MoleculeHashGenerator generator) {
        this.singleFrameworkOnly = singleFrameworkOnly;
        this.minimumFragmentSize = minimumFragmentSize;
        this.generator = generator == null ? new HashGeneratorMaker().depth(8).elemental().isotopic().charged().orbital().molecular() : generator;
        this.smigen = SmilesGenerator.unique().aromatic();
    }

    public void setComputeRingFragments(boolean val) {
        this.ringFragments = val;
    }

    @Override
    public void generateFragments(IAtomContainer atomContainer) throws CDKException {
        HashSet<Long> fragmentSet = new HashSet<Long>();
        this.frameMap.clear();
        this.ringMap.clear();
        this.run(atomContainer, fragmentSet);
    }

    /*
     * WARNING - void declaration
     */
    public static IAtomContainer scaffold(IAtomContainer mol2) {
        void var4_10;
        void var4_8;
        if (!mol2.isEmpty() && mol2.getAtom(0).getContainer() == null) {
            return null;
        }
        ArrayDeque<IAtom> queue = new ArrayDeque<IAtom>();
        int[] bcount = new int[mol2.getAtomCount()];
        for (IAtom iAtom : mol2.atoms()) {
            int numBonds;
            bcount[iAtom.getIndex()] = numBonds = iAtom.getBondCount();
            if (numBonds != 1) continue;
            queue.add(iAtom);
        }
        while (!queue.isEmpty()) {
            IAtom atom = (IAtom)queue.poll();
            if (atom == null) continue;
            bcount[atom.getIndex()] = 0;
            for (IBond bond : atom.bonds()) {
                IAtom nbr = bond.getOther(atom);
                int n = nbr.getIndex();
                bcount[n] = bcount[n] - 1;
                if (bcount[nbr.getIndex()] != 1) continue;
                queue.add(nbr);
            }
        }
        IAtomContainer scaffold = mol2.getBuilder().newAtomContainer();
        boolean bl = false;
        while (var4_8 < mol2.getAtomCount()) {
            IAtom atom = mol2.getAtom((int)var4_8);
            if (bcount[var4_8] > 0) {
                scaffold.addAtom(atom);
            }
            ++var4_8;
        }
        boolean bl2 = false;
        while (var4_10 < mol2.getBondCount()) {
            IBond bond = mol2.getBond((int)var4_10);
            if (bcount[bond.getBegin().getIndex()] > 0 && bcount[bond.getEnd().getIndex()] > 0) {
                scaffold.addBond(bond);
            }
            ++var4_10;
        }
        return scaffold;
    }

    private void addRingFragment(IAtomContainer mol2) {
        if (mol2.getAtomCount() < this.minimumFragmentSize) {
            return;
        }
        long hash = this.generator.generate(mol2);
        this.ringMap.put(hash, mol2);
    }

    private void run(IAtomContainer atomContainer, Set<Long> fragmentSet) throws CDKException {
        Long hash;
        IAtomContainer currentFramework;
        IAtomContainer scaffold;
        if (this.singleFrameworkOnly && (scaffold = MurckoFragmenter.scaffold(atomContainer)) != null) {
            try {
                scaffold = scaffold.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("Clone not supported!");
            }
            if (scaffold.getAtomCount() >= this.minimumFragmentSize) {
                this.frameMap.put(0L, scaffold);
            }
            if (this.ringFragments) {
                RingSearch rs = new RingSearch(scaffold);
                for (IAtomContainer rset2 : rs.fusedRingFragments()) {
                    this.addRingFragment(rset2);
                }
                for (IAtomContainer rset2 : rs.isolatedRingFragments()) {
                    this.addRingFragment(rset2);
                }
            }
            return;
        }
        AllRingsFinder arf = new AllRingsFinder(false);
        IRingSet r = arf.findAllRings(atomContainer);
        for (IAtomContainer ar : r.atomContainers()) {
            for (IBond iBond : ar.bonds()) {
                iBond.setFlag(2, true);
            }
        }
        for (IAtom atom : atomContainer.atoms()) {
            atom.setProperty(IS_LINKER_ATOM, false);
            atom.setProperty(IS_SIDECHAIN_ATOM, false);
            atom.setProperty(IS_CONNECTED_TO_RING, false);
        }
        this.markLinkers(atomContainer);
        this.markSideChains(atomContainer);
        IAtomContainer clone = this.removeSideChains(atomContainer);
        clone.setStereoElements(new ArrayList<IStereoElement>());
        try {
            currentFramework = clone.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new CDKException(exception.getMessage(), exception);
        }
        if (this.hasframework(currentFramework)) {
            hash = this.generator.generate(currentFramework);
            if (this.singleFrameworkOnly) {
                if (this.frameMap.size() == 0) {
                    this.frameMap.put(hash, currentFramework);
                }
            } else {
                this.frameMap.put(hash, currentFramework);
            }
            if (!fragmentSet.contains(hash)) {
                fragmentSet.add(hash);
            }
        }
        ArrayList<IAtom> atomsToDelete = new ArrayList<IAtom>();
        for (IAtom iAtom : clone.atoms()) {
            if (!this.islinker(iAtom)) continue;
            atomsToDelete.add(iAtom);
        }
        for (IAtom iAtom : atomsToDelete) {
            clone.removeAtom(iAtom);
        }
        ArrayList<IBond> arrayList = new ArrayList<IBond>();
        for (IBond bond : clone.bonds()) {
            if (!this.isZeroAtomLinker(bond)) continue;
            arrayList.add(bond);
        }
        for (IBond bond : arrayList) {
            clone.removeBond(bond);
        }
        IAtomContainerSet iAtomContainerSet = ConnectivityChecker.partitionIntoMolecules(clone);
        for (IAtomContainer ringSystem : iAtomContainerSet.atomContainers()) {
            if (ringSystem.getAtomCount() < this.minimumFragmentSize) continue;
            hash = this.generator.generate(ringSystem);
            this.ringMap.put(hash, ringSystem);
            if (fragmentSet.contains(hash)) continue;
            fragmentSet.add(hash);
        }
        if (!this.hasframework(currentFramework)) {
            return;
        }
        assert (currentFramework != null);
        for (IBond bond : currentFramework.bonds()) {
            if (!this.islinker(bond) && !this.isZeroAtomLinker(bond)) continue;
            List<IAtomContainer> candidates = FragmentUtils.splitMolecule(currentFramework, bond);
            for (IAtomContainer candidate : candidates) {
                for (IAtom atom : candidate.atoms()) {
                    atom.setProperty(IS_LINKER_ATOM, false);
                    atom.setProperty(IS_SIDECHAIN_ATOM, false);
                    atom.setProperty(IS_CONNECTED_TO_RING, false);
                }
                this.markLinkers(candidate);
                this.markSideChains(candidate);
                hash = this.generator.generate(candidate = this.removeSideChains(candidate));
                if (fragmentSet.contains(hash) || !this.hasframework(candidate) || candidate.getAtomCount() < this.minimumFragmentSize) continue;
                fragmentSet.add(hash);
                this.run(candidate, fragmentSet);
            }
        }
    }

    private IAtomContainer removeSideChains(IAtomContainer atomContainer) throws CDKException {
        IAtomContainer clone;
        try {
            clone = atomContainer.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new CDKException("Error in clone" + exception.toString(), exception);
        }
        ArrayList<IAtom> atomsToDelete = new ArrayList<IAtom>();
        for (IAtom atom : clone.atoms()) {
            if (!this.issidechain(atom)) continue;
            atomsToDelete.add(atom);
        }
        for (IAtom anAtomsToDelete : atomsToDelete) {
            clone.removeAtom(anAtomsToDelete);
        }
        return clone;
    }

    private void markLinkers(IAtomContainer atomContainer) {
        for (IAtom atom : atomContainer.atoms()) {
            List<IAtom> conatoms;
            if (atom.getFlag(2) || (conatoms = atomContainer.getConnectedAtomsList(atom)).size() == 1) continue;
            int nRingAtom = 0;
            for (IAtom conatom : conatoms) {
                if (!conatom.getFlag(2)) continue;
                ++nRingAtom;
            }
            if (nRingAtom > 0) {
                atom.setProperty(IS_CONNECTED_TO_RING, true);
            }
            if (nRingAtom < 2) continue;
            atom.setProperty(IS_LINKER_ATOM, true);
        }
        for (IAtom atom1 : atomContainer.atoms()) {
            if (atom1.getFlag(2) || !((Boolean)atom1.getProperty(IS_CONNECTED_TO_RING)).booleanValue()) continue;
            for (IAtom atom2 : atomContainer.atoms()) {
                if (atom2.getFlag(2) || !((Boolean)atom2.getProperty(IS_CONNECTED_TO_RING)).booleanValue() || atom1.equals(atom2)) continue;
                List<List<IAtom>> paths = PathTools.getAllPaths(atomContainer, atom1, atom2);
                for (List<IAtom> path : paths) {
                    boolean allNonRing = true;
                    for (IAtom atom : path) {
                        if (!atom.getFlag(2)) continue;
                        allNonRing = false;
                        break;
                    }
                    if (!allNonRing) continue;
                    for (IAtom atom : path) {
                        atom.setProperty(IS_LINKER_ATOM, true);
                    }
                }
            }
        }
    }

    private void markSideChains(IAtomContainer atomContainer) {
        for (IAtom atom : atomContainer.atoms()) {
            if (this.isring(atom) || this.islinker(atom)) continue;
            atom.setProperty(IS_SIDECHAIN_ATOM, true);
        }
    }

    private List<String> getSmilesFromAtomContainers(Collection<IAtomContainer> mols) {
        ArrayList<String> smis = new ArrayList<String>();
        for (IAtomContainer mol2 : mols) {
            try {
                AtomContainerManipulator.clearAtomConfigurations(mol2);
                for (IAtom atom : mol2.atoms()) {
                    atom.setImplicitHydrogenCount(null);
                }
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(mol2);
                CDKHydrogenAdder.getInstance(mol2.getBuilder()).addImplicitHydrogens(mol2);
                Aromaticity.cdkLegacy().apply(mol2);
                smis.add(this.smigen.create(mol2));
            }
            catch (CDKException e) {
                LoggingToolFactory.createLoggingTool(this.getClass()).error(e);
            }
        }
        return smis;
    }

    @Override
    public String[] getFragments() {
        ArrayList<String> allfrags = new ArrayList<String>();
        allfrags.addAll(this.getSmilesFromAtomContainers(this.frameMap.values()));
        allfrags.addAll(this.getSmilesFromAtomContainers(this.ringMap.values()));
        return allfrags.toArray(new String[0]);
    }

    @Override
    public IAtomContainer[] getFragmentsAsContainers() {
        ArrayList<IAtomContainer> allfrags = new ArrayList<IAtomContainer>();
        allfrags.addAll(this.frameMap.values());
        allfrags.addAll(this.ringMap.values());
        return allfrags.toArray(new IAtomContainer[0]);
    }

    public String[] getRingSystems() {
        return this.getSmilesFromAtomContainers(this.ringMap.values()).toArray(new String[0]);
    }

    public IAtomContainer[] getRingSystemsAsContainers() {
        return this.ringMap.values().toArray(new IAtomContainer[0]);
    }

    public String[] getFrameworks() {
        return this.getSmilesFromAtomContainers(this.frameMap.values()).toArray(new String[0]);
    }

    public IAtomContainer[] getFrameworksAsContainers() {
        return this.frameMap.values().toArray(new IAtomContainer[0]);
    }

    private boolean isring(IAtom atom) {
        return atom.getFlag(2);
    }

    private boolean islinker(IAtom atom) {
        Boolean o = (Boolean)atom.getProperty(IS_LINKER_ATOM);
        return o != null && o != false;
    }

    private boolean issidechain(IAtom atom) {
        Boolean o = (Boolean)atom.getProperty(IS_SIDECHAIN_ATOM);
        return o != null && o != false;
    }

    private boolean islinker(IBond bond) {
        return this.islinker(bond.getBegin()) || this.islinker(bond.getEnd());
    }

    private boolean isZeroAtomLinker(IBond bond) {
        boolean isRingBond = bond.getFlag(2);
        return this.isring(bond.getBegin()) && this.isring(bond.getEnd()) && !isRingBond;
    }

    private boolean hasframework(IAtomContainer atomContainer) {
        boolean hasLinker = false;
        boolean hasRing = false;
        for (IAtom atom : atomContainer.atoms()) {
            if (this.islinker(atom)) {
                hasLinker = true;
            }
            if (this.isring(atom)) {
                hasRing = true;
            }
            if (!hasLinker || !hasRing) continue;
            break;
        }
        for (IBond bond : atomContainer.bonds()) {
            if (!this.isZeroAtomLinker(bond)) continue;
            hasLinker = true;
            break;
        }
        return hasLinker && hasRing;
    }
}

