/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class ZMatrixTools {
    public static Point3d[] zmatrixToCartesian(double[] distances, int[] first_atoms, double[] angles, int[] second_atoms, double[] dihedrals, int[] third_atoms) {
        Point3d[] cartesianCoords = new Point3d[distances.length];
        for (int index = 0; index < distances.length; ++index) {
            if (index == 0) {
                cartesianCoords[index] = new Point3d(0.0, 0.0, 0.0);
                continue;
            }
            if (index == 1) {
                cartesianCoords[index] = new Point3d(distances[1], 0.0, 0.0);
                continue;
            }
            if (index == 2) {
                cartesianCoords[index] = new Point3d(-Math.cos(angles[2] / 180.0 * Math.PI) * distances[2] + distances[1], Math.sin(angles[2] / 180.0 * Math.PI) * distances[2], 0.0);
                if (first_atoms[index] != 0) continue;
                cartesianCoords[index].x = (cartesianCoords[index].x - distances[1]) * -1.0;
                continue;
            }
            Vector3d cd2 = new Vector3d();
            cd2.sub(cartesianCoords[third_atoms[index]], cartesianCoords[second_atoms[index]]);
            Vector3d bc = new Vector3d();
            bc.sub(cartesianCoords[second_atoms[index]], cartesianCoords[first_atoms[index]]);
            Vector3d n1 = new Vector3d();
            n1.cross(cd2, bc);
            Vector3d n2 = ZMatrixTools.rotate(n1, bc, -dihedrals[index]);
            Vector3d ba = ZMatrixTools.rotate(bc, n2, -angles[index]);
            ba.normalize();
            ba.scale(distances[index]);
            Point3d result = new Point3d();
            result.add(cartesianCoords[first_atoms[index]], ba);
            cartesianCoords[index] = result;
        }
        return cartesianCoords;
    }

    private static Vector3d rotate(Vector3d vector, Vector3d axis, double angle) {
        Matrix3f rotate = new Matrix3f();
        rotate.set(new AxisAngle4f(new Vector3f(axis), (float)Math.toRadians(angle)));
        Vector3f result = new Vector3f();
        Vector3f vector3f = new Vector3f(vector);
        rotate.transform(vector3f, result);
        return new Vector3d(result);
    }
}

