/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.cip.rules;

import java.io.IOException;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.geometry.cip.ILigand;
import org.openscience.cdk.geometry.cip.rules.ISequenceSubRule;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

class MassNumberRule
implements ISequenceSubRule<ILigand> {
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(MassNumberRule.class);
    IsotopeFactory factory;

    MassNumberRule() {
    }

    @Override
    public int compare(ILigand ligand1, ILigand ligand2) {
        this.ensureFactory();
        return this.getMassNumber(ligand1).compareTo(this.getMassNumber(ligand2));
    }

    private void ensureFactory() {
        if (this.factory == null) {
            try {
                this.factory = Isotopes.getInstance();
            }
            catch (IOException exception) {
                this.logger.error("Could not load the IsotopeFactory: " + exception.getMessage());
            }
        }
    }

    private Integer getMassNumber(ILigand ligand) {
        Integer massNumber = ligand.getLigandAtom().getMassNumber();
        if (massNumber != null) {
            return massNumber;
        }
        if (this.factory == null) {
            return 0;
        }
        IIsotope isotope = this.factory.getMajorIsotope(ligand.getLigandAtom().getSymbol());
        if (isotope == null) {
            return 0;
        }
        return isotope.getMassNumber();
    }
}

