/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class GraphUtil {
    private static final int DEFAULT_DEGREE = 4;

    private GraphUtil() {
    }

    public static int[][] toAdjList(IAtomContainer container) {
        if (container == null) {
            throw new NullPointerException("atom container was null");
        }
        int n = container.getAtomCount();
        int[][] graph = new int[n][4];
        int[] degree = new int[n];
        for (IBond bond : container.bonds()) {
            int v = container.indexOf(bond.getBegin());
            int w = container.indexOf(bond.getEnd());
            if (v < 0 || w < 0) {
                throw new IllegalArgumentException("bond at index " + container.indexOf(bond) + " contained an atom not pressent in molecule");
            }
            int n2 = v;
            int n3 = degree[n2];
            degree[n2] = n3 + 1;
            graph[v][n3] = w;
            int n4 = w;
            int n5 = degree[n4];
            degree[n4] = n5 + 1;
            graph[w][n5] = v;
            if (degree[v] == graph[v].length) {
                graph[v] = Arrays.copyOf(graph[v], degree[v] * 2);
            }
            if (degree[w] != graph[w].length) continue;
            graph[w] = Arrays.copyOf(graph[w], degree[w] * 2);
        }
        for (int v = 0; v < n; ++v) {
            graph[v] = Arrays.copyOf(graph[v], degree[v]);
        }
        return graph;
    }

    public static int[][] toAdjListSubgraph(IAtomContainer container, Set<IBond> include) {
        if (container == null) {
            throw new NullPointerException("atom container was null");
        }
        int n = container.getAtomCount();
        int[][] graph = new int[n][4];
        int[] degree = new int[n];
        for (IBond bond : container.bonds()) {
            if (!include.contains(bond)) continue;
            int v = container.indexOf(bond.getBegin());
            int w = container.indexOf(bond.getEnd());
            if (v < 0 || w < 0) {
                throw new IllegalArgumentException("bond at index " + container.indexOf(bond) + " contained an atom not pressent in molecule");
            }
            int n2 = v;
            int n3 = degree[n2];
            degree[n2] = n3 + 1;
            graph[v][n3] = w;
            int n4 = w;
            int n5 = degree[n4];
            degree[n4] = n5 + 1;
            graph[w][n5] = v;
            if (degree[v] == graph[v].length) {
                graph[v] = Arrays.copyOf(graph[v], degree[v] * 2);
            }
            if (degree[w] != graph[w].length) continue;
            graph[w] = Arrays.copyOf(graph[w], degree[w] * 2);
        }
        for (int v = 0; v < n; ++v) {
            graph[v] = Arrays.copyOf(graph[v], degree[v]);
        }
        return graph;
    }

    public static int[][] toAdjList(IAtomContainer container, EdgeToBondMap bondMap) {
        if (container == null) {
            throw new NullPointerException("atom container was null");
        }
        int n = container.getAtomCount();
        int[][] graph = new int[n][4];
        int[] degree = new int[n];
        for (IBond bond : container.bonds()) {
            int v = container.indexOf(bond.getBegin());
            int w = container.indexOf(bond.getEnd());
            if (v < 0 || w < 0) {
                throw new IllegalArgumentException("bond at index " + container.indexOf(bond) + " contained an atom not pressent in molecule");
            }
            int n2 = v;
            int n3 = degree[n2];
            degree[n2] = n3 + 1;
            graph[v][n3] = w;
            int n4 = w;
            int n5 = degree[n4];
            degree[n4] = n5 + 1;
            graph[w][n5] = v;
            if (degree[v] == graph[v].length) {
                graph[v] = Arrays.copyOf(graph[v], degree[v] * 2);
            }
            if (degree[w] == graph[w].length) {
                graph[w] = Arrays.copyOf(graph[w], degree[w] * 2);
            }
            bondMap.put(v, w, bond);
        }
        for (int v = 0; v < n; ++v) {
            graph[v] = Arrays.copyOf(graph[v], degree[v]);
        }
        return graph;
    }

    public static int[][] subgraph(int[][] graph, int[] include) {
        int n = graph.length;
        int m3 = include.length;
        int[] mapping = new int[n];
        for (int i = 0; i < m3; ++i) {
            mapping[include[i]] = i + 1;
        }
        int[] degree = new int[m3];
        int[][] subgraph = new int[m3][4];
        for (int v = 0; v < n; ++v) {
            int p = mapping[v] - 1;
            if (p < 0) continue;
            for (int w : graph[v]) {
                int q = mapping[w] - 1;
                if (q < 0) continue;
                if (degree[p] == subgraph[p].length) {
                    subgraph[p] = Arrays.copyOf(subgraph[p], 2 * subgraph[p].length);
                }
                int n2 = p;
                int n3 = degree[n2];
                degree[n2] = n3 + 1;
                subgraph[p][n3] = q;
            }
        }
        for (int p = 0; p < m3; ++p) {
            subgraph[p] = Arrays.copyOf(subgraph[p], degree[p]);
        }
        return subgraph;
    }

    public static int[] cycle(int[][] graph, int[] vertices) {
        int n = graph.length;
        int m3 = vertices.length;
        boolean[] marked = new boolean[n];
        for (int v : vertices) {
            marked[v] = true;
        }
        int[] path = new int[m3 + 1];
        path[0] = path[m3] = vertices[0];
        marked[vertices[0]] = false;
        for (int i = 1; i < m3; ++i) {
            int w = GraphUtil.firstMarked(graph[path[i - 1]], marked);
            if (w < 0) {
                throw new IllegalArgumentException("broken path");
            }
            path[i] = w;
            marked[w] = false;
        }
        for (int w : graph[path[m3 - 1]]) {
            if (w != path[0]) continue;
            return path;
        }
        throw new IllegalArgumentException("path does not make a cycle");
    }

    static int firstMarked(int[] xs, boolean[] marked) {
        for (int x : xs) {
            if (!marked[x]) continue;
            return x;
        }
        return -1;
    }

    private static final class Tuple {
        private final int u;
        private final int v;

        private Tuple(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tuple that = (Tuple)o;
            return this.u == that.u && this.v == that.v || this.u == that.v && this.v == that.u;
        }

        public int hashCode() {
            return this.u ^ this.v;
        }
    }

    public static final class EdgeToBondMap {
        private final Map<Tuple, IBond> lookup;

        private EdgeToBondMap(int n) {
            this.lookup = Maps.newHashMapWithExpectedSize(n);
        }

        private IBond put(int v, int w, IBond bond) {
            return this.lookup.put(new Tuple(v, w), bond);
        }

        public IBond get(int v, int w) {
            return this.lookup.get(new Tuple(v, w));
        }

        public static EdgeToBondMap withSpaceFor(IAtomContainer container) {
            return new EdgeToBondMap(container.getBondCount());
        }
    }
}

