/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.graph.BitMatrix;
import org.openscience.cdk.graph.InitialCycles;

final class GreedyBasis {
    private final List<InitialCycles.Cycle> basis;
    private final BitSet edgesOfBasis;
    private final int m;

    GreedyBasis(int n, int m3) {
        this.basis = new ArrayList<InitialCycles.Cycle>(n);
        this.edgesOfBasis = new BitSet(m3);
        this.m = m3;
    }

    final List<InitialCycles.Cycle> members() {
        return Collections.unmodifiableList(this.basis);
    }

    final int size() {
        return this.members().size();
    }

    final void add(InitialCycles.Cycle cycle) {
        this.basis.add(cycle);
        this.edgesOfBasis.or(cycle.edgeVector());
    }

    final void addAll(Iterable<InitialCycles.Cycle> cycles) {
        for (InitialCycles.Cycle cycle : cycles) {
            this.add(cycle);
        }
    }

    final boolean isSubsetOfBasis(InitialCycles.Cycle cycle) {
        BitSet edgeVector = cycle.edgeVector();
        int intersect = GreedyBasis.and(this.edgesOfBasis, edgeVector).cardinality();
        return intersect == cycle.length();
    }

    final boolean isIndependent(InitialCycles.Cycle candidate) {
        if (this.basis.isEmpty() || !this.isSubsetOfBasis(candidate)) {
            return true;
        }
        BitMatrix matrix = BitMatrix.from(this.basis, candidate);
        matrix.eliminate();
        return !matrix.eliminated(this.basis.size());
    }

    private static final BitSet and(BitSet s2, BitSet t) {
        BitSet u = (BitSet)s2.clone();
        u.and(t);
        return u;
    }
}

