/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.openscience.cdk.graph.MinimumCycleBasis;
import org.openscience.cdk.graph.ShortestPaths;

public final class TripletShortCycles {
    private final int[][] graph;
    private final boolean canonical;
    private final Set<Path> basis = new TreeSet<Path>();

    public TripletShortCycles(MinimumCycleBasis mcb, boolean canonical) {
        this.graph = TripletShortCycles.copy(mcb.graph);
        this.canonical = canonical;
        for (int[] path : mcb.paths()) {
            this.basis.add(new Path(Arrays.copyOf(path, path.length - 1)));
        }
        int ord = this.graph.length;
        int[] nCycles = TripletShortCycles.nCycles(this.basis, ord);
        for (int v = 0; v < ord; ++v) {
            if (nCycles[v] <= 1) continue;
            this.findTriple(v);
        }
    }

    public int[][] paths() {
        int i = 0;
        int[][] paths = new int[this.size()][];
        for (Path path : this.basis) {
            paths[i++] = path.toArray();
        }
        return paths;
    }

    public int size() {
        return this.basis.size();
    }

    private void findTriple(int v) {
        int[] ws = this.graph[v];
        int deg = ws.length;
        this.disconnect(ws, v);
        for (int i = 0; i < deg; ++i) {
            ShortestPaths sp = new ShortestPaths(this.graph, null, ws[i]);
            for (int j = i + 1; j < deg; ++j) {
                Object paths;
                Object object;
                if (this.canonical && this.exists(ws[i], v, ws[j]) || sp.nPathsTo(ws[j]) <= 0) continue;
                if (this.canonical) {
                    int[][] nArrayArray = new int[1][];
                    object = nArrayArray;
                    nArrayArray[0] = sp.pathTo(ws[j]);
                } else {
                    object = sp.pathsTo(ws[j]);
                }
                for (int[] path : paths = object) {
                    this.basis.add(new Path(TripletShortCycles.append(path, v)));
                }
            }
        }
        this.reconnect(ws, v);
    }

    private boolean exists(int u, int v, int w) {
        for (Path path : this.basis) {
            if (!path.contains(u, v, w)) continue;
            return true;
        }
        return false;
    }

    private void disconnect(int[] ws, int v) {
        for (int w : ws) {
            int deg = this.graph[w].length;
            for (int i = 0; i < deg; ++i) {
                if (this.graph[w][i] != v) continue;
                this.graph[w][i] = w;
            }
        }
    }

    private void reconnect(int[] ws, int v) {
        for (int w : ws) {
            int deg = this.graph[w].length;
            for (int i = 0; i < deg; ++i) {
                if (this.graph[w][i] != w) continue;
                this.graph[w][i] = v;
            }
        }
    }

    private static int[] append(int[] p, int v) {
        int[] q = Arrays.copyOf(p, p.length + 1);
        q[p.length] = v;
        return q;
    }

    private static int[] nCycles(Iterable<Path> basis, int ord) {
        int[] nCycles = new int[ord];
        for (Path path : basis) {
            int[] nArray = path.vertices;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int v;
                int n2 = v = nArray[i];
                nCycles[n2] = nCycles[n2] + 1;
            }
        }
        return nCycles;
    }

    static int[] lexicographic(int[] p) {
        int len;
        int off = TripletShortCycles.min(p);
        boolean rev = p[(off + 1) % (len = p.length)] > p[(len + off - 1) % len];
        int[] q = new int[len];
        if (rev) {
            for (int i = 0; i < len; ++i) {
                q[(len - i) % len] = p[(off + i) % len];
            }
        } else {
            for (int i = 0; i < len; ++i) {
                q[i] = p[(off + i) % len];
            }
        }
        return q;
    }

    private static int min(int[] xs) {
        int min2 = 0;
        for (int i = 0; i < xs.length; ++i) {
            if (xs[i] >= xs[min2]) continue;
            min2 = i;
        }
        return min2;
    }

    private static int[][] copy(int[][] g2) {
        int ord = g2.length;
        int[][] h2 = new int[ord][];
        for (int v = 0; v < ord; ++v) {
            h2[v] = Arrays.copyOf(g2[v], g2[v].length);
        }
        return h2;
    }

    private static class Path
    implements Comparable<Path> {
        private int[] vertices;

        private Path(int[] vertices) {
            this.vertices = TripletShortCycles.lexicographic(vertices);
        }

        private boolean contains(int u, int v, int w) {
            int len = this.vertices.length;
            for (int i = 0; i < len; ++i) {
                if (this.vertices[i] != v) continue;
                int next = this.vertices[(i + 1) % len];
                int prev = this.vertices[(len + i - 1) % len];
                return prev == u && next == w || prev == w && next == u;
            }
            return false;
        }

        private int len() {
            return this.vertices.length;
        }

        private int[] toArray() {
            int[] p = Arrays.copyOf(this.vertices, this.len() + 1);
            p[this.len()] = p[0];
            return p;
        }

        @Override
        public int compareTo(Path that) {
            if (this.len() > that.len()) {
                return 1;
            }
            if (this.len() < that.len()) {
                return -1;
            }
            for (int i = 0; i < this.len(); ++i) {
                if (this.vertices[i] > that.vertices[i]) {
                    return 1;
                }
                if (this.vertices[i] >= that.vertices[i]) continue;
                return -1;
            }
            return 0;
        }
    }
}

