/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math;

import org.openscience.cdk.math.Matrix;
import org.openscience.cdk.math.Vector;

public class Quaternion {
    private double a;
    private double b;
    private double c;
    private double d;

    public Quaternion() {
        this.d = 0.0;
        this.c = 0.0;
        this.b = 0.0;
        this.a = 0.0;
    }

    public Quaternion(double a, double b, double c, double d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public Quaternion(Vector axis, double angle) {
        double sin_a = Math.sin(angle / 2.0);
        double cos_a = Math.cos(angle / 2.0);
        if (axis.size >= 3) {
            this.a = axis.vector[0] / sin_a;
            this.b = axis.vector[1] / sin_a;
            this.c = axis.vector[2] / sin_a;
            this.d = cos_a;
        } else {
            this.c = 0.0;
            this.b = 0.0;
            this.a = 0.0;
            this.d = cos_a;
        }
    }

    public Quaternion(double latitude, double longitude, double angle) {
        double sin_a = Math.sin(angle / 2.0);
        double cos_a = Math.cos(angle / 2.0);
        double sin_lat = Math.sin(latitude);
        double cos_lat = Math.cos(latitude);
        double sin_long = Math.sin(longitude);
        double cos_long = Math.cos(longitude);
        this.a = sin_a * cos_lat * sin_long;
        this.b = sin_a * sin_lat;
        this.c = sin_a * sin_lat * cos_long;
        this.d = cos_a;
    }

    public Quaternion add(Quaternion q) {
        return new Quaternion(this.a + q.a, this.b + q.b, this.c + q.c, this.d + q.d);
    }

    public Quaternion sub(Quaternion q) {
        return new Quaternion(this.a - q.a, this.b - q.b, this.c - q.c, this.d - q.d);
    }

    public Quaternion negate() {
        return new Quaternion(-this.a, -this.b, -this.c, -this.d);
    }

    public Quaternion mul(Quaternion q) {
        return new Quaternion(this.a * q.a - this.b * q.b - this.c * q.c - this.d * q.d, this.a * q.b + this.b * q.a + this.c * q.d - this.d * q.c, this.a * q.c + this.c * q.a + this.d * q.b - this.b * q.d, this.a * q.d + this.d * q.a + this.a * q.c - this.c * q.b);
    }

    public Quaternion mul(double v) {
        return new Quaternion(this.a * v, this.b * v, this.c * v, this.d * v);
    }

    public Quaternion div(Quaternion q) {
        Quaternion temp1 = new Quaternion(q.a, -q.b, -q.c, -q.d);
        Quaternion temp2 = this.mul(temp1);
        temp1 = q.mul(temp1);
        return new Quaternion(temp2.a / temp1.a, temp2.b / temp1.a, temp2.c / temp1.a, temp2.d / temp1.a);
    }

    public Quaternion normalize() {
        double length = Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c + this.d * this.d);
        return new Quaternion(this.a / length, this.b / length, this.c / length, this.d / length);
    }

    public Quaternion sqrt() {
        double temp = 2.0 * this.a;
        return new Quaternion(this.a * this.a - this.b * this.b - this.c * this.c - this.d * this.d, temp * this.b, temp * this.c, temp * this.d);
    }

    public double mag_sq() {
        return this.a * this.a + this.b * this.b;
    }

    public double mag() {
        return Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c + this.d * this.d);
    }

    public Matrix toRotationMatrix() {
        Matrix result = new Matrix(4, 4);
        double xx = this.a * this.a;
        double xy = this.a * this.b;
        double xz = this.a * this.c;
        double xw = this.a * this.d;
        double yy = this.b * this.b;
        double yz = this.b * this.c;
        double yw = this.b * this.d;
        double zz = this.c * this.c;
        double zw = this.c * this.d;
        result.matrix[0][0] = 1.0 - 2.0 * (yy + zz);
        result.matrix[0][1] = 2.0 * (xy - zw);
        result.matrix[0][2] = 2.0 * (xz + yw);
        result.matrix[1][0] = 2.0 * (xy + zw);
        result.matrix[1][1] = 1.0 - 2.0 * (xx + zz);
        result.matrix[1][2] = 2.0 * (yz - xw);
        result.matrix[2][0] = 2.0 * (xz - yw);
        result.matrix[2][1] = 2.0 * (yz + xw);
        result.matrix[2][2] = 1.0 - 2.0 * (xx + yy);
        result.matrix[2][3] = 0.0;
        result.matrix[1][3] = 0.0;
        result.matrix[0][3] = 0.0;
        result.matrix[3][2] = 0.0;
        result.matrix[3][1] = 0.0;
        result.matrix[3][0] = 0.0;
        result.matrix[3][3] = 1.0;
        return result;
    }

    public static Quaternion fromRotationMatrix(Matrix m3) {
        if (m3.rows < 3 || m3.columns < 3) {
            return null;
        }
        double trace = m3.matrix[0][0] + m3.matrix[1][1] + m3.matrix[2][2] + 1.0;
        if (trace > 0.0) {
            double S = 0.5 / Math.sqrt(trace);
            double a = (m3.matrix[2][1] - m3.matrix[1][2]) * S;
            double b = (m3.matrix[0][2] - m3.matrix[2][0]) * S;
            double c = (m3.matrix[1][0] - m3.matrix[0][1]) * S;
            double d = 0.25 / S;
            return new Quaternion(a, b, c, d);
        }
        if (m3.matrix[0][0] > m3.matrix[1][1] && m3.matrix[0][0] > m3.matrix[2][2]) {
            double S = Math.sqrt(1.0 + m3.matrix[0][0] - m3.matrix[1][1] - m3.matrix[2][2]) * 2.0;
            double a = 0.5 / S;
            double b = (m3.matrix[0][1] + m3.matrix[1][0]) / S;
            double c = (m3.matrix[0][2] + m3.matrix[2][0]) / S;
            double d = (m3.matrix[1][2] + m3.matrix[2][1]) / S;
            return new Quaternion(a, b, c, d);
        }
        if (m3.matrix[1][1] > m3.matrix[0][0] && m3.matrix[1][1] > m3.matrix[2][2]) {
            double S = Math.sqrt(1.0 + m3.matrix[1][1] - m3.matrix[0][0] - m3.matrix[2][2]) * 2.0;
            double a = (m3.matrix[0][1] + m3.matrix[1][0]) / S;
            double b = 0.5 / S;
            double c = (m3.matrix[1][2] + m3.matrix[2][1]) / S;
            double d = (m3.matrix[0][2] + m3.matrix[2][0]) / S;
            return new Quaternion(a, b, c, d);
        }
        double S = Math.sqrt(1.0 + m3.matrix[2][2] - m3.matrix[0][0] - m3.matrix[1][1]) * 2.0;
        double a = (m3.matrix[0][2] + m3.matrix[2][0]) / S;
        double b = (m3.matrix[1][2] + m3.matrix[2][1]) / S;
        double c = 0.5 / S;
        double d = (m3.matrix[0][1] + m3.matrix[1][0]) / S;
        return new Quaternion(a, b, c, d);
    }

    public String toString() {
        return "(" + this.a + "," + this.b + "," + this.c + "," + this.d + ")";
    }
}

