/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.modeling.builder3d;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class MMFF94BasedParameterSetReader {
    private final ILoggingTool LOG = LoggingToolFactory.createLoggingTool(MMFF94BasedParameterSetReader.class);
    private String configFile = "org/openscience/cdk/modeling/forcefield/data/mmff94.prm";
    private InputStream ins = null;
    private Map<String, Object> parameterSet = new Hashtable<String, Object>();
    private List<IAtomType> atomTypes = new Vector<IAtomType>();
    private StringTokenizer st;
    private String key = "";
    private String sid;
    private String configFilevdW = "org/openscience/cdk/modeling/forcefield/data/mmffvdw.prm";
    private InputStream insvdW = null;
    private StringTokenizer stvdW;
    private String sidvdW;
    private String configFileDFSB = "org/openscience/cdk/modeling/forcefield/data/mmffdfsb.par";
    private InputStream insDFSB;
    private StringTokenizer stDFSB;

    public Map<String, Object> getParamterSet() {
        return this.parameterSet;
    }

    public List<IAtomType> getAtomTypes() {
        return this.atomTypes;
    }

    public void setInputStream(InputStream ins) {
        this.ins = ins;
    }

    private void setAtomTypeData() throws Exception {
        this.key = "data" + this.sid;
        Vector<Object> data = new Vector<Object>();
        String sradius = this.st.nextToken();
        String swell = this.st.nextToken();
        String sapol = this.st.nextToken();
        String sNeff = this.st.nextToken();
        String sDA = this.st.nextToken();
        String sq0 = this.st.nextToken();
        String spbci = this.st.nextToken();
        String sfcadj = this.st.nextToken();
        this.stvdW.nextToken();
        this.stvdW.nextToken();
        String sA = this.stvdW.nextToken();
        String sG = this.stvdW.nextToken();
        try {
            double well = new Double(swell);
            double apol = new Double(sapol);
            double Neff = new Double(sNeff);
            double fcadj = new Double(sfcadj);
            double a = new Double(sA);
            double g2 = new Double(sG);
            data.add(new Double(well));
            data.add(new Double(apol));
            data.add(new Double(Neff));
            data.add(new String(sDA));
            data.add(new Double(fcadj));
            data.add(new Double(spbci));
            data.add(new Double(a));
            data.add(new Double(g2));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Data: Malformed Number due to:" + nfe);
        }
        this.LOG.debug("data : well,apol,Neff,sDA,fcadj,spbci,a,g " + data);
        this.parameterSet.put(this.key, data);
        this.key = "vdw" + this.sid;
        data = new Vector();
        try {
            double radius = new Double(sradius);
            data.add(new Double(radius));
        }
        catch (NumberFormatException nfe2) {
            this.LOG.debug("vdwError: Malformed Number due to:" + nfe2);
        }
        this.parameterSet.put(this.key, data);
        this.key = "charge" + this.sid;
        data = new Vector();
        try {
            double q0 = new Double(sq0);
            data.add(new Double(q0));
        }
        catch (NumberFormatException nfe3) {
            System.err.println("Charge: Malformed Number due to:" + nfe3);
        }
        this.parameterSet.put(this.key, data);
    }

    private void setAtomTypes(IChemObjectBuilder builder) throws Exception {
        String name = "";
        String rootType = "";
        int rl = 255;
        int gl = 20;
        int bl = 147;
        int maxbond = 0;
        int atomNr = 0;
        double mass = 0.0;
        this.st.nextToken();
        String sid = this.st.nextToken();
        rootType = this.st.nextToken();
        String smaxbond = this.st.nextToken();
        String satomNr = this.st.nextToken();
        String smass = this.st.nextToken();
        name = this.st.nextToken();
        try {
            maxbond = Integer.parseInt(smaxbond);
            mass = Double.parseDouble(smass);
            atomNr = Integer.parseInt(satomNr);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("AtomTypeTable.ReadAtypes: Malformed Number");
        }
        IAtomType atomType = builder.newInstance(IAtomType.class, name, rootType);
        atomType.setAtomicNumber(atomNr);
        atomType.setExactMass(mass);
        atomType.setMassNumber(this.massNumber(atomNr, mass));
        atomType.setFormalNeighbourCount(maxbond);
        atomType.setSymbol(rootType);
        Color co = new Color(rl, gl, bl);
        atomType.setProperty("org.openscience.cdk.renderer.color", co);
        atomType.setAtomTypeName(sid);
        this.atomTypes.add(atomType);
    }

    private void setBond() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String scode = this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String slen = this.st.nextToken();
        String sk2 = this.st.nextToken();
        String sk3 = this.st.nextToken();
        String sk4 = this.st.nextToken();
        String sbci = this.st.nextToken();
        try {
            double len = new Double(slen);
            double k2 = new Double(sk2);
            double k3 = new Double(sk3);
            double k4 = new Double(sk4);
            double bci = new Double(sbci);
            data.add(new Double(len));
            data.add(new Double(k2));
            data.add(new Double(k3));
            data.add(new Double(k4));
            data.add(new Double(bci));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setBond: Malformed Number due to:" + nfe);
        }
        this.key = "bond" + sid1 + ";" + sid2;
        this.parameterSet.put(this.key, data);
    }

    private void setAngle() throws Exception {
        Vector data = new Vector();
        this.st.nextToken();
        String scode = this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String sid3 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        String value3 = this.st.nextToken();
        String value4 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            double va3 = new Double(value3);
            double va4 = new Double(value4);
            data.add(new Double(va1));
            data.add(new Double(va2));
            data.add(new Double(va3));
            data.add(new Double(va4));
            this.key = "angle" + sid1 + ";" + sid2 + ";" + sid3;
            if (this.parameterSet.containsKey(this.key)) {
                data = (Vector)this.parameterSet.get(this.key);
                data.add(new Double(va1));
                data.add(new Double(va2));
                data.add(new Double(va3));
                data.add(new Double(va4));
            }
            this.parameterSet.put(this.key, data);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setAngle: Malformed Number due to:" + nfe);
        }
    }

    private void setStrBnd() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String scode = this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String sid3 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            data.add(new Double(va1));
            data.add(new Double(va2));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setStrBnd: Malformed Number due to:" + nfe);
        }
        this.key = "strbnd" + scode + ";" + sid1 + ";" + sid2 + ";" + sid3;
        this.LOG.debug("key =" + this.key);
        this.parameterSet.put(this.key, data);
    }

    private void setTorsion() throws Exception {
        Vector data = null;
        this.st.nextToken();
        String scode = this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String sid3 = this.st.nextToken();
        String sid4 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        String value3 = this.st.nextToken();
        String value4 = this.st.nextToken();
        String value5 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            double va3 = new Double(value3);
            double va4 = new Double(value4);
            double va5 = new Double(value5);
            this.key = "torsion" + scode + ";" + sid1 + ";" + sid2 + ";" + sid3 + ";" + sid4;
            this.LOG.debug("key = " + this.key);
            if (this.parameterSet.containsKey(this.key)) {
                data = (Vector)this.parameterSet.get(this.key);
                data.add(new Double(va1));
                data.add(new Double(va2));
                data.add(new Double(va3));
                data.add(new Double(va4));
                data.add(new Double(va5));
                this.LOG.debug("data = " + data);
            } else {
                data = new Vector();
                data.add(new Double(va1));
                data.add(new Double(va2));
                data.add(new Double(va3));
                data.add(new Double(va4));
                data.add(new Double(va5));
                this.LOG.debug("data = " + data);
            }
            this.parameterSet.put(this.key, data);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setTorsion: Malformed Number due to:" + nfe);
        }
    }

    private void setOpBend() throws Exception {
        Vector data = new Vector();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String sid3 = this.st.nextToken();
        String sid4 = this.st.nextToken();
        String value1 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            data.add(new Double(va1));
            this.key = "opbend" + sid1 + ";" + sid2 + ";" + sid3 + ";" + sid4;
            if (this.parameterSet.containsKey(this.key)) {
                data = (Vector)this.parameterSet.get(this.key);
                data.add(new Double(va1));
            }
            this.parameterSet.put(this.key, data);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setOpBend: Malformed Number due to:" + nfe);
        }
    }

    private void setDefaultStrBnd() throws Exception {
        this.LOG.debug("Sets the Default Stretch-Bend Parameters");
        Vector<Double> data = new Vector<Double>();
        this.stDFSB.nextToken();
        String sIR = this.stDFSB.nextToken();
        String sJR = this.stDFSB.nextToken();
        String sKR = this.stDFSB.nextToken();
        String skbaIJK = this.stDFSB.nextToken();
        String skbaKJI = this.stDFSB.nextToken();
        try {
            this.key = "DFSB" + sIR + ";" + sJR + ";" + sKR;
            double kbaIJK = new Double(skbaIJK);
            double kbaKJI = new Double(skbaKJI);
            data.add(new Double(kbaIJK));
            data.add(new Double(kbaKJI));
            this.parameterSet.put(this.key, data);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setDFSB: Malformed Number due to:" + nfe);
        }
    }

    public void readParameterSets(IChemObjectBuilder builder) throws Exception {
        this.LOG.debug("------ Read MMFF94 ParameterSets ------");
        if (this.ins == null) {
            ClassLoader loader = this.getClass().getClassLoader();
            this.ins = loader.getResourceAsStream(this.configFile);
        }
        if (this.ins == null) {
            throw new IOException("There was a problem getting the default stream: " + this.configFile);
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(this.ins), 1024);
        int[] a = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        if (this.insvdW == null) {
            this.insvdW = this.getClass().getClassLoader().getResourceAsStream(this.configFilevdW);
        }
        if (this.insvdW == null) {
            throw new IOException("There was a problem getting the default stream: " + this.configFilevdW);
        }
        BufferedReader rvdW = new BufferedReader(new InputStreamReader(this.insvdW), 1024);
        if (this.insDFSB == null) {
            this.insDFSB = this.getClass().getClassLoader().getResourceAsStream(this.configFileDFSB);
        }
        if (this.insDFSB == null) {
            throw new IOException("There was a problem getting the default stream: " + this.configFileDFSB);
        }
        BufferedReader rDFSB = new BufferedReader(new InputStreamReader(this.insDFSB), 1024);
        try {
            String s2;
            block4: while ((s2 = r.readLine()) != null) {
                String svdW;
                this.st = new StringTokenizer(s2, "\t; ");
                int nt = this.st.countTokens();
                if (s2.startsWith("atom") & nt <= 8) {
                    this.setAtomTypes(builder);
                    a[0] = a[0] + 1;
                    continue;
                }
                if (s2.startsWith("bond") & nt == 9) {
                    this.setBond();
                    a[1] = a[1] + 1;
                    continue;
                }
                if (s2.startsWith("angle") & nt <= 10) {
                    this.setAngle();
                    a[2] = a[2] + 1;
                    continue;
                }
                if (s2.startsWith("strbnd") & nt == 7) {
                    this.setStrBnd();
                    a[3] = a[3] + 1;
                    continue;
                }
                if (s2.startsWith("torsion") & nt == 11) {
                    this.setTorsion();
                    a[4] = a[4] + 1;
                    continue;
                }
                if (s2.startsWith("opbend") & nt == 6) {
                    this.setOpBend();
                    a[5] = a[5] + 1;
                    continue;
                }
                if (!(s2.startsWith("data") & nt == 10)) continue;
                while ((svdW = rvdW.readLine()) != null) {
                    this.stvdW = new StringTokenizer(svdW, "\t; ");
                    int ntvdW = this.stvdW.countTokens();
                    this.LOG.debug("ntvdW : " + ntvdW);
                    if (!(svdW.startsWith("vdw") & ntvdW == 9)) continue;
                    this.st.nextToken();
                    this.sid = this.st.nextToken();
                    this.stvdW.nextToken();
                    this.sidvdW = this.stvdW.nextToken();
                    if (!this.sid.equals(this.sidvdW)) continue block4;
                    this.setAtomTypeData();
                    a[6] = a[6] + 1;
                    continue block4;
                }
            }
            this.ins.close();
            this.insvdW.close();
        }
        catch (IOException e) {
            throw new IOException("There was a problem parsing the mmff94 forcefield");
        }
        try {
            this.LOG.debug("Parses the Default Stretch-Bend Parameters");
            while (true) {
                String sDFSB = rDFSB.readLine();
                this.LOG.debug("sDFSB = " + sDFSB);
                if (sDFSB == null) break;
                this.stDFSB = new StringTokenizer(sDFSB, "\t; ");
                int ntDFSB = this.stDFSB.countTokens();
                this.LOG.debug("ntDFSB : " + ntDFSB);
                if (!(sDFSB.startsWith("DFSB") & ntDFSB == 6)) continue;
                this.setDefaultStrBnd();
            }
            this.LOG.debug("sDFSB == null, break");
            this.insDFSB.close();
            this.LOG.debug("insDFSB closed");
        }
        catch (IOException e) {
            throw new IOException("There was a problem parsing the Default Stretch-Bend Parameters (mmffdfsb.par)");
        }
    }

    private Integer massNumber(int atomicNumber, double exactMass) throws IOException {
        String symbol = PeriodicTable.getSymbol(atomicNumber);
        IIsotope isotope = Isotopes.getInstance().getIsotope(symbol, exactMass, 0.001);
        return isotope != null ? isotope.getMassNumber() : null;
    }
}

