/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.util.List;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;

public class ProtonTotalPartialChargeDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private GasteigerMarsiliPartialCharges peoe = null;
    private List<IAtom> neighboors;
    private final int MAX_PROTON_COUNT = 5;

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#protonPartialCharge", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        String[] labels = new String[5];
        for (int i = 0; i < 5; ++i) {
            labels[i] = "protonTotalPartialCharge" + (i + 1);
        }
        return labels;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        DoubleArrayResult result = new DoubleArrayResult(5);
        for (int i = 0; i < this.neighboors.size() + 1; ++i) {
            result.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames(), e);
    }

    @Override
    public DescriptorValue calculate(IAtom atom, IAtomContainer ac) {
        IAtomContainer clone;
        this.neighboors = ac.getConnectedAtomsList(atom);
        try {
            clone = ac.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        try {
            this.peoe = new GasteigerMarsiliPartialCharges();
            this.peoe.setMaxGasteigerIters(6.0);
            this.peoe.assignGasteigerMarsiliSigmaPartialCharges(clone, true);
        }
        catch (Exception exception) {
            return this.getDummyDescriptorValue(exception);
        }
        IAtom localAtom = clone.getAtom(ac.indexOf(atom));
        this.neighboors = clone.getConnectedAtomsList(localAtom);
        DoubleArrayResult protonPartialCharge = new DoubleArrayResult(5);
        assert (this.neighboors.size() < 5);
        protonPartialCharge.add(localAtom.getCharge());
        int hydrogenNeighbors = 0;
        for (IAtom neighboor : this.neighboors) {
            if (neighboor.getAtomicNumber() != 1) continue;
            ++hydrogenNeighbors;
            protonPartialCharge.add(neighboor.getCharge());
        }
        int remainder = 5 - (hydrogenNeighbors + 1);
        for (int i = 0; i < remainder; ++i) {
            protonPartialCharge.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), protonPartialCharge, this.getDescriptorNames());
    }

    @Override
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }
}

