/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;

final class VecmathUtil {
    private static final double TAU = Math.PI * 2;

    private VecmathUtil() {
    }

    static Point2D toAwtPoint(Point2d point) {
        return new Point2D.Double(point.x, point.y);
    }

    static Point2d toVecmathPoint(Point2D point) {
        return new Point2d(point.getX(), point.getY());
    }

    static Vector2d newUnitVector(Tuple2d from, Tuple2d to) {
        Vector2d vector = new Vector2d(to.x - from.x, to.y - from.y);
        vector.normalize();
        return vector;
    }

    static Vector2d newUnitVector(IAtom atom, IBond bond) {
        return VecmathUtil.newUnitVector(atom.getPoint2d(), bond.getOther(atom).getPoint2d());
    }

    static List<Vector2d> newUnitVectors(IAtom fromAtom, List<IAtom> toAtoms) {
        ArrayList<Vector2d> unitVectors = new ArrayList<Vector2d>(toAtoms.size());
        for (IAtom toAtom : toAtoms) {
            unitVectors.add(VecmathUtil.newUnitVector(fromAtom.getPoint2d(), toAtom.getPoint2d()));
        }
        return unitVectors;
    }

    static Vector2d newPerpendicularVector(Vector2d vector) {
        return new Vector2d(-vector.y, vector.x);
    }

    static Point2d midpoint(Point2d a, Point2d b) {
        return new Point2d((a.x + b.x) / 2.0, (a.y + b.y) / 2.0);
    }

    static Vector2d scale(Tuple2d vector, double factor) {
        Vector2d cpy = new Vector2d(vector);
        cpy.scale(factor);
        return cpy;
    }

    static Vector2d sum(Tuple2d a, Tuple2d b) {
        return new Vector2d(a.x + b.x, a.y + b.y);
    }

    static Vector2d negate(Tuple2d vector) {
        return new Vector2d(-vector.x, -vector.y);
    }

    static Point2d intersection(Tuple2d p1, Tuple2d d1, Tuple2d p2, Tuple2d d2) {
        Vector2d p1End = VecmathUtil.sum(p1, d1);
        Vector2d p2End = VecmathUtil.sum(p2, d2);
        return VecmathUtil.intersection(p1.x, p1.y, p1End.x, p1End.y, p2.x, p2.y, p2End.x, p2End.y);
    }

    static Point2d intersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double x = ((x2 - x1) * (x3 * y4 - x4 * y3) - (x4 - x3) * (x1 * y2 - x2 * y1)) / ((x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4));
        double y = ((y3 - y4) * (x1 * y2 - x2 * y1) - (y1 - y2) * (x3 * y4 - x4 * y3)) / ((x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4));
        return new Point2d(x, y);
    }

    static double adjacentLength(Vector2d hypotenuse, Vector2d adjacent, double oppositeLength) {
        return Math.tan(hypotenuse.angle(adjacent)) * oppositeLength;
    }

    static Vector2d average(Collection<Vector2d> vectors) {
        Vector2d average = new Vector2d(0.0, 0.0);
        for (Vector2d vector : vectors) {
            average.add(vector);
        }
        average.scale(1.0 / (double)vectors.size());
        return average;
    }

    static Vector2d getNearestVector(Vector2d reference, List<Vector2d> vectors) {
        if (vectors.isEmpty()) {
            throw new IllegalArgumentException("No vectors provided");
        }
        Vector2d closest = vectors.get(0);
        double maxProd = reference.dot(closest);
        for (int i = 1; i < vectors.size(); ++i) {
            double newProd = reference.dot(vectors.get(i));
            if (!(newProd > maxProd)) continue;
            maxProd = newProd;
            closest = vectors.get(i);
        }
        return closest;
    }

    static Vector2d getNearestVector(Vector2d reference, IAtom fromAtom, List<IBond> bonds) {
        ArrayList<IAtom> toAtoms = new ArrayList<IAtom>();
        for (IBond bond : bonds) {
            toAtoms.add(bond.getOther(fromAtom));
        }
        return VecmathUtil.getNearestVector(reference, VecmathUtil.newUnitVectors(fromAtom, toAtoms));
    }

    static double extent(Vector2d vector) {
        double radians2 = Math.atan2(vector.y, vector.x);
        return radians2 < 0.0 ? Math.PI * 2 + radians2 : radians2;
    }

    static double[] extents(List<Vector2d> vectors) {
        int n = vectors.size();
        double[] extents = new double[n];
        for (int i = 0; i < n; ++i) {
            extents[i] = VecmathUtil.extent(vectors.get(i));
        }
        return extents;
    }

    static Vector2d newVectorInLargestGap(List<Vector2d> vectors) {
        assert (vectors.size() > 1);
        double[] extents = VecmathUtil.extents(vectors);
        Arrays.sort(extents);
        double max = -1.0;
        int index = -1;
        for (int i = 0; i < vectors.size(); ++i) {
            double delta;
            double extent = extents[(i + 1) % vectors.size()] - extents[i];
            if (extent < 0.0) {
                extent += Math.PI * 2;
            }
            if ((delta = extent - max) > 0.01) {
                max = extent;
                index = i;
                continue;
            }
            if (!(extents[i] < Math.PI * 2 && extents[i] + extent > Math.PI * 2) && (!(extents[i] < Math.PI) || !(extents[i] + extent > Math.PI))) continue;
            max = extent;
            index = i;
        }
        assert (index >= 0);
        double mid = max / 2.0;
        double theta = extents[index] + mid;
        return new Vector2d(Math.cos(theta), Math.sin(theta));
    }
}

