/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class CxSmilesState {
    Map<Integer, String> atomLabels = null;
    Map<Integer, String> atomValues = null;
    List<double[]> atomCoords = null;
    List<List<Integer>> fragGroups = null;
    Map<Integer, Radical> atomRads = null;
    Map<Integer, List<Integer>> ligandOrdering = null;
    Map<Integer, List<Integer>> positionVar = null;
    List<CxSgroup> mysgroups = null;
    boolean coordFlag = false;
    boolean racemic = false;
    List<Integer> racemicFrags = null;
    Map<Integer, Integer> stereoGrps = null;

    CxSmilesState() {
    }

    static String escape(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (CxSmilesState.isEscapeChar(c)) {
                sb.append("&#").append((int)c).append(';');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isEscapeChar(char c) {
        return c < ' ' || c > '~' || c == '|' || c == '{' || c == '}' || c == ',' || c == ';' || c == ':' || c == '$';
    }

    static final class CxPolymerSgroup
    extends CxSgroup {
        final String type;
        final String subscript;
        final String supscript;

        CxPolymerSgroup(String type, List<Integer> atomset, String subscript, String supscript) {
            assert (type != null && atomset != null);
            this.type = type;
            this.atoms = new ArrayList<Integer>(atomset);
            this.subscript = subscript;
            this.supscript = supscript;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CxPolymerSgroup that = (CxPolymerSgroup)o;
            return this.type.equals(that.type) && this.atoms.equals(that.atoms) && this.subscript.equals(that.subscript) && this.supscript.equals(that.supscript);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.atoms, this.subscript, this.supscript, this.children);
        }

        public String toString() {
            return "PolymerSgroup{type='" + this.type + '\'' + ", atomset=" + this.atoms + ", subscript='" + this.subscript + '\'' + ", supscript='" + this.supscript + '\'' + '}';
        }
    }

    static final class CxDataSgroup
    extends CxSgroup {
        final String field;
        final String value;
        final String operator;
        final String unit;
        final String tag;

        public CxDataSgroup(List<Integer> atoms, String field, String value, String operator, String unit, String tag) {
            this.atoms = atoms;
            this.field = field;
            this.value = value;
            this.operator = operator;
            this.unit = unit;
            this.tag = tag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CxDataSgroup that = (CxDataSgroup)o;
            if (this.atoms != null ? !this.atoms.equals(that.atoms) : that.atoms != null) {
                return false;
            }
            if (this.field != null ? !this.field.equals(that.field) : that.field != null) {
                return false;
            }
            if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
                return false;
            }
            if (this.operator != null ? !this.operator.equals(that.operator) : that.operator != null) {
                return false;
            }
            if (this.unit != null ? !this.unit.equals(that.unit) : that.unit != null) {
                return false;
            }
            return this.tag != null ? this.tag.equals(that.tag) : that.tag == null;
        }

        public int hashCode() {
            int result = this.atoms != null ? this.atoms.hashCode() : 0;
            result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
            result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
            result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "DataSgroup{atoms=" + this.atoms + ", field='" + this.field + '\'' + ", value='" + this.value + '\'' + ", operator='" + this.operator + '\'' + ", unit='" + this.unit + '\'' + ", tag='" + this.tag + '\'' + '}';
        }
    }

    static class CxSgroup {
        Set<CxSgroup> children = new HashSet<CxSgroup>();
        List<Integer> atoms = new ArrayList<Integer>();
        int id = -1;

        CxSgroup() {
        }
    }

    static enum Radical {
        Monovalent,
        Divalent,
        DivalentSinglet,
        DivalentTriplet,
        Trivalent,
        TrivalentDoublet,
        TrivalentQuartet;

    }
}

