/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.RingManipulator;

@Deprecated
public class DeduceBondSystemTool {
    private AllRingsFinder allRingsFinder;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(DeduceBondSystemTool.class);
    private List<Integer[]> listOfRings = null;
    private boolean interrupted;

    public DeduceBondSystemTool() {
        this.allRingsFinder = new AllRingsFinder();
    }

    public DeduceBondSystemTool(AllRingsFinder ringFinder) {
        this.allRingsFinder = ringFinder;
    }

    public boolean isOK(IAtomContainer m3) throws CDKException {
        IRingSet rs = this.allRingsFinder.findAllRings(m3, 7);
        this.storeRingSystem(m3, rs);
        boolean StructureOK = this.isStructureOK(m3);
        IRingSet irs = this.removeExtraRings(m3);
        if (irs == null) {
            throw new CDKException("error in AllRingsFinder.findAllRings");
        }
        int count = this.getBadCount(m3, irs);
        return StructureOK && count == 0;
    }

    public IAtomContainer fixAromaticBondOrders(IAtomContainer atomContainer) throws CDKException {
        IAtomContainer iAtomContainer;
        for (IBond bond : atomContainer.bonds()) {
            if (!bond.isAromatic() || bond.getOrder() != IBond.Order.UNSET) continue;
            bond.setOrder(IBond.Order.SINGLE);
        }
        IRingSet rs = this.allRingsFinder.findAllRings(atomContainer, 7);
        this.storeRingSystem(atomContainer, rs);
        IRingSet ringSet = this.removeExtraRings(atomContainer);
        if (ringSet == null) {
            throw new CDKException("failure in AllRingsFinder.findAllRings");
        }
        ArrayList<List<List<String>>> MasterList = new ArrayList<List<List<String>>>();
        this.FixPyridineNOxides(atomContainer, ringSet);
        for (int i = 0; i <= ringSet.getAtomContainerCount() - 1; ++i) {
            IRing ring = (IRing)ringSet.getAtomContainer(i);
            if (ring.getAtomCount() == 5) {
                this.fiveMemberedRingPossibilities(atomContainer, ring, MasterList);
                continue;
            }
            if (ring.getAtomCount() == 6) {
                this.sixMemberedRingPossibilities(atomContainer, ring, MasterList);
                continue;
            }
            if (ring.getAtomCount() == 7) {
                this.sevenMemberedRingPossibilities(atomContainer, ring, MasterList);
                continue;
            }
            logger.debug("Found ring of size: " + ring.getAtomCount());
        }
        IAtomContainerSet som = atomContainer.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        int[] choices = new int[MasterList.size()];
        if (MasterList.size() > 0 && (iAtomContainer = this.loop(System.currentTimeMillis(), atomContainer, 0, MasterList, choices, som)) != null) {
            return iAtomContainer;
        }
        int mincount = 99999999;
        int best = -1;
        for (int i = 0; i <= som.getAtomContainerCount() - 1; ++i) {
            int count;
            IAtomContainer mol2 = som.getAtomContainer(i);
            ringSet = this.removeExtraRings(mol2);
            if (ringSet == null || (count = this.getBadCount(mol2, ringSet)) >= mincount) continue;
            mincount = count;
            best = i;
        }
        if (som.getAtomContainerCount() > 0) {
            return som.getAtomContainer(best);
        }
        return atomContainer;
    }

    private void FixPyridineNOxides(IAtomContainer atomContainer, IRingSet ringSet) {
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            IAtom ai = atomContainer.getAtom(i);
            if (!ai.getSymbol().equals("N") || ai.getFormalCharge() != null && ai.getFormalCharge() != 0 || !this.inRingSet(ai, ringSet)) continue;
            List<IAtom> ca = atomContainer.getConnectedAtomsList(ai);
            for (IAtom caj : ca) {
                if (!caj.getSymbol().equals("O") || atomContainer.getBond(ai, caj).getOrder() != IBond.Order.DOUBLE) continue;
                ai.setFormalCharge(1);
                caj.setFormalCharge(-1);
                atomContainer.getBond(ai, caj).setOrder(IBond.Order.SINGLE);
            }
        }
    }

    private void applyBonds(IAtomContainer m3, List<String> al) {
        for (int i = 0; i <= al.size() - 1; ++i) {
            String s2 = al.get(i);
            String s1 = s2.substring(0, s2.indexOf(45));
            String s22 = s2.substring(s2.indexOf(45) + 1, s2.length());
            int i1 = Integer.parseInt(s1);
            int i2 = Integer.parseInt(s22);
            IBond b = m3.getBond(m3.getAtom(i1), m3.getAtom(i2));
            b.setOrder(IBond.Order.DOUBLE);
        }
    }

    private void fiveMemberedRingPossibilities(IAtomContainer m3, IRing r, List<List<List<String>>> MasterList) {
        int[] num = new int[5];
        for (int j = 0; j <= 4; ++j) {
            num[j] = m3.indexOf(r.getAtom(j));
        }
        ArrayList<String> al1 = new ArrayList<String>();
        ArrayList<String> al2 = new ArrayList<String>();
        ArrayList<String> al3 = new ArrayList<String>();
        ArrayList<String> al4 = new ArrayList<String>();
        ArrayList<String> al5 = new ArrayList<String>();
        ArrayList<String> al6 = new ArrayList<String>();
        ArrayList<String> al7 = new ArrayList<String>();
        ArrayList<String> al8 = new ArrayList<String>();
        ArrayList<String> al9 = new ArrayList<String>();
        ArrayList<String> al10 = new ArrayList<String>();
        al1.add(num[1] + "-" + num[2]);
        al1.add(num[3] + "-" + num[4]);
        al2.add(num[2] + "-" + num[3]);
        al2.add(num[0] + "-" + num[4]);
        al3.add(num[0] + "-" + num[1]);
        al3.add(num[3] + "-" + num[4]);
        al4.add(num[0] + "-" + num[4]);
        al4.add(num[1] + "-" + num[2]);
        al5.add(num[0] + "-" + num[1]);
        al5.add(num[2] + "-" + num[3]);
        al6.add(num[0] + "-" + num[1]);
        al7.add(num[1] + "-" + num[2]);
        al8.add(num[2] + "-" + num[3]);
        al9.add(num[3] + "-" + num[4]);
        al10.add(num[4] + "-" + num[0]);
        ArrayList<ArrayList<String>> mal = new ArrayList<ArrayList<String>>();
        mal.add(al1);
        mal.add(al2);
        mal.add(al3);
        mal.add(al4);
        mal.add(al5);
        mal.add(al6);
        mal.add(al7);
        mal.add(al8);
        mal.add(al9);
        mal.add(al10);
        MasterList.add(mal);
    }

    private void sixMemberedRingPossibilities(IAtomContainer m3, IRing r, List<List<List<String>>> MasterList) {
        IAtom[] ringatoms = new IAtom[6];
        ringatoms[0] = r.getAtom(0);
        int[] num = new int[6];
        for (int j = 0; j <= 5; ++j) {
            num[j] = m3.indexOf(r.getAtom(j));
        }
        ArrayList<String> al1 = new ArrayList<String>();
        ArrayList<String> al2 = new ArrayList<String>();
        al1.add(num[0] + "-" + num[1]);
        al1.add(num[2] + "-" + num[3]);
        al1.add(num[4] + "-" + num[5]);
        al2.add(num[1] + "-" + num[2]);
        al2.add(num[3] + "-" + num[4]);
        al2.add(num[5] + "-" + num[0]);
        ArrayList<String> al3 = new ArrayList<String>();
        ArrayList<String> al4 = new ArrayList<String>();
        ArrayList<String> al5 = new ArrayList<String>();
        ArrayList<String> al6 = new ArrayList<String>();
        ArrayList<String> al7 = new ArrayList<String>();
        ArrayList<String> al8 = new ArrayList<String>();
        ArrayList<String> al9 = new ArrayList<String>();
        ArrayList<String> al10 = new ArrayList<String>();
        ArrayList<String> al11 = new ArrayList<String>();
        ArrayList<String> al12 = new ArrayList<String>();
        ArrayList<String> al13 = new ArrayList<String>();
        ArrayList<String> al14 = new ArrayList<String>();
        ArrayList<String> al15 = new ArrayList<String>();
        ArrayList<String> al16 = new ArrayList<String>();
        ArrayList<String> al17 = new ArrayList<String>();
        ArrayList al18 = new ArrayList();
        al3.add(num[0] + "-" + num[1]);
        al3.add(num[2] + "-" + num[3]);
        al4.add(num[0] + "-" + num[1]);
        al4.add(num[4] + "-" + num[5]);
        al5.add(num[1] + "-" + num[2]);
        al5.add(num[3] + "-" + num[4]);
        al6.add(num[1] + "-" + num[2]);
        al6.add(num[0] + "-" + num[5]);
        al7.add(num[2] + "-" + num[3]);
        al7.add(num[4] + "-" + num[5]);
        al8.add(num[0] + "-" + num[5]);
        al8.add(num[3] + "-" + num[4]);
        al9.add(num[0] + "-" + num[1]);
        al9.add(num[3] + "-" + num[4]);
        al10.add(num[1] + "-" + num[2]);
        al10.add(num[4] + "-" + num[5]);
        al11.add(num[2] + "-" + num[3]);
        al11.add(num[0] + "-" + num[5]);
        al12.add(num[0] + "-" + num[1]);
        al13.add(num[1] + "-" + num[2]);
        al14.add(num[2] + "-" + num[3]);
        al15.add(num[3] + "-" + num[4]);
        al16.add(num[4] + "-" + num[5]);
        al17.add(num[5] + "-" + num[0]);
        ArrayList mal = new ArrayList();
        mal.add(al1);
        mal.add(al2);
        mal.add(al3);
        mal.add(al4);
        mal.add(al5);
        mal.add(al6);
        mal.add(al7);
        mal.add(al8);
        mal.add(al9);
        mal.add(al10);
        mal.add(al11);
        mal.add(al12);
        mal.add(al13);
        mal.add(al14);
        mal.add(al15);
        mal.add(al16);
        mal.add(al17);
        mal.add(al18);
        MasterList.add(mal);
    }

    private void sevenMemberedRingPossibilities(IAtomContainer m3, IRing r, List<List<List<String>>> MasterList) {
        IAtom[] ringatoms = new IAtom[7];
        ringatoms[0] = r.getAtom(0);
        int[] num = new int[7];
        for (int j = 0; j <= 6; ++j) {
            num[j] = m3.indexOf(r.getAtom(j));
        }
        ArrayList<String> al1 = new ArrayList<String>();
        ArrayList<String> al2 = new ArrayList<String>();
        ArrayList<String> al3 = new ArrayList<String>();
        ArrayList<String> al4 = new ArrayList<String>();
        ArrayList<String> al5 = new ArrayList<String>();
        al1.add(num[0] + "-" + num[1]);
        al1.add(num[2] + "-" + num[3]);
        al1.add(num[4] + "-" + num[5]);
        al2.add(num[0] + "-" + num[1]);
        al2.add(num[2] + "-" + num[3]);
        al2.add(num[5] + "-" + num[6]);
        al3.add(num[1] + "-" + num[2]);
        al3.add(num[3] + "-" + num[4]);
        al3.add(num[5] + "-" + num[6]);
        al4.add(num[1] + "-" + num[2]);
        al4.add(num[3] + "-" + num[4]);
        al4.add(num[6] + "-" + num[0]);
        al5.add(num[2] + "-" + num[3]);
        al5.add(num[4] + "-" + num[5]);
        al5.add(num[6] + "-" + num[0]);
        ArrayList<ArrayList<String>> mal = new ArrayList<ArrayList<String>>();
        mal.add(al1);
        mal.add(al2);
        mal.add(al3);
        mal.add(al4);
        mal.add(al5);
        MasterList.add(mal);
    }

    private int getBadCount(IAtomContainer atomContainer, IRingSet ringSet) {
        int count = 0;
        for (int j = 0; j <= atomContainer.getAtomCount() - 1; ++j) {
            IAtom atom = atomContainer.getAtom(j);
            if (!this.inRingSet(atom, ringSet)) continue;
            if (atom.getSymbol().equals("N")) {
                if (atom.getFormalCharge() == 0) {
                    if (atomContainer.getBondOrderSum(atom) == 4.0) {
                        ++count;
                        continue;
                    }
                    if (atomContainer.getBondOrderSum(atom) != 5.0) continue;
                    int doublebondcount = 0;
                    List<IAtom> ca = atomContainer.getConnectedAtomsList(atom);
                    for (int k = 0; k <= ca.size() - 1; ++k) {
                        if (atomContainer.getBond(atom, ca.get(k)).getOrder() != IBond.Order.DOUBLE || !this.inRingSet(ca.get(k), ringSet)) continue;
                        ++doublebondcount;
                    }
                    if (doublebondcount != 2) continue;
                    ++count;
                    continue;
                }
                if (atom.getFormalCharge() != 1 || atomContainer.getBondOrderSum(atom) != 5.0) continue;
                ++count;
                continue;
            }
            if (!atom.getSymbol().equals("S") || !(atomContainer.getBondOrderSum(atom) > 2.0)) continue;
            ++count;
        }
        return count;
    }

    private boolean inRingSet(IAtom atom, IRingSet ringSet) {
        for (int i = 0; i < ringSet.getAtomContainerCount(); ++i) {
            IRing ring = (IRing)ringSet.getAtomContainer(i);
            if (!ring.contains(atom)) continue;
            return true;
        }
        return false;
    }

    private IAtomContainer loop(long starttime, IAtomContainer atomContainer, int index, List<List<List<String>>> MasterList, int[] choices, IAtomContainerSet som) throws CDKException {
        long time = System.currentTimeMillis();
        long diff = time - starttime;
        if (diff > 100000L) {
            throw new CDKException("Timed out after 100 seconds.");
        }
        if (this.interrupted) {
            this.interrupted = false;
            throw new CDKException("Process was interrupted.");
        }
        List<List<String>> ringlist = MasterList.get(index);
        IAtomContainer mnew2 = null;
        for (int i = 0; i <= ringlist.size() - 1; ++i) {
            choices[index] = i;
            if (index == MasterList.size() - 1) {
                IRingSet rs;
                IAtomContainer mnew = null;
                try {
                    mnew = atomContainer.clone();
                }
                catch (Exception e) {
                    logger.error("Failed to clone atomContainer: ", e.getMessage());
                    logger.debug(e);
                }
                for (int j = 0; j <= MasterList.size() - 1; ++j) {
                    List<List<String>> ringlist2 = MasterList.get(j);
                    List<String> bondlist = ringlist2.get(choices[j]);
                    this.applyBonds(mnew, bondlist);
                }
                if (this.isStructureOK(mnew) && (rs = this.removeExtraRings(mnew)) != null) {
                    int count = this.getBadCount(mnew, rs);
                    if (count == 0) {
                        return mnew;
                    }
                    som.addAtomContainer(mnew);
                }
            }
            if (index + 1 <= MasterList.size() - 1) {
                mnew2 = this.loop(starttime, atomContainer, index + 1, MasterList, choices, som);
            }
            if (!(mnew2 instanceof IAtomContainer)) continue;
            return mnew2;
        }
        return null;
    }

    private boolean isStructureOK(IAtomContainer atomContainer) {
        try {
            int i;
            CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(atomContainer.getBuilder());
            for (IAtom atom : atomContainer.atoms()) {
                IAtomType matched = matcher.findMatchingAtomType(atomContainer, atom);
                if (matched != null && !matched.getAtomTypeName().equals("X")) continue;
                return false;
            }
            IRingSet ringSet = this.recoverRingSystem(atomContainer);
            for (i = 0; i <= atomContainer.getAtomCount() - 1; ++i) {
                atomContainer.getAtom(i).setFlag(32, false);
            }
            for (i = 0; i <= ringSet.getAtomContainerCount() - 1; ++i) {
                IRing r = (IRing)ringSet.getAtomContainer(i);
                r.setFlag(32, false);
            }
            Aromaticity.cdkLegacy().apply(atomContainer);
            for (i = 0; i <= ringSet.getAtomContainerCount() - 1; ++i) {
                IRing ring = (IRing)ringSet.getAtomContainer(i);
                RingManipulator.markAromaticRings(ring);
            }
            boolean[] Check = this.findRingsToCheck(ringSet);
            for (int i2 = 0; i2 <= ringSet.getAtomContainerCount() - 1; ++i2) {
                IRing ring = (IRing)ringSet.getAtomContainer(i2);
                if (!Check[i2]) continue;
                for (int j = 0; j <= ring.getAtomCount() - 1; ++j) {
                    if (ring.getAtom(j).getImplicitHydrogenCount() == CDKConstants.UNSET || ring.getAtom(j).getImplicitHydrogenCount() >= 0) continue;
                    return false;
                }
                if (ring.getFlag(32)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.debug(e.toString());
            return false;
        }
    }

    private IRingSet removeExtraRings(IAtomContainer m3) {
        try {
            IRingSet rs = Cycles.sssr(m3).toRingSet();
            block2: for (int i = 0; i <= rs.getAtomContainerCount() - 1; ++i) {
                IRing r = (IRing)rs.getAtomContainer(i);
                if (r.getAtomCount() > 7 || r.getAtomCount() < 5) {
                    rs.removeAtomContainer(i);
                    --i;
                    continue;
                }
                for (int j = 0; j <= r.getAtomCount() - 1; ++j) {
                    if (r.getAtom(j).getHybridization() != CDKConstants.UNSET && (r.getAtom(j).getHybridization() == IAtomType.Hybridization.SP2 || r.getAtom(j).getHybridization() == IAtomType.Hybridization.PLANAR3)) continue;
                    rs.removeAtomContainer(i);
                    --i;
                    continue block2;
                }
            }
            return rs;
        }
        catch (Exception e) {
            return m3.getBuilder().newInstance(IRingSet.class, new Object[0]);
        }
    }

    private boolean[] findRingsToCheck(IRingSet rs) {
        int i;
        boolean[] Check = new boolean[rs.getAtomContainerCount()];
        for (i = 0; i <= Check.length - 1; ++i) {
            Check[i] = true;
        }
        block1: for (i = 0; i <= rs.getAtomContainerCount() - 1; ++i) {
            IRing r = (IRing)rs.getAtomContainer(i);
            if (r.getAtomCount() > 7) {
                Check[i] = false;
                continue;
            }
            int NonSP2Count = 0;
            for (int j = 0; j <= r.getAtomCount() - 1; ++j) {
                if (r.getAtom(j).getHybridization() != CDKConstants.UNSET && r.getAtom(j).getHybridization() == IAtomType.Hybridization.SP2) continue;
                ++NonSP2Count;
                if (!r.getAtom(j).getSymbol().equals("C")) continue;
                Check[i] = false;
                continue block1;
            }
            if (NonSP2Count <= true) continue;
            Check[i] = false;
        }
        return Check;
    }

    private void storeRingSystem(IAtomContainer mol2, IRingSet ringSet) {
        this.listOfRings = new ArrayList<Integer[]>();
        for (int r = 0; r < ringSet.getAtomContainerCount(); ++r) {
            IRing ring = (IRing)ringSet.getAtomContainer(r);
            Integer[] bondNumbers = new Integer[ring.getBondCount()];
            for (int i = 0; i < ring.getBondCount(); ++i) {
                bondNumbers[i] = mol2.indexOf(ring.getBond(i));
            }
            this.listOfRings.add(bondNumbers);
        }
    }

    private IRingSet recoverRingSystem(IAtomContainer mol2) {
        IRingSet ringSet = mol2.getBuilder().newInstance(IRingSet.class, new Object[0]);
        for (Integer[] bondNumbers : this.listOfRings) {
            IRing ring = mol2.getBuilder().newInstance(IRing.class, bondNumbers.length);
            Integer[] integerArray = bondNumbers;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int bondNumber = integerArray[i];
                IBond bond = mol2.getBond(bondNumber);
                ring.addBond(bond);
                if (!ring.contains(bond.getBegin())) {
                    ring.addAtom(bond.getBegin());
                }
                if (ring.contains(bond.getEnd())) continue;
                ring.addAtom(bond.getEnd());
            }
            ringSet.addAtomContainer(ring);
        }
        return ringSet;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }
}

