/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.IDeduceBondOrderTool;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.IValencyChecker;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.SaturationChecker;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class AtomTypeAwareSaturationChecker
implements IValencyChecker,
IDeduceBondOrderTool {
    SaturationChecker staturationChecker = new SaturationChecker();
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(SaturationChecker.class);
    private IBond.Order oldBondOrder;
    private int startBond;

    public void decideBondOrder(IAtomContainer atomContainer, boolean atomsSaturated) throws CDKException {
        if (atomContainer.getBondCount() == 0) {
            return;
        }
        this.startBond = 0;
        int saturnatedAtoms = 0;
        int[] bestGuess = new int[]{this.startBond, saturnatedAtoms};
        if (atomsSaturated) {
            do {
                if (this.startBond == atomContainer.getBondCount()) {
                    if (bestGuess[1] == 0) {
                        throw new CDKException("Can't find any solution");
                    }
                    this.decideBondOrder(atomContainer, bestGuess[0]);
                    double satAtoms = (double)bestGuess[1] * 1.0 / (double)atomContainer.getAtomCount() * 10000.0;
                    satAtoms = Math.round(satAtoms) / 100L;
                    logger.warn("Can't find any solution where all atoms are saturated. A best guess gives " + satAtoms + "% Saturated atoms.");
                    return;
                }
                this.decideBondOrder(atomContainer, this.startBond);
                saturnatedAtoms = 0;
                for (IAtom atom : atomContainer.atoms()) {
                    if (!this.isSaturated(atom, atomContainer)) continue;
                    ++saturnatedAtoms;
                }
                if (bestGuess[1] < saturnatedAtoms) {
                    bestGuess[0] = this.startBond;
                    bestGuess[1] = saturnatedAtoms;
                }
                ++this.startBond;
            } while (!this.isSaturated(atomContainer));
        } else {
            this.decideBondOrder(atomContainer, this.startBond);
        }
    }

    public void decideBondOrder(IAtomContainer atomContainer) throws CDKException {
        this.decideBondOrder(atomContainer, true);
    }

    private void decideBondOrder(IAtomContainer atomContainer, int start) throws CDKException {
        int i;
        for (i = 0; i < atomContainer.getBondCount(); ++i) {
            if (!atomContainer.getBond(i).getFlag(4096)) continue;
            atomContainer.getBond(i).setOrder(IBond.Order.SINGLE);
        }
        for (i = start; i < atomContainer.getBondCount(); ++i) {
            this.checkBond(atomContainer, i);
        }
        if (start > 0) {
            for (i = start - 1; i >= 0; --i) {
                this.checkBond(atomContainer, i);
            }
        }
    }

    private void checkBond(IAtomContainer atomContainer, int index) throws CDKException {
        IBond bond = atomContainer.getBond(index);
        if (bond != null && bond.getFlag(4096)) {
            try {
                this.oldBondOrder = bond.getOrder();
                bond.setOrder(IBond.Order.SINGLE);
                this.setMaxBondOrder(bond, atomContainer);
            }
            catch (CDKException e) {
                bond.setOrder(this.oldBondOrder);
                logger.debug(e);
            }
        }
    }

    private void setMaxBondOrder(IBond bond, IAtomContainer atomContainer) throws CDKException {
        if (this.bondOrderCanBeIncreased(bond, atomContainer)) {
            if (bond.getOrder() != IBond.Order.QUADRUPLE) {
                bond.setOrder(BondManipulator.increaseBondOrder(bond.getOrder()));
            } else {
                throw new CDKException("Can't increase a quadruple bond!");
            }
        }
    }

    public boolean bondOrderCanBeIncreased(IBond bond, IAtomContainer atomContainer) throws CDKException {
        boolean atom0isUnsaturated = false;
        boolean atom1isUnsaturated = false;
        double sum = bond.getBegin().getBondOrderSum() == null ? this.getAtomBondordersum(bond.getEnd(), atomContainer) : bond.getBegin().getBondOrderSum().doubleValue();
        if (this.bondsUsed(bond.getBegin(), atomContainer) < sum) {
            atom0isUnsaturated = true;
        }
        sum = bond.getEnd().getBondOrderSum() == null ? this.getAtomBondordersum(bond.getEnd(), atomContainer) : bond.getEnd().getBondOrderSum().doubleValue();
        if (this.bondsUsed(bond.getEnd(), atomContainer) < sum) {
            atom1isUnsaturated = true;
        }
        if (atom0isUnsaturated == atom1isUnsaturated) {
            return atom0isUnsaturated;
        }
        int myIndex = atomContainer.indexOf(bond);
        if (myIndex == 0) {
            return false;
        }
        if (atomContainer.getBond(myIndex - 1).getOrder() == IBond.Order.DOUBLE) {
            return false;
        }
        if (this.isConnected(atomContainer.getBond(myIndex), atomContainer.getBond(0))) {
            throw new CantDecideBondOrderException("Can't decide bond order of this bond");
        }
        return false;
    }

    private double getAtomBondordersum(IAtom atom, IAtomContainer mol2) throws CDKException {
        double sum = 0.0;
        for (IBond bond : mol2.bonds()) {
            if (!bond.contains(atom)) continue;
            sum += BondManipulator.destroyBondOrder(bond.getOrder());
        }
        return sum;
    }

    private boolean isConnected(IBond bond1, IBond bond2) {
        for (IAtom atom : bond1.atoms()) {
            if (!bond2.contains(atom)) continue;
            return true;
        }
        return false;
    }

    public double getMaxNoOfBonds(IAtom atom) throws CDKException {
        double noValenceElectrons;
        double d = noValenceElectrons = atom.getValency() == CDKConstants.UNSET ? -1.0 : (double)atom.getValency().intValue();
        if (noValenceElectrons == -1.0) {
            throw new CDKException("Atom property not set: Valency");
        }
        return 8.0 - noValenceElectrons;
    }

    private double bondsUsed(IAtom atom, IAtomContainer atomContainer) throws CDKException {
        double charge;
        int implicitHydrogens;
        int bondsToAtom = 0;
        for (IBond bond : atomContainer.bonds()) {
            if (!bond.contains(atom)) continue;
            bondsToAtom = (int)((double)bondsToAtom + BondManipulator.destroyBondOrder(bond.getOrder()));
        }
        if (atom.getImplicitHydrogenCount() == CDKConstants.UNSET || atom.getImplicitHydrogenCount() == null) {
            if (atom.getValency() == CDKConstants.UNSET || atom.getValency() == null) {
                throw new CDKException("Atom " + atom.getAtomTypeName() + " has not got the valency set.");
            }
            if (atom.getFormalNeighbourCount() == CDKConstants.UNSET || atom.getFormalNeighbourCount() == null) {
                throw new CDKException("Atom " + atom.getAtomTypeName() + " has not got the formal neighbour count set.");
            }
            implicitHydrogens = 8 - atom.getValency() - atom.getFormalNeighbourCount();
            String warningMessage = "Number of implicite hydrogens not set for atom " + atom.getAtomTypeName() + ". Estimated it to: " + implicitHydrogens;
            logger.warn(warningMessage);
        } else {
            implicitHydrogens = atom.getImplicitHydrogenCount();
        }
        if (atom.getCharge() == CDKConstants.UNSET) {
            if (atom.getFormalCharge() == CDKConstants.UNSET) {
                charge = 0.0;
                String warningMessage = "Neither charge nor formal charge is set for atom " + atom.getAtomTypeName() + ". Estimate it to: 0";
                logger.warn(warningMessage);
            } else {
                charge = atom.getFormalCharge().intValue();
            }
        } else {
            charge = atom.getCharge();
        }
        return (double)bondsToAtom - charge + (double)implicitHydrogens;
    }

    @Override
    public void saturate(IAtomContainer container) throws CDKException {
        this.staturationChecker.saturate(container);
    }

    @Override
    public boolean isSaturated(IAtomContainer container) throws CDKException {
        return this.staturationChecker.isSaturated(container);
    }

    @Override
    public boolean isSaturated(IAtom atom, IAtomContainer container) throws CDKException {
        return this.staturationChecker.isSaturated(atom, container);
    }

    private class CantDecideBondOrderException
    extends CDKException {
        public CantDecideBondOrderException(String message) {
            super(message);
        }
    }
}

