/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainerCreator;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.type.PiBondingMovementReaction;
import org.openscience.cdk.reaction.type.RearrangementAnionReaction;
import org.openscience.cdk.reaction.type.RearrangementCationReaction;
import org.openscience.cdk.reaction.type.RearrangementLonePairReaction;
import org.openscience.cdk.reaction.type.RearrangementRadicalReaction;
import org.openscience.cdk.reaction.type.SharingLonePairReaction;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class StructureResonanceGenerator {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(StructureResonanceGenerator.class);
    private List<IReactionProcess> reactionsList = new ArrayList<IReactionProcess>();
    private boolean lookingSymmetry;
    private int maxStructures = 50;

    public StructureResonanceGenerator() {
        this(false);
    }

    public StructureResonanceGenerator(boolean lookingSymmetry) {
        this.logger.info("Initiate StructureResonanceGenerator");
        this.lookingSymmetry = lookingSymmetry;
        this.setDefaultReactions();
    }

    public void setReactions(List<IReactionProcess> newReactionsList) {
        this.reactionsList = newReactionsList;
    }

    public List<IReactionProcess> getReactions() {
        return this.reactionsList;
    }

    public void setMaximalStructures(int maxStruct) {
        this.maxStructures = maxStruct;
    }

    public int getMaximalStructures() {
        return this.maxStructures;
    }

    public void setDefaultReactions() {
        this.callDefaultReactions();
    }

    private void callDefaultReactions() {
        ArrayList<IParameterReact> paramList = new ArrayList<IParameterReact>();
        SetReactionCenter param = new SetReactionCenter();
        param.setParameter(Boolean.FALSE);
        paramList.add(param);
        ReactionEngine type = new SharingLonePairReaction();
        try {
            type.setParameterList(paramList);
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        this.reactionsList.add((IReactionProcess)((Object)type));
        type = new PiBondingMovementReaction();
        ArrayList<IParameterReact> paramList2 = new ArrayList<IParameterReact>();
        SetReactionCenter param2 = new SetReactionCenter();
        param2.setParameter(Boolean.FALSE);
        paramList2.add(param2);
        try {
            type.setParameterList(paramList2);
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        this.reactionsList.add((IReactionProcess)((Object)type));
        type = new RearrangementAnionReaction();
        try {
            type.setParameterList(paramList);
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        this.reactionsList.add((IReactionProcess)((Object)type));
        type = new RearrangementCationReaction();
        try {
            type.setParameterList(paramList);
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        this.reactionsList.add((IReactionProcess)((Object)type));
        type = new RearrangementLonePairReaction();
        try {
            type.setParameterList(paramList);
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        this.reactionsList.add((IReactionProcess)((Object)type));
        type = new RearrangementRadicalReaction();
        try {
            type.setParameterList(paramList);
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        this.reactionsList.add((IReactionProcess)((Object)type));
    }

    public IAtomContainerSet getStructures(IAtomContainer molecule) {
        int countStructure = 0;
        IAtomContainerSet setOfMol = molecule.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        setOfMol.addAtomContainer(molecule);
        for (int i = 0; i < setOfMol.getAtomContainerCount(); ++i) {
            IAtomContainer mol2 = setOfMol.getAtomContainer(i);
            Iterator<IReactionProcess> iterator = this.reactionsList.iterator();
            while (iterator.hasNext()) {
                IReactionProcess aReactionsList;
                IReactionProcess reaction = aReactionsList = iterator.next();
                IAtomContainerSet setOfReactants = molecule.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                setOfReactants.addAtomContainer(mol2);
                try {
                    IReactionSet setOfReactions = reaction.initiate(setOfReactants, null);
                    if (setOfReactions.getReactionCount() == 0) continue;
                    for (int k = 0; k < setOfReactions.getReactionCount(); ++k) {
                        for (int j = 0; j < setOfReactions.getReaction(k).getProducts().getAtomContainerCount(); ++j) {
                            IAtomContainer product = setOfReactions.getReaction(k).getProducts().getAtomContainer(j);
                            if (this.existAC(setOfMol, product)) continue;
                            setOfMol.addAtomContainer(product);
                            if (++countStructure <= this.maxStructures) continue;
                            return setOfMol;
                        }
                    }
                }
                catch (CDKException e) {
                    e.printStackTrace();
                }
            }
        }
        return setOfMol;
    }

    public IAtomContainerSet getContainers(IAtomContainer molecule) {
        int i;
        IAtomContainerSet setOfCont = molecule.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainerSet setOfMol = this.getStructures(molecule);
        if (setOfMol.getAtomContainerCount() == 0) {
            return setOfCont;
        }
        ArrayList<IBond> bondList = new ArrayList<IBond>();
        for (int i2 = 1; i2 < setOfMol.getAtomContainerCount(); ++i2) {
            IAtomContainer mol2 = setOfMol.getAtomContainer(i2);
            for (int j = 0; j < mol2.getBondCount(); ++j) {
                IBond bond = molecule.getBond(j);
                if (mol2.getBond(j).getOrder().equals((Object)bond.getOrder()) || bondList.contains(bond)) continue;
                bondList.add(bond);
            }
        }
        if (bondList.size() == 0) {
            return null;
        }
        int[] flagBelonging = new int[bondList.size()];
        for (int i3 = 0; i3 < flagBelonging.length; ++i3) {
            flagBelonging[i3] = 0;
        }
        int[] position = new int[bondList.size()];
        int maxGroup = 1;
        ArrayList newBondList = new ArrayList();
        newBondList.add(bondList.get(0));
        int pos = 0;
        block3: for (i = 0; i < newBondList.size(); ++i) {
            if (i == 0) {
                flagBelonging[i] = maxGroup;
            } else if (flagBelonging[position[i]] == 0) {
                flagBelonging[position[i]] = ++maxGroup;
            }
            IBond bondA = (IBond)newBondList.get(i);
            for (int ato = 0; ato < 2; ++ato) {
                IAtom atomA1 = bondA.getAtom(ato);
                List<IBond> bondA1s = molecule.getConnectedBondsList(atomA1);
                for (int j = 0; j < bondA1s.size(); ++j) {
                    IBond bondB = bondA1s.get(j);
                    if (newBondList.contains(bondB)) continue;
                    for (int k = 0; k < bondList.size(); ++k) {
                        if (!((IBond)bondList.get(k)).equals(bondB) || flagBelonging[k] != 0) continue;
                        flagBelonging[k] = maxGroup;
                        newBondList.add(bondB);
                        position[++pos] = k;
                    }
                }
            }
            if (newBondList.size() - 1 != i) continue;
            for (int k = 0; k < bondList.size(); ++k) {
                if (newBondList.contains(bondList.get(k))) continue;
                newBondList.add(bondList.get(k));
                position[i + 1] = k;
                continue block3;
            }
        }
        for (i = 0; i < maxGroup; ++i) {
            IAtomContainer container = molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            for (int j = 0; j < bondList.size(); ++j) {
                if (flagBelonging[j] != i + 1) continue;
                IBond bond = (IBond)bondList.get(j);
                IAtom atomA1 = bond.getBegin();
                IAtom atomA2 = bond.getEnd();
                if (!container.contains(atomA1)) {
                    container.addAtom(atomA1);
                }
                if (!container.contains(atomA2)) {
                    container.addAtom(atomA2);
                }
                container.addBond(bond);
            }
            setOfCont.addAtomContainer(container);
        }
        return setOfCont;
    }

    public IAtomContainer getContainer(IAtomContainer molecule, IAtom atom) {
        IAtomContainerSet setOfCont = this.getContainers(molecule);
        if (setOfCont == null) {
            return null;
        }
        for (IAtomContainer container : setOfCont.atomContainers()) {
            if (!container.contains(atom)) continue;
            return container;
        }
        return null;
    }

    public IAtomContainer getContainer(IAtomContainer molecule, IBond bond) {
        IAtomContainerSet setOfCont = this.getContainers(molecule);
        if (setOfCont == null) {
            return null;
        }
        for (IAtomContainer container : setOfCont.atomContainers()) {
            if (!container.contains(bond)) continue;
            return container;
        }
        return null;
    }

    private boolean existAC(IAtomContainerSet set, IAtomContainer atomContainer) {
        IAtomContainer acClone = null;
        try {
            acClone = atomContainer.clone();
            if (!this.lookingSymmetry) {
                for (IAtom atom : acClone.atoms()) {
                    atom.setFlag(32, false);
                }
                for (IBond bond : acClone.bonds()) {
                    bond.setFlag(32, false);
                }
            }
        }
        catch (CloneNotSupportedException e1) {
            e1.printStackTrace();
        }
        for (int i = 0; i < acClone.getAtomCount(); ++i) {
            acClone.getAtom(i).setID("" + acClone.indexOf(acClone.getAtom(i)));
        }
        if (this.lookingSymmetry) {
            try {
                Aromaticity.cdkLegacy().apply(acClone);
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
        } else if (!this.lookingSymmetry) {
            for (IAtom atom : acClone.atoms()) {
                atom.setFlag(32, false);
            }
            for (IBond bond : acClone.bonds()) {
                bond.setFlag(32, false);
            }
        }
        for (int i = 0; i < set.getAtomContainerCount(); ++i) {
            IAtomContainer ss = set.getAtomContainer(i);
            for (int j = 0; j < ss.getAtomCount(); ++j) {
                ss.getAtom(j).setID("" + ss.indexOf(ss.getAtom(j)));
            }
            try {
                QueryAtomContainer qAC;
                if (!this.lookingSymmetry) {
                    QueryAtomContainer qAC2;
                    qAC = QueryAtomContainerCreator.createSymbolChargeIDQueryContainer(acClone);
                    if (!new UniversalIsomorphismTester().isIsomorph(ss, qAC) || !new UniversalIsomorphismTester().isIsomorph(ss, qAC2 = QueryAtomContainerCreator.createSymbolAndBondOrderQueryContainer(acClone))) continue;
                    return true;
                }
                qAC = QueryAtomContainerCreator.createSymbolAndChargeQueryContainer(acClone);
                Aromaticity.cdkLegacy().apply(ss);
                if (!new UniversalIsomorphismTester().isIsomorph(ss, qAC)) continue;
                return true;
            }
            catch (CDKException e1) {
                System.err.println(e1);
                this.logger.error(e1.getMessage());
                this.logger.debug(e1);
            }
        }
        return false;
    }
}

