/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.AbstractJoin;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.euclid.Util;

public class CMLJoin
extends AbstractJoin {
    public static final String NS = "cml:join";
    public static final String CHILD_S = MoleculePointer.CHILD.toString();
    public static final String PARENT_S = MoleculePointer.PARENT.toString();
    public static final String PREVIOUS_S = MoleculePointer.PREVIOUS.toString();
    public static final String NEXT_S = MoleculePointer.NEXT.toString();
    public static final String R_GROUP = "R";
    public static final String TORSION_END = "cml:torsionEnd";
    public static final String TORSION_END_QUERY = "cml:label[@dictRef='cml:torsionEnd']";
    public static final String FRAGMENT_CONTAINER = "fragmentContainer";

    public CMLJoin() {
    }

    public CMLJoin(CMLJoin old) {
        super(old);
    }

    public Node copy() {
        return new CMLJoin(this);
    }

    public CMLElement makeElementInContext(Element parent) {
        return new CMLJoin();
    }

    public void finishMakingElement(Element parent) {
        super.finishMakingElement(parent);
    }

    private String getId(CMLMolecule molecule) {
        String ref = molecule.getRef();
        String id = molecule.getId();
        return ref + "_" + id;
    }

    public void processMoleculeRefs2AndAtomRefs2(CMLMolecule previousMolecule, CMLMolecule nextMolecule) {
        if (previousMolecule == null) {
            throw new RuntimeException("null PREVIOUS, check syntax");
        }
        if (nextMolecule == null) {
            throw new RuntimeException("null NEXT, check syntax");
        }
        String[] atomRefs2 = this.getAtomRefs2();
        if (atomRefs2 == null) {
            throw new RuntimeException("No atomrefs2 on Join");
        }
        this.setAtomRefs2(new String[]{this.getId(previousMolecule) + "_" + atomRefs2[0], this.getId(nextMolecule) + "_" + atomRefs2[1]});
        this.setMoleculeRefs2(new String[]{this.getId(previousMolecule), this.getId(nextMolecule)});
    }

    public String getString() {
        String[] atomRefs2;
        String[] moleculeRefs2;
        String s2 = "";
        String id = this.getId();
        if (id != null) {
            s2 = s2 + id + " ";
        }
        if ((moleculeRefs2 = this.getMoleculeRefs2()) != null) {
            s2 = s2 + Util.concatenate(moleculeRefs2, " ") + ";";
        }
        if ((atomRefs2 = this.getAtomRefs2()) != null) {
            s2 = s2 + Util.concatenate(atomRefs2, " ") + ";";
        }
        return s2;
    }

    public Element getParentOrPrevious() {
        if (this.getMoleculeRefs2Attribute().getValue().equals(PARENT_S + " " + CHILD_S)) {
            return (Element)this.getParent();
        }
        if (this.getMoleculeRefs2Attribute().getValue().equals(PREVIOUS_S + " " + NEXT_S)) {
            ParentNode parent = this.getParent();
            int position = parent.indexOf(this);
            if (position == 0) {
                return null;
            }
            return (Element)parent.getChild(position - 1);
        }
        return null;
    }

    public CMLElement getChildOrNext() {
        if (this.getMoleculeRefs2Attribute().getValue().equals(PARENT_S + " " + CHILD_S)) {
            if (this.getChildCount() > 0) {
                return (CMLElement)this.getChild(0);
            }
        } else if (this.getMoleculeRefs2Attribute().getValue().equals(PREVIOUS_S + " " + NEXT_S)) {
            ParentNode parent = this.getParent();
            int position = this.getParent().indexOf(this);
            if (position == parent.getChildCount() - 1) {
                return null;
            }
            return (CMLElement)parent.getChild(position + 1);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MoleculePointer {
        CHILD,
        NEXT,
        PARENT,
        PREVIOUS;

    }
}

