/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.IntRange;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.RealArray;

public class RealRange
implements EuclidConstants {
    protected double maxval;
    protected double minval;

    public RealRange() {
        this.minval = Double.POSITIVE_INFINITY;
        this.maxval = Double.NEGATIVE_INFINITY;
    }

    public RealRange(double minv, double maxv) {
        this.setRange(minv, maxv);
    }

    public RealRange(double minv, double maxv, boolean normalize) {
        if (minv > maxv) {
            double temp = minv;
            minv = maxv;
            maxv = temp;
        }
        this.setRange(minv, maxv);
    }

    public void setRange(double minv, double maxv) {
        this.maxval = maxv;
        this.minval = minv;
        if (this.minval > this.maxval) {
            this.minval = Double.POSITIVE_INFINITY;
            this.maxval = Double.NEGATIVE_INFINITY;
        }
    }

    public RealRange(RealRange r) {
        this.minval = r.minval;
        this.maxval = r.maxval;
    }

    public RealRange(IntRange ir) {
        this.minval = ir.minval;
        this.maxval = ir.maxval;
    }

    public static RealRange getRange(String s2) {
        RealRange rr = null;
        RealArray ra = new RealArray(s2);
        if (ra.size() == 2) {
            rr = new RealRange(ra.get(0), ra.get(1));
        }
        return rr;
    }

    public boolean isValid() {
        return this.minval <= this.maxval;
    }

    @Deprecated
    public boolean isEqualTo(RealRange r) {
        return r != null && Real.isEqual(this.minval, r.minval) && Real.isEqual(this.maxval, r.maxval) && this.minval <= this.maxval;
    }

    public boolean isEqualTo(RealRange r, double eps) {
        return r != null && Real.isEqual(this.minval, r.minval, eps) && Real.isEqual(this.maxval, r.maxval, eps) && this.minval <= this.maxval;
    }

    public RealRange plus(RealRange r2) {
        if (!this.isValid()) {
            if (r2 == null || !r2.isValid()) {
                return new RealRange();
            }
            return new RealRange(r2);
        }
        RealRange temp = new RealRange(Math.min(this.minval, r2.minval), Math.max(this.maxval, r2.maxval));
        return temp;
    }

    public RealRange intersectionWith(RealRange r2) {
        double maxv;
        double minv;
        RealRange inter = null;
        if (this.isValid() && r2 != null && r2.isValid() && (minv = Math.max(this.minval, r2.minval)) <= (maxv = Math.min(this.maxval, r2.maxval))) {
            inter = new RealRange(minv, maxv);
        }
        return inter;
    }

    public double getMin() {
        return this.minval;
    }

    public double getMax() {
        return this.maxval;
    }

    public double getMidPoint() {
        return (this.minval + this.maxval) * 0.5;
    }

    public double getRange() {
        if (!this.isValid()) {
            return Double.NaN;
        }
        return this.maxval - this.minval;
    }

    public boolean includes(RealRange r2) {
        return r2 != null && r2.isValid() && this.includes(r2.getMin()) && this.includes(r2.getMax());
    }

    public boolean includes(double f) {
        return f >= this.minval && f <= this.maxval;
    }

    public boolean contains(double f) {
        return this.includes(f);
    }

    public void add(double x) {
        this.maxval = Math.max(this.maxval, x);
        this.minval = Math.min(this.minval, x);
    }

    public double getRandomVariate() {
        double range = this.maxval - this.minval;
        return this.minval + Math.random() * range;
    }

    public double getScaleTo(RealRange range) {
        double scale = Double.NaN;
        return scale;
    }

    public void normalize() {
        if (this.minval > this.maxval) {
            double temp = this.minval;
            this.minval = this.maxval;
            this.maxval = temp;
        }
    }

    public double distanceOutside(double d) {
        double dd = Double.NaN;
        if (!Double.isNaN(d)) {
            dd = 0.0;
            if (d < this.minval) {
                dd = d - this.minval;
            } else if (d > this.maxval) {
                dd = this.maxval - d;
            }
        }
        return dd;
    }

    public String toString() {
        return this.minval > this.maxval ? "NULL" : "(" + this.minval + "," + this.maxval + ")";
    }
}

