/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.RandomNumberGenerator;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.Util;

public class Univariate {
    RealArray realArray;
    double[] array;
    int count;
    double mean = Double.NaN;
    double sum = Double.NaN;
    double median = Double.NaN;
    double variance = Double.NaN;
    double xMax = Double.NaN;
    double xMin = Double.NaN;
    double range = Double.NaN;
    double stdev = Double.NaN;
    RealArray deviateArray = null;
    RealArray zValueArray = null;
    boolean gotMean = false;
    boolean gotVariance = false;
    boolean gotStandardDeviation = false;
    boolean isSorted = false;
    int binCount;
    int[] bins;
    int[] binStart;
    double deltaX = Double.NaN;
    RealArray binArray = null;

    public Univariate() {
        this.init();
        this.realArray = new RealArray();
    }

    public Univariate(RealArray realArray) {
        this.init();
        this.setArray(realArray);
    }

    void init() {
        this.setBinCount(10);
    }

    public void setArray(RealArray realArray) {
        this.realArray = new RealArray(realArray);
        this.getCount();
    }

    public void setBinCount(int binCount) {
        this.binCount = binCount;
    }

    public int getBinCount() {
        return this.binCount;
    }

    public int getCount() {
        this.count = this.realArray.size();
        return this.count;
    }

    public double getMin() {
        this.xMin = this.realArray.smallestElement();
        return this.xMin;
    }

    public double getMax() {
        this.xMax = this.realArray.largestElement();
        return this.xMax;
    }

    public double getMean() {
        if (!this.gotMean || this.mean == Double.NaN) {
            this.count = this.realArray.size();
            if (this.count == 0) {
                throw new RuntimeException("No points");
            }
            this.sum = this.realArray.sumAllElements();
            this.mean = this.sum / (double)this.count;
            this.gotMean = true;
        }
        return this.mean;
    }

    public double getVariance() {
        if (!this.gotVariance) {
            this.getCount();
            if (this.count < 2) {
                throw new RuntimeException("Only one point");
            }
            this.getMean();
            double sumx2 = 0.0;
            this.getDeviateValues();
            double[] x = this.deviateArray.getArray();
            for (int i = 0; i < this.count; ++i) {
                sumx2 += x[i] * x[i];
            }
            this.variance = sumx2 / (double)(this.count - 1);
            this.gotVariance = true;
        }
        return this.variance;
    }

    public double getStandardDeviation() {
        this.getVariance();
        this.stdev = Math.sqrt(this.variance);
        return this.stdev;
    }

    public double getStandardError() {
        this.getVariance();
        return Math.sqrt(this.variance / (double)this.count);
    }

    public double[] getArray() {
        this.array = this.realArray.getArray();
        return this.array;
    }

    public double[] getSortedArray() {
        if (!this.isSorted) {
            this.realArray.sortAscending();
            this.getArray();
            this.isSorted = true;
        }
        return this.array;
    }

    public RealArray getNormalizedValues() {
        double[] array = this.realArray.getArray();
        this.getMean();
        this.getDeviateValues();
        double[] dvArray = this.deviateArray.getArray();
        this.getStandardDeviation();
        double[] normArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            normArray[i] = dvArray[i] / this.stdev;
        }
        this.zValueArray = new RealArray(normArray);
        return this.zValueArray;
    }

    public RealArray getDeviateValues() {
        double[] array = this.realArray.getArray();
        this.getMean();
        double[] dvArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            dvArray[i] = array[i] - this.mean;
        }
        this.deviateArray = new RealArray(dvArray);
        return this.deviateArray;
    }

    public double getQuantile(double q) {
        double quantile = Double.NaN;
        if (q > 1.0 || q < 0.0) {
            throw new RuntimeException("Quantile value out of range: " + q);
        }
        this.getSortedArray();
        double dindex = (double)(this.count + 1) * q;
        int index = (int)dindex;
        int flindex = (int)Math.floor(dindex);
        int cindex = (int)Math.ceil(dindex);
        quantile = dindex - (double)index == 0.0 ? this.array[index - 1] : q * this.array[flindex - 1] + (1.0 - q) * this.array[cindex - 1];
        return quantile;
    }

    public double getMedian() {
        this.median = this.getQuantile(0.5);
        return this.median;
    }

    void calculateSummaryStats() {
        this.getMin();
        this.getMax();
        this.getMean();
        this.getVariance();
        this.getStandardDeviation();
    }

    public RealArray getXValues() {
        this.range = this.realArray.getRange().getRange() + Real.getEpsilon();
        this.deltaX = this.range / (double)this.binCount;
        this.getMin();
        this.binArray = new RealArray(this.binCount, this.xMin, this.deltaX);
        return this.binArray;
    }

    public int[] getHistogramCounts() {
        if (this.realArray.size() < 2) {
            throw new RuntimeException("Too few points");
        }
        this.calculateSummaryStats();
        this.getXValues();
        this.getSortedArray();
        this.bins = new int[this.binCount];
        this.binStart = new int[this.binCount];
        int lastBin = -1;
        for (int i = 0; i < this.count; ++i) {
            double x = this.realArray.getArray()[i];
            double diff = x - this.xMin;
            int bin = (int)(diff / this.deltaX);
            if (bin < 0) {
                bin = 0;
            }
            if (bin >= this.binCount) {
                bin = this.binCount - 1;
            }
            if (bin > lastBin) {
                this.binStart[bin] = i;
                lastBin = bin;
            }
            int n = bin;
            this.bins[n] = this.bins[n] + 1;
        }
        return this.bins;
    }

    public static Univariate getNormalParams(int count) {
        double a = count <= 10 ? 0.375 : 0.5;
        double[] z = new double[count];
        for (int i = 0; i < count; ++i) {
            z[i] = Univariate.qnorm(((double)(i + 1) - a) / ((double)(count + 1) - 2.0 * a));
        }
        return new Univariate(new RealArray(z));
    }

    public static double qnorm(double p) {
        return Univariate.qnorm(p, true);
    }

    public static double qnorm(double p, boolean upper) {
        double ppnd;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Illegal argument " + p + " for qnorm(p).");
        }
        double split = 0.42;
        double a0 = 2.50662823884;
        double a1 = -18.61500062529;
        double a2 = 41.39119773534;
        double a3 = -25.44106049637;
        double b1 = -8.4735109309;
        double b2 = 23.08336743743;
        double b3 = -21.06224101826;
        double b4 = 3.13082909833;
        double c0 = -2.78718931138;
        double c1 = -2.29796479134;
        double c2 = 4.85014127135;
        double c3 = 2.32121276858;
        double d1 = 3.54388924762;
        double d2 = 1.63706781897;
        double q = p - 0.5;
        if (Math.abs(q) <= split) {
            double r = q * q;
            ppnd = q * (((a3 * r + a2) * r + a1) * r + a0) / ((((b4 * r + b3) * r + b2) * r + b1) * r + 1.0);
        } else {
            double r = p;
            if (q > 0.0) {
                r = 1.0 - p;
            }
            if (r > 0.0) {
                r = Math.sqrt(-Math.log(r));
                ppnd = (((c3 * r + c2) * r + c1) * r + c0) / ((d2 * r + d1) * r + 1.0);
                if (q < 0.0) {
                    ppnd = -ppnd;
                }
            } else {
                ppnd = 0.0;
            }
        }
        if (upper) {
            ppnd = 1.0 - ppnd;
        }
        return ppnd;
    }

    public static double qnorm(double p, boolean upper, double mu, double sigma2) {
        return Univariate.qnorm(p, upper) * Math.sqrt(sigma2) + mu;
    }

    public static double pnorm(double z, boolean upper) {
        double alnorm;
        double ltone = 7.0;
        double utzero = 18.66;
        double con = 1.28;
        double a1 = 0.398942280444;
        double a2 = 0.399903438504;
        double a3 = 5.75885480458;
        double a4 = 29.8213557808;
        double a5 = 2.62433121679;
        double a6 = 48.6959930692;
        double a7 = 5.92885724438;
        double b1 = 0.398942280385;
        double b2 = 3.8052E-8;
        double b3 = 1.00000615302;
        double b4 = 3.98064794E-4;
        double b5 = 1.986153813664;
        double b6 = 0.151679116635;
        double b7 = 5.29330324926;
        double b8 = 4.8385912808;
        double b9 = 15.1508972451;
        double b10 = 0.742380924027;
        double b11 = 30.789933034;
        double b12 = 3.99019417011;
        if (z < 0.0) {
            upper = !upper;
            z = -z;
        }
        if (z <= ltone || upper && z <= utzero) {
            double y = 0.5 * z * z;
            alnorm = z > con ? b1 * Math.exp(-y) / (z - b2 + b3 / (z + b4 + b5 / (z - b6 + b7 / (z + b8 - b9 / (z + b10 + b11 / (z + b12)))))) : 0.5 - z * (a1 - a2 * y / (y + a3 - a4 / (y + a5 + a6 / (y + a7))));
        } else {
            alnorm = 0.0;
        }
        if (!upper) {
            alnorm = 1.0 - alnorm;
        }
        return alnorm;
    }

    public static double pnorm(double x, boolean upper, double mu, double sigma2) {
        return Univariate.pnorm((x - mu) / Math.sqrt(sigma2), upper);
    }

    public static double qt(double p, double ndf, boolean lower_tail) {
        double q;
        double P;
        boolean neg;
        if (p <= 0.0 || p >= 1.0 || ndf < 1.0) {
            throw new IllegalArgumentException("Invalid p or df in call to qt(double,double,boolean).");
        }
        double eps = 1.0E-12;
        double M_PI_2 = 1.5707963267948966;
        if (lower_tail && p > 0.5 || !lower_tail && p < 0.5) {
            neg = false;
            P = 2.0 * (lower_tail ? 1.0 - p : p);
        } else {
            neg = true;
            P = 2.0 * (lower_tail ? p : 1.0 - p);
        }
        if (Math.abs(ndf - 2.0) < eps) {
            q = Math.sqrt(2.0 / (P * (2.0 - P)) - 2.0);
        } else if (ndf < 1.0 + eps) {
            double prob = P * M_PI_2;
            q = Math.cos(prob) / Math.sin(prob);
        } else {
            double a = 1.0 / (ndf - 0.5);
            double b = 48.0 / (a * a);
            double c = ((20700.0 * a / b - 98.0) * a - 16.0) * a + 96.36;
            double d = ((94.5 / (b + c) - 3.0) / b + 1.0) * Math.sqrt(a * M_PI_2) * ndf;
            double y = Math.pow(d * P, 2.0 / ndf);
            if (y > 0.05 + a) {
                double x = Univariate.qnorm(0.5 * P, false);
                y = x * x;
                if (ndf < 5.0) {
                    c += 0.3 * (ndf - 4.5) * (x + 0.6);
                }
                c = (((0.05 * d * x - 5.0) * x - 7.0) * x - 2.0) * x + b + c;
                y = (((((0.4 * y + 6.3) * y + 36.0) * y + 94.5) / c - y - 3.0) / b + 1.0) * x;
                y = (y = a * y * y) > 0.002 ? Math.exp(y) - 1.0 : (0.5 * y + 1.0) * y;
            } else {
                y = ((1.0 / (((ndf + 6.0) / (ndf * y) - 0.089 * d - 0.822) * (ndf + 2.0) * 3.0) + 0.5 / (ndf + 4.0)) * y - 1.0) * (ndf + 1.0) / (ndf + 2.0) + 1.0 / y;
            }
            q = Math.sqrt(ndf * y);
        }
        if (neg) {
            q = -q;
        }
        return q;
    }

    public static double pt(double t, double df) {
        double ks;
        double g1 = 0.3183098862;
        if (df < 1.0) {
            throw new IllegalArgumentException("Illegal argument df for pt(t,df).");
        }
        double idf = df;
        double a = t / Math.sqrt(idf);
        double b = idf / (idf + t * t);
        double im2 = df - 2.0;
        double ioe = idf % 2.0;
        double s2 = 1.0;
        double c = 1.0;
        idf = 1.0;
        double fk = ks = 2.0 + ioe;
        if (im2 >= 2.0) {
            for (double k = ks; k <= im2; k += 2.0) {
                if ((s2 += (c = c * b * (fk - 1.0) / fk)) == idf) continue;
                idf = s2;
                fk += 2.0;
            }
        }
        if (ioe != 1.0) {
            return 0.5 + 0.5 * a * Math.sqrt(b) * s2;
        }
        if (df == 1.0) {
            s2 = 0.0;
        }
        return 0.5 + (a * b * s2 + Math.atan(a)) * g1;
    }

    public double pchisq(double q, double df) {
        double prob;
        double df2 = df * 0.5;
        double q2 = q * 0.5;
        int n = 5;
        if (q <= 0.0 || df <= 0.0) {
            throw new IllegalArgumentException("Illegal argument " + q + " or " + df + " for qnorm(p).");
        }
        if (q < df) {
            double tk = q2 * ((double)(1 - n) - df2) / (df2 + (double)(2 * n) - 1.0 + (double)n * q2 / (df2 + (double)(2 * n)));
            for (int k = n - 1; k > 1; --k) {
                tk = q2 * ((double)(1 - k) - df2) / (df2 + (double)(2 * k) - 1.0 + (double)k * q2 / (df2 + (double)(2 * k) + tk));
            }
            double CFL = 1.0 - q2 / (df2 + 1.0 + q2 / (df2 + 2.0 + tk));
            prob = Math.exp(df2 * Math.log(q2) - q2 - Univariate.lnfgamma(df2 + 1.0) - Math.log(CFL));
        } else {
            double tk = ((double)n - df2) / (q2 + (double)n);
            for (int k = n - 1; k > 1; --k) {
                tk = ((double)k - df2) / (q2 + (double)k / (1.0 + tk));
            }
            double CFU = 1.0 + (1.0 - df2) / (q2 + 1.0 / (1.0 + tk));
            prob = 1.0 - Math.exp((df2 - 1.0) * Math.log(q2) - q2 - Univariate.lnfgamma(df2) - Math.log(CFU));
        }
        return prob;
    }

    public static double betainv(double x, double p, double q) {
        boolean indx;
        double qq;
        double pp;
        double x2;
        double beta = Univariate.lnfbeta(p, q);
        double acu = 1.0E-14;
        if (p <= 0.0 || q <= 0.0) {
            return -1.0;
        }
        if (x <= 0.0 || x >= 1.0) {
            return -1.0;
        }
        double psq = p + q;
        double cx = 1.0 - x;
        if (p < psq * x) {
            x2 = cx;
            cx = x;
            pp = q;
            qq = p;
            indx = true;
        } else {
            x2 = x;
            pp = p;
            qq = q;
            indx = false;
        }
        double term = 1.0;
        double ai = 1.0;
        double betain = 1.0;
        double ns = qq + cx * psq;
        double rx = x2 / cx;
        double temp = qq - ai;
        if (ns == 0.0) {
            rx = x2;
        }
        while (temp > acu && temp > acu * betain) {
            term = term * temp * rx / (pp + ai);
            betain += term;
            temp = Math.abs(term);
            if (!(temp > acu) || !(temp > acu * betain)) continue;
            ai += 1.0;
            if ((ns -= 1.0) >= 0.0) {
                temp = qq - ai;
                if (ns != 0.0) continue;
                rx = x2;
                continue;
            }
            temp = psq;
            psq += 1.0;
        }
        betain *= Math.exp(pp * Math.log(x2) + (qq - 1.0) * Math.log(cx) - beta) / pp;
        if (indx) {
            betain = 1.0 - betain;
        }
        return betain;
    }

    public static double pf(double x, double df1, double df2) {
        return Univariate.betainv(df1 * x / (df1 * x + df2), 0.5 * df1, 0.5 * df2);
    }

    public static void test() {
        Util.println("--------------Testing Univariate--------------\n");
        RandomNumberGenerator rng = new RandomNumberGenerator();
        int npoints1 = 1000;
        double[] data1 = new double[npoints1];
        for (int i = 0; i < npoints1; ++i) {
            data1[i] = rng.nextGaussian();
        }
        RealArray dataArray1 = new RealArray(data1);
        Univariate univ1 = new Univariate(dataArray1);
        Util.println("mean: " + univ1.getMean());
        Util.println("sdev: " + univ1.getStandardDeviation());
        int npoints2 = 300;
        double[] data2 = new double[npoints2];
        for (int i = 0; i < npoints2; ++i) {
            data2[i] = rng.nextGaussian() * 0.5 + 5.0;
        }
        RealArray dataArray2 = new RealArray(data2);
        Univariate univ2 = new Univariate(dataArray2);
        Util.println("mean: " + univ2.getMean());
        Util.println("sdev: " + univ2.getStandardDeviation());
        dataArray1.addArray(dataArray2);
        Univariate univ3 = new Univariate(dataArray1);
        Util.println("mean: " + univ3.getMean());
        Util.println("sdev: " + univ3.getStandardDeviation());
        Util.println("min: " + univ3.getMin());
        Util.println("q1: " + univ3.getQuantile(0.25));
        Util.println("median: " + univ3.getMedian());
        Util.println("q3: " + univ3.getQuantile(0.75));
        Util.println("max: " + univ3.getMax());
        univ3.setBinCount(30);
        int[] bins = univ3.getHistogramCounts();
        for (int i = 0; i < bins.length; ++i) {
            Util.println("bin: " + bins[i]);
        }
        Univariate norm = Univariate.getNormalParams(1000);
        Util.println("mean: " + norm.getMean());
        Util.println("sdev: " + norm.getStandardDeviation());
        Util.println("min: " + norm.getMin());
        Util.println("q1: " + norm.getQuantile(0.25));
        Util.println("median: " + norm.getMedian());
        Util.println("q3: " + norm.getQuantile(0.75));
        Util.println("max: " + norm.getMax());
    }

    public static double lnfgamma(double c) {
        double x;
        double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double y = x = c;
        double tmp = x + 5.5 - (x + 0.5) * Math.log(x + 5.5);
        double ser = 1.000000000190015;
        for (int j = 0; j <= 5; ++j) {
            ser += cof[j] / (y += 1.0);
        }
        return Math.log(2.5066282746310007 * ser / x) - tmp;
    }

    public static double lnfbeta(double a, double b) {
        return Univariate.lnfgamma(a) + Univariate.lnfgamma(b) - Univariate.lnfgamma(a + b);
    }

    public static double fbeta(double a, double b) {
        return Math.exp(Univariate.lnfbeta(a, b));
    }

    public static double fgamma(double c) {
        return Math.exp(Univariate.lnfgamma(c));
    }

    public static double fact(int n) {
        return Math.exp(Univariate.lnfgamma(n + 1));
    }

    public static double lnfact(int n) {
        return Univariate.lnfgamma(n + 1);
    }

    public static double nCr(int n, int r) {
        return Math.exp(Univariate.lnfact(n) - Univariate.lnfact(r) - Univariate.lnfact(n - r));
    }

    public static double nPr(int n, int r) {
        return Math.exp(Univariate.lnfact(n) - Univariate.lnfact(r));
    }

    public static void main(String[] args) {
        Univariate.test();
    }
}

