/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.BitSet;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;

abstract class ElectronDonation {
    private static final ElectronDonation DAYLIGHT = new Daylight();

    ElectronDonation() {
    }

    abstract int contribution(int var1, Graph var2, Cycle var3, BitSet var4);

    static ElectronDonation daylight() {
        return DAYLIGHT;
    }

    private static final class Daylight
    extends ElectronDonation {
        private Daylight() {
        }

        @Override
        int contribution(int u, Graph g2, Cycle cycle, BitSet cyclic) {
            if (!cyclic.get(u)) {
                return -1;
            }
            Atom atom = g2.atom(u);
            Element elem = atom.element();
            if (!elem.aromatic(Element.AromaticSpecification.Daylight) || elem == Element.Unknown) {
                return -1;
            }
            int nCyclic = 0;
            int nAcyclic = 0;
            int deg = g2.degree(u) + g2.implHCount(u);
            Edge acyclic = null;
            int sum = 0;
            for (Edge e : g2.edges(u)) {
                sum += e.bond().order();
                if (e.bond().order() != 2) continue;
                if (!cyclic.get(e.other(u))) {
                    ++nAcyclic;
                    acyclic = e;
                    continue;
                }
                ++nCyclic;
            }
            int charge = atom.charge();
            int valence = sum + g2.implHCount(u);
            if (!atom.element().verify(valence, charge)) {
                return -1;
            }
            if (deg > 3) {
                return -1;
            }
            if (nCyclic > 1) {
                return -1;
            }
            if (nCyclic == 1 && nAcyclic == 1) {
                if ((elem == Element.Nitrogen || elem == Element.Phosphorus) && g2.atom(acyclic.other(u)).element() == Element.Oxygen) {
                    return 1;
                }
                return -1;
            }
            if (nCyclic == 1 && nAcyclic == 0) {
                return elem != Element.Arsenic ? 1 : -1;
            }
            if (nCyclic == 0 && nAcyclic == 1) {
                return this.acyclicContribution(atom, g2.atom(acyclic.other(u)), charge);
            }
            if (nCyclic == 0 && nAcyclic == 0 && charge > -3) {
                int v = this.valence(elem, charge);
                if (v - sum >= 2 && charge <= 0) {
                    return 2;
                }
                if (charge == 1 && atom.element() == Element.Carbon) {
                    return 0;
                }
            }
            return -1;
        }

        private int valence(Element elem, int q) {
            return this.valence(Element.ofNumber(elem.atomicNumber() - q));
        }

        private int valence(Element elem) {
            switch (elem) {
                case Boron: 
                case Aluminum: 
                case Gallium: {
                    return 3;
                }
                case Carbon: 
                case Silicon: 
                case Germanium: {
                    return 4;
                }
                case Nitrogen: 
                case Phosphorus: 
                case Arsenic: {
                    return 5;
                }
                case Oxygen: 
                case Sulfur: 
                case Selenium: {
                    return 6;
                }
                case Fluorine: 
                case Chlorine: 
                case Bromine: {
                    return 7;
                }
            }
            throw new UnsupportedOperationException("Valence not yet handled for element with atomic number " + (Object)((Object)elem));
        }

        int acyclicContribution(Atom cyclic, Atom acyclic, int charge) {
            switch (cyclic.element()) {
                case Carbon: {
                    return acyclic.element() != Element.Carbon ? 0 : 1;
                }
                case Nitrogen: 
                case Phosphorus: {
                    return charge == 1 ? 1 : -1;
                }
                case Sulfur: {
                    return charge == 0 && acyclic.element() == Element.Oxygen ? 2 : -1;
                }
            }
            return -1;
        }
    }

    static interface Cycle {
        public boolean contains(int var1);
    }
}

