/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.BitSet;
import uk.ac.ebi.beam.ArbitraryMatching;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.BiconnectedComponents;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.IntSet;
import uk.ac.ebi.beam.InvalidSmilesException;
import uk.ac.ebi.beam.Matching;
import uk.ac.ebi.beam.MaximumMatching;

final class Localise {
    Localise() {
    }

    private static Graph generateKekuleForm(Graph g2, BitSet subset, BitSet aromatic, boolean inplace) throws InvalidSmilesException {
        Matching m3 = Matching.empty(g2);
        int n = subset.cardinality();
        int nMatched = ArbitraryMatching.initial(g2, m3, subset);
        if (nMatched < n) {
            if (n - nMatched == 2) {
                nMatched = ArbitraryMatching.augmentOnce(g2, m3, nMatched, subset);
            }
            if (nMatched < n) {
                nMatched = MaximumMatching.maximise(g2, m3, nMatched, IntSet.fromBitSet(subset));
            }
            if (nMatched < n) {
                throw new InvalidSmilesException("Could not Kekulise");
            }
        }
        return inplace ? Localise.assign(g2, subset, aromatic, m3) : Localise.copyAndAssign(g2, subset, aromatic, m3);
    }

    private static Graph copyAndAssign(Graph delocalised, BitSet subset, BitSet aromatic, Matching m3) throws InvalidSmilesException {
        Graph localised = new Graph(delocalised.order());
        localised.setFlags(delocalised.getFlags() & 0xFFFFFFFE);
        for (int u = 0; u < delocalised.order(); ++u) {
            localised.addAtom(delocalised.atom(u).toAliphatic());
            localised.addTopology(delocalised.topologyOf(u));
            int d = delocalised.degree(u);
            block6: for (int j = 0; j < d; ++j) {
                Edge e = delocalised.edgeAt(u, j);
                int v = e.other(u);
                if (v >= u) continue;
                switch (e.bond()) {
                    case SINGLE: {
                        if (aromatic.get(u) && aromatic.get(v)) {
                            localised.addEdge(Bond.SINGLE.edge(u, v));
                            continue block6;
                        }
                        localised.addEdge(Bond.IMPLICIT.edge(u, v));
                        continue block6;
                    }
                    case AROMATIC: {
                        if (subset.get(u) && m3.other(u) == v) {
                            localised.addEdge(Bond.DOUBLE_AROMATIC.edge(u, v));
                            continue block6;
                        }
                        if (aromatic.get(u) && aromatic.get(v)) {
                            localised.addEdge(Bond.IMPLICIT_AROMATIC.edge(u, v));
                            continue block6;
                        }
                        localised.addEdge(Bond.IMPLICIT.edge(u, v));
                        continue block6;
                    }
                    case IMPLICIT: {
                        if (subset.get(u) && m3.other(u) == v) {
                            localised.addEdge(Bond.DOUBLE_AROMATIC.edge(u, v));
                            continue block6;
                        }
                        if (aromatic.get(u) && aromatic.get(v)) {
                            localised.addEdge(Bond.IMPLICIT_AROMATIC.edge(u, v));
                            continue block6;
                        }
                        localised.addEdge(e);
                        continue block6;
                    }
                    default: {
                        localised.addEdge(e);
                    }
                }
            }
        }
        return localised;
    }

    private static Graph assign(Graph g2, BitSet subset, BitSet aromatic, Matching m3) throws InvalidSmilesException {
        g2.setFlags(g2.getFlags() & 0xFFFFFFFE);
        int u = aromatic.nextSetBit(0);
        while (u >= 0) {
            g2.setAtom(u, g2.atom(u).toAliphatic());
            int deg = g2.degree(u);
            block6: for (int j = 0; j < deg; ++j) {
                Edge e = g2.edgeAt(u, j);
                int v = e.other(u);
                if (v >= u) continue;
                switch (e.bond()) {
                    case SINGLE: {
                        if (aromatic.get(u) && aromatic.get(v)) {
                            e.bond(Bond.SINGLE);
                            continue block6;
                        }
                        e.bond(Bond.IMPLICIT);
                        continue block6;
                    }
                    case AROMATIC: {
                        if (subset.get(u) && m3.other(u) == v) {
                            e.bond(Bond.DOUBLE_AROMATIC);
                            g2.updateBondedValence(u, 1);
                            g2.updateBondedValence(v, 1);
                            continue block6;
                        }
                        if (aromatic.get(v)) {
                            e.bond(Bond.IMPLICIT_AROMATIC);
                            continue block6;
                        }
                        e.bond(Bond.IMPLICIT);
                        continue block6;
                    }
                    case IMPLICIT: {
                        if (subset.get(u) && m3.other(u) == v) {
                            e.bond(Bond.DOUBLE_AROMATIC);
                            g2.updateBondedValence(u, 1);
                            g2.updateBondedValence(v, 1);
                            continue block6;
                        }
                        if (!aromatic.get(u) || !aromatic.get(v)) continue block6;
                        e.bond(Bond.IMPLICIT_AROMATIC);
                    }
                }
            }
            u = aromatic.nextSetBit(u + 1);
        }
        return g2;
    }

    static BitSet buildSet(Graph g2, BitSet aromatic) {
        BitSet undecided = new BitSet(g2.order());
        for (int v = 0; v < g2.order(); ++v) {
            if (!g2.atom(v).aromatic()) continue;
            aromatic.set(v);
            if (Localise.predetermined(g2, v)) continue;
            undecided.set(v);
        }
        return undecided;
    }

    static boolean predetermined(Graph g2, int v) {
        Atom a = g2.atom(v);
        int q = a.charge();
        int deg = g2.degree(v) + g2.implHCount(v);
        if (g2.bondedValence(v) > g2.degree(v)) {
            int d = g2.degree(v);
            for (int j = 0; j < d; ++j) {
                Edge e = g2.edgeAt(v, j);
                if (e.bond() == Bond.DOUBLE) {
                    return q != 0 || a.element() != Element.Nitrogen && (a.element() != Element.Sulfur || deg <= 3);
                }
                if (e.bond().order() <= 2) continue;
                return true;
            }
        }
        switch (a.element()) {
            case Boron: {
                return q == 0 && deg == 3;
            }
            case Carbon: {
                return (q == 1 || q == -1) && deg == 3;
            }
            case Silicon: 
            case Germanium: {
                return q < 0;
            }
            case Nitrogen: 
            case Phosphorus: 
            case Arsenic: 
            case Antimony: {
                if (q == 0) {
                    return deg == 3 || deg > 4;
                }
                if (q == 1) {
                    return deg > 3;
                }
                return true;
            }
            case Oxygen: 
            case Sulfur: 
            case Selenium: 
            case Tellurium: {
                if (q == 0) {
                    return deg == 2 || deg == 4 || deg > 5;
                }
                if (q == -1 || q == 1) {
                    return deg == 3 || deg == 5 || deg > 6;
                }
                return false;
            }
        }
        return false;
    }

    static boolean inSmallRing(Graph g2, Edge e) {
        BitSet visit = new BitSet();
        return Localise.inSmallRing(g2, e.either(), e.other(e.either()), e.other(e.either()), 1, new BitSet());
    }

    static boolean inSmallRing(Graph g2, int v, int prev, int t, int d, BitSet visit) {
        if (d > 7) {
            return false;
        }
        if (v == t) {
            return true;
        }
        if (visit.get(v)) {
            return false;
        }
        visit.set(v);
        int deg = g2.degree(v);
        for (int j = 0; j < deg; ++j) {
            Edge e = g2.edgeAt(v, j);
            int w = e.other(v);
            if (w == prev || !Localise.inSmallRing(g2, w, v, t, d + 1, visit)) continue;
            return true;
        }
        return false;
    }

    static Graph resonate(Graph g2, BitSet cyclic, boolean ordered) {
        BitSet subset = new BitSet();
        int u = cyclic.nextSetBit(0);
        while (u >= 0) {
            int uExtra = g2.bondedValence(u) - g2.degree(u);
            if (uExtra > 0) {
                int other = -1;
                Edge target = null;
                int d = g2.degree(u);
                for (int j = 0; j < d; ++j) {
                    Edge e = g2.edgeAt(u, j);
                    int v = e.other(u);
                    if (e.bond().order() != 2) continue;
                    int vExtra = g2.bondedValence(v) - g2.degree(v);
                    if (cyclic.get(v) && vExtra > 0) {
                        if (Localise.hasAdjDirectionalLabels(g2, e, cyclic) && !Localise.inSmallRing(g2, e)) {
                            other = -1;
                            break;
                        }
                        if (vExtra > 1 && Localise.hasAdditionalCyclicDoubleBond(g2, cyclic, u, v)) {
                            other = -1;
                            break;
                        }
                        if (other == -1) {
                            other = v;
                            target = e;
                        } else {
                            other = -2;
                        }
                    }
                    if (uExtra == 1) break;
                }
                if (other >= 0) {
                    subset.set(u);
                    subset.set(other);
                    target.bond(Bond.IMPLICIT);
                }
            }
            u = cyclic.nextSetBit(u + 1);
        }
        if (!ordered) {
            g2 = g2.sort(new Graph.CanOrderFirst());
        }
        Matching m3 = Matching.empty(g2);
        int n = subset.cardinality();
        int nMatched = ArbitraryMatching.dfs(g2, m3, subset);
        if (nMatched < n) {
            if (n - nMatched == 2) {
                nMatched = ArbitraryMatching.augmentOnce(g2, m3, nMatched, subset);
            }
            if (nMatched < n) {
                nMatched = MaximumMatching.maximise(g2, m3, nMatched, IntSet.fromBitSet(subset));
            }
            if (nMatched < n) {
                throw new InternalError("Could not Kekulise");
            }
        }
        int v = subset.nextSetBit(0);
        while (v >= 0) {
            int w = m3.other(v);
            subset.clear(w);
            g2.edge(v, w).bond(Bond.DOUBLE);
            v = subset.nextSetBit(v + 1);
        }
        return g2;
    }

    static Graph resonate(Graph g2) {
        return Localise.resonate(g2, new BiconnectedComponents(g2).cyclic(), false);
    }

    private static boolean hasAdditionalCyclicDoubleBond(Graph g2, BitSet cyclic, int u, int v) {
        for (Edge f : g2.edges(v)) {
            if (f.bond() != Bond.DOUBLE || f.other(v) == u || !cyclic.get(u)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAdjDirectionalLabels(Graph g2, Edge e, BitSet cyclic) {
        int u = e.either();
        int v = e.other(u);
        return Localise.hasAdjDirectionalLabels(g2, u, cyclic) && Localise.hasAdjDirectionalLabels(g2, v, cyclic);
    }

    private static boolean hasAdjDirectionalLabels(Graph g2, int u, BitSet cyclic) {
        int d = g2.degree(u);
        for (int j = 0; j < d; ++j) {
            Edge f = g2.edgeAt(u, j);
            int v = f.other(u);
            if (!f.bond().directional() || !cyclic.get(v)) continue;
            return true;
        }
        return false;
    }

    static Graph localise(Graph delocalised) throws InvalidSmilesException {
        if (delocalised.getFlags(1) == 0) {
            return delocalised;
        }
        BitSet aromatic = new BitSet();
        BitSet subset = Localise.buildSet(delocalised, aromatic);
        if (Localise.hasOddCardinality(subset)) {
            throw new InvalidSmilesException("a valid kekul\u00e9 structure could not be assigned");
        }
        return Localise.generateKekuleForm(delocalised, subset, aromatic, false);
    }

    static Graph localiseInPlace(Graph delocalised) throws InvalidSmilesException {
        if (delocalised.getFlags(1) == 0) {
            return delocalised;
        }
        BitSet aromatic = new BitSet();
        BitSet subset = Localise.buildSet(delocalised, aromatic);
        if (Localise.hasOddCardinality(subset)) {
            throw new InvalidSmilesException("a valid kekul\u00e9 structure could not be assigned");
        }
        return Localise.generateKekuleForm(delocalised, subset, aromatic, true);
    }

    private static boolean hasOddCardinality(BitSet s2) {
        return (s2.cardinality() & 1) == 1;
    }
}

