from livestyled.models.app import App
from livestyled.models.fulfilment_point import FulfilmentPoint
from livestyled.models.product import Product, ProductVariant
from livestyled.models.user import User


class OrderItem:
    def __init__(
            self,
            id,
            fulfilment_point,
            quantity,
            title,
            subtitle,
            image_url,
            price,
            total_price,
            product,
            product_variant=None,
    ):
        self.id = id
        self.quantity = quantity
        self.title = title
        self.subtitle = subtitle
        self.image_url = image_url
        self.price = price
        self.total_price = total_price

        if product_variant:
            if isinstance(product_variant, ProductVariant):
                self.product_variant = product_variant
            elif isinstance(product_variant, dict):
                self.product_variant = ProductVariant(**product_variant)
            elif isinstance(product_variant, int):
                self.product_variant = ProductVariant.placeholder(id=product_variant)
        else:
            self.product_variant = None

        if fulfilment_point:
            if isinstance(fulfilment_point, FulfilmentPoint):
                self.fulfilment_point = fulfilment_point
            elif isinstance(fulfilment_point, dict):
                self.fulfilment_point = FulfilmentPoint(**fulfilment_point)
            elif isinstance(fulfilment_point, int):
                self.fulfilment_point = FulfilmentPoint.placeholder(id=fulfilment_point)
        else:
            self.fulfilment_point = None

        if product:
            if isinstance(product, Product):
                self.product = product
            elif isinstance(product, dict):
                self.product = Product(**product)
            elif isinstance(product, int):
                self.product = Product.placeholder(id=product)
        else:
            self.product = None


class Order:
    def __init__(
            self,
            id,
            user,
            status,
            gross_amount,
            discount,
            net_amount,
            order_amount,
            order_number,
            items,
            updated_at,
            created_at,
            app,
            collection_date,
            collection_preference_type,
            check_in_time,
            estimated_at,
            fulfilment_point,
            external_id,
            seat_info
    ):
        self.id = id
        self.status = status
        self.gross_amount = gross_amount
        self.discount = discount
        self.net_amount = net_amount
        self.order_amount = order_amount
        self.updated_at = updated_at
        self.created_at = created_at
        self.order_number = order_number
        self.collection_date = collection_date
        self.collection_preference_type = collection_preference_type
        self.check_in_time = check_in_time
        self.estimated_at = estimated_at
        self.external_id = external_id
        self.seat_info = seat_info

        if user:
            if isinstance(user, User):
                self.user = user
            elif isinstance(user, dict):
                self.user = User(**user)
            elif isinstance(user, int):
                self.user = User.placeholder(id=user)
        else:
            self.user = None

        if items:
            self.items = []
            for item in items:
                if isinstance(item, OrderItem):
                    self.items.append(item)
                elif isinstance(item, dict):
                    self.items.append(OrderItem(**item))
        else:
            self.items = None

        if app:
            if isinstance(app, App):
                self.app = app
            elif isinstance(app, dict):
                self.app = App(**app)
        else:
            self.app = None

        if fulfilment_point:
            if isinstance(fulfilment_point, FulfilmentPoint):
                self.fulfilment_point = fulfilment_point
            elif isinstance(fulfilment_point, dict):
                self.fulfilment_point = FulfilmentPoint(**fulfilment_point)
            elif isinstance(fulfilment_point, int):
                self.fulfilment_point = FulfilmentPoint.placeholder(id=fulfilment_point)
        else:
            self.fulfilment_point = None

    @classmethod
    def placeholder(cls, id):
        return cls(
            id,
            user=None,
            status=None,
            gross_amount=None,
            discount=None,
            net_amount=None,
            order_amount=None,
            order_number=None,
            items=None,
            updated_at=None,
            created_at=None,
            app=None,
            collection_date=None,
            collection_preference_type=None,
            check_in_time=None,
            estimated_at=None,
            fulfilment_point=None,
            external_id=None,
            seat_info=None
        )

    def diff(self, other):
        differences = {}
        fields = ('external_id', 'status', 'collection_preference_type', 'check_in_time')
        for field in fields:
            if getattr(self, field) != getattr(other, field):
                differences[field] = getattr(self, field)
        return differences
