# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['ProjectMirror']


class ProjectMirror(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 keep_divergent_refs: Optional[pulumi.Input[bool]] = None,
                 only_protected_branches: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # gitlab\_project_mirror

        This resource allows you to add a mirror target for the repository, all changes will be synced to the remote target.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        foo = gitlab.ProjectMirror("foo",
            project="1",
            url="https://username:password@github.com/org/repository.git")
        ```

        ## Import

        GitLab project mirror can be imported using an id made up of `project_id:mirror_id`, e.g.

        ```sh
         $ pulumi import gitlab:index/projectMirror:ProjectMirror foo "12345:1337"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Determines if the mirror is enabled.
        :param pulumi.Input[bool] keep_divergent_refs: Determines if divergent refs are skipped.
        :param pulumi.Input[bool] only_protected_branches: Determines if only protected branches are mirrored.
        :param pulumi.Input[str] project: The id of the project.
        :param pulumi.Input[str] url: The URL of the remote repository to be mirrored.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['enabled'] = enabled
            __props__['keep_divergent_refs'] = keep_divergent_refs
            __props__['only_protected_branches'] = only_protected_branches
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if url is None:
                raise TypeError("Missing required property 'url'")
            __props__['url'] = url
            __props__['mirror_id'] = None
        super(ProjectMirror, __self__).__init__(
            'gitlab:index/projectMirror:ProjectMirror',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            keep_divergent_refs: Optional[pulumi.Input[bool]] = None,
            mirror_id: Optional[pulumi.Input[int]] = None,
            only_protected_branches: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'ProjectMirror':
        """
        Get an existing ProjectMirror resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Determines if the mirror is enabled.
        :param pulumi.Input[bool] keep_divergent_refs: Determines if divergent refs are skipped.
        :param pulumi.Input[bool] only_protected_branches: Determines if only protected branches are mirrored.
        :param pulumi.Input[str] project: The id of the project.
        :param pulumi.Input[str] url: The URL of the remote repository to be mirrored.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["enabled"] = enabled
        __props__["keep_divergent_refs"] = keep_divergent_refs
        __props__["mirror_id"] = mirror_id
        __props__["only_protected_branches"] = only_protected_branches
        __props__["project"] = project
        __props__["url"] = url
        return ProjectMirror(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if the mirror is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="keepDivergentRefs")
    def keep_divergent_refs(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if divergent refs are skipped.
        """
        return pulumi.get(self, "keep_divergent_refs")

    @property
    @pulumi.getter(name="mirrorId")
    def mirror_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "mirror_id")

    @property
    @pulumi.getter(name="onlyProtectedBranches")
    def only_protected_branches(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if only protected branches are mirrored.
        """
        return pulumi.get(self, "only_protected_branches")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The id of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The URL of the remote repository to be mirrored.
        """
        return pulumi.get(self, "url")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

