# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['ServiceSlack']


class ServiceSlack(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branches_to_be_notified: Optional[pulumi.Input[str]] = None,
                 confidential_issue_channel: Optional[pulumi.Input[str]] = None,
                 confidential_issues_events: Optional[pulumi.Input[bool]] = None,
                 confidential_note_events: Optional[pulumi.Input[bool]] = None,
                 issue_channel: Optional[pulumi.Input[str]] = None,
                 issues_events: Optional[pulumi.Input[bool]] = None,
                 merge_request_channel: Optional[pulumi.Input[str]] = None,
                 merge_requests_events: Optional[pulumi.Input[bool]] = None,
                 note_channel: Optional[pulumi.Input[str]] = None,
                 note_events: Optional[pulumi.Input[bool]] = None,
                 notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None,
                 notify_only_default_branch: Optional[pulumi.Input[bool]] = None,
                 pipeline_channel: Optional[pulumi.Input[str]] = None,
                 pipeline_events: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 push_channel: Optional[pulumi.Input[str]] = None,
                 push_events: Optional[pulumi.Input[bool]] = None,
                 tag_push_channel: Optional[pulumi.Input[str]] = None,
                 tag_push_events: Optional[pulumi.Input[bool]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 webhook: Optional[pulumi.Input[str]] = None,
                 wiki_page_channel: Optional[pulumi.Input[str]] = None,
                 wiki_page_events: Optional[pulumi.Input[bool]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a ServiceSlack resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branches_to_be_notified: Branches to send notifications for. Valid options are "all", "default", "protected", and "default_and_protected".
        :param pulumi.Input[str] confidential_issue_channel: The name of the channel to receive confidential issue events notifications.
        :param pulumi.Input[bool] confidential_issues_events: Enable notifications for confidential issues events.
        :param pulumi.Input[bool] confidential_note_events: Enable notifications for confidential note events.
        :param pulumi.Input[str] issue_channel: The name of the channel to receive issue events notifications.
        :param pulumi.Input[bool] issues_events: Enable notifications for issues events.
        :param pulumi.Input[str] merge_request_channel: The name of the channel to receive merge request events notifications.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge requests events.
        :param pulumi.Input[str] note_channel: The name of the channel to receive note events notifications.
        :param pulumi.Input[bool] note_events: Enable notifications for note events.
        :param pulumi.Input[bool] notify_only_broken_pipelines: Send notifications for broken pipelines.
        :param pulumi.Input[bool] notify_only_default_branch: DEPRECATED: This parameter has been replaced with `branches_to_be_notified`.
        :param pulumi.Input[str] pipeline_channel: The name of the channel to receive pipeline events notifications.
        :param pulumi.Input[bool] pipeline_events: Enable notifications for pipeline events.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[str] push_channel: The name of the channel to receive push events notifications.
        :param pulumi.Input[bool] push_events: Enable notifications for push events.
        :param pulumi.Input[str] tag_push_channel: The name of the channel to receive tag push events notifications.
        :param pulumi.Input[bool] tag_push_events: Enable notifications for tag push events.
        :param pulumi.Input[str] username: Username to use.
        :param pulumi.Input[str] webhook: Webhook URL (ex.: https://hooks.slack.com/services/...)
        :param pulumi.Input[str] wiki_page_channel: The name of the channel to receive wiki page events notifications.
        :param pulumi.Input[bool] wiki_page_events: Enable notifications for wiki page events.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['branches_to_be_notified'] = branches_to_be_notified
            __props__['confidential_issue_channel'] = confidential_issue_channel
            __props__['confidential_issues_events'] = confidential_issues_events
            __props__['confidential_note_events'] = confidential_note_events
            __props__['issue_channel'] = issue_channel
            __props__['issues_events'] = issues_events
            __props__['merge_request_channel'] = merge_request_channel
            __props__['merge_requests_events'] = merge_requests_events
            __props__['note_channel'] = note_channel
            __props__['note_events'] = note_events
            __props__['notify_only_broken_pipelines'] = notify_only_broken_pipelines
            if notify_only_default_branch is not None:
                warnings.warn("""use 'branches_to_be_notified' argument instead""", DeprecationWarning)
                pulumi.log.warn("notify_only_default_branch is deprecated: use 'branches_to_be_notified' argument instead")
            __props__['notify_only_default_branch'] = notify_only_default_branch
            __props__['pipeline_channel'] = pipeline_channel
            __props__['pipeline_events'] = pipeline_events
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['push_channel'] = push_channel
            __props__['push_events'] = push_events
            __props__['tag_push_channel'] = tag_push_channel
            __props__['tag_push_events'] = tag_push_events
            __props__['username'] = username
            if webhook is None:
                raise TypeError("Missing required property 'webhook'")
            __props__['webhook'] = webhook
            __props__['wiki_page_channel'] = wiki_page_channel
            __props__['wiki_page_events'] = wiki_page_events
            __props__['job_events'] = None
        super(ServiceSlack, __self__).__init__(
            'gitlab:index/serviceSlack:ServiceSlack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branches_to_be_notified: Optional[pulumi.Input[str]] = None,
            confidential_issue_channel: Optional[pulumi.Input[str]] = None,
            confidential_issues_events: Optional[pulumi.Input[bool]] = None,
            confidential_note_events: Optional[pulumi.Input[bool]] = None,
            issue_channel: Optional[pulumi.Input[str]] = None,
            issues_events: Optional[pulumi.Input[bool]] = None,
            job_events: Optional[pulumi.Input[bool]] = None,
            merge_request_channel: Optional[pulumi.Input[str]] = None,
            merge_requests_events: Optional[pulumi.Input[bool]] = None,
            note_channel: Optional[pulumi.Input[str]] = None,
            note_events: Optional[pulumi.Input[bool]] = None,
            notify_only_broken_pipelines: Optional[pulumi.Input[bool]] = None,
            notify_only_default_branch: Optional[pulumi.Input[bool]] = None,
            pipeline_channel: Optional[pulumi.Input[str]] = None,
            pipeline_events: Optional[pulumi.Input[bool]] = None,
            project: Optional[pulumi.Input[str]] = None,
            push_channel: Optional[pulumi.Input[str]] = None,
            push_events: Optional[pulumi.Input[bool]] = None,
            tag_push_channel: Optional[pulumi.Input[str]] = None,
            tag_push_events: Optional[pulumi.Input[bool]] = None,
            username: Optional[pulumi.Input[str]] = None,
            webhook: Optional[pulumi.Input[str]] = None,
            wiki_page_channel: Optional[pulumi.Input[str]] = None,
            wiki_page_events: Optional[pulumi.Input[bool]] = None) -> 'ServiceSlack':
        """
        Get an existing ServiceSlack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] branches_to_be_notified: Branches to send notifications for. Valid options are "all", "default", "protected", and "default_and_protected".
        :param pulumi.Input[str] confidential_issue_channel: The name of the channel to receive confidential issue events notifications.
        :param pulumi.Input[bool] confidential_issues_events: Enable notifications for confidential issues events.
        :param pulumi.Input[bool] confidential_note_events: Enable notifications for confidential note events.
        :param pulumi.Input[str] issue_channel: The name of the channel to receive issue events notifications.
        :param pulumi.Input[bool] issues_events: Enable notifications for issues events.
        :param pulumi.Input[str] merge_request_channel: The name of the channel to receive merge request events notifications.
        :param pulumi.Input[bool] merge_requests_events: Enable notifications for merge requests events.
        :param pulumi.Input[str] note_channel: The name of the channel to receive note events notifications.
        :param pulumi.Input[bool] note_events: Enable notifications for note events.
        :param pulumi.Input[bool] notify_only_broken_pipelines: Send notifications for broken pipelines.
        :param pulumi.Input[bool] notify_only_default_branch: DEPRECATED: This parameter has been replaced with `branches_to_be_notified`.
        :param pulumi.Input[str] pipeline_channel: The name of the channel to receive pipeline events notifications.
        :param pulumi.Input[bool] pipeline_events: Enable notifications for pipeline events.
        :param pulumi.Input[str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[str] push_channel: The name of the channel to receive push events notifications.
        :param pulumi.Input[bool] push_events: Enable notifications for push events.
        :param pulumi.Input[str] tag_push_channel: The name of the channel to receive tag push events notifications.
        :param pulumi.Input[bool] tag_push_events: Enable notifications for tag push events.
        :param pulumi.Input[str] username: Username to use.
        :param pulumi.Input[str] webhook: Webhook URL (ex.: https://hooks.slack.com/services/...)
        :param pulumi.Input[str] wiki_page_channel: The name of the channel to receive wiki page events notifications.
        :param pulumi.Input[bool] wiki_page_events: Enable notifications for wiki page events.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["branches_to_be_notified"] = branches_to_be_notified
        __props__["confidential_issue_channel"] = confidential_issue_channel
        __props__["confidential_issues_events"] = confidential_issues_events
        __props__["confidential_note_events"] = confidential_note_events
        __props__["issue_channel"] = issue_channel
        __props__["issues_events"] = issues_events
        __props__["job_events"] = job_events
        __props__["merge_request_channel"] = merge_request_channel
        __props__["merge_requests_events"] = merge_requests_events
        __props__["note_channel"] = note_channel
        __props__["note_events"] = note_events
        __props__["notify_only_broken_pipelines"] = notify_only_broken_pipelines
        __props__["notify_only_default_branch"] = notify_only_default_branch
        __props__["pipeline_channel"] = pipeline_channel
        __props__["pipeline_events"] = pipeline_events
        __props__["project"] = project
        __props__["push_channel"] = push_channel
        __props__["push_events"] = push_events
        __props__["tag_push_channel"] = tag_push_channel
        __props__["tag_push_events"] = tag_push_events
        __props__["username"] = username
        __props__["webhook"] = webhook
        __props__["wiki_page_channel"] = wiki_page_channel
        __props__["wiki_page_events"] = wiki_page_events
        return ServiceSlack(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="branchesToBeNotified")
    def branches_to_be_notified(self) -> pulumi.Output[str]:
        """
        Branches to send notifications for. Valid options are "all", "default", "protected", and "default_and_protected".
        """
        return pulumi.get(self, "branches_to_be_notified")

    @property
    @pulumi.getter(name="confidentialIssueChannel")
    def confidential_issue_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive confidential issue events notifications.
        """
        return pulumi.get(self, "confidential_issue_channel")

    @property
    @pulumi.getter(name="confidentialIssuesEvents")
    def confidential_issues_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for confidential issues events.
        """
        return pulumi.get(self, "confidential_issues_events")

    @property
    @pulumi.getter(name="confidentialNoteEvents")
    def confidential_note_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for confidential note events.
        """
        return pulumi.get(self, "confidential_note_events")

    @property
    @pulumi.getter(name="issueChannel")
    def issue_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive issue events notifications.
        """
        return pulumi.get(self, "issue_channel")

    @property
    @pulumi.getter(name="issuesEvents")
    def issues_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for issues events.
        """
        return pulumi.get(self, "issues_events")

    @property
    @pulumi.getter(name="jobEvents")
    def job_events(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "job_events")

    @property
    @pulumi.getter(name="mergeRequestChannel")
    def merge_request_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive merge request events notifications.
        """
        return pulumi.get(self, "merge_request_channel")

    @property
    @pulumi.getter(name="mergeRequestsEvents")
    def merge_requests_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for merge requests events.
        """
        return pulumi.get(self, "merge_requests_events")

    @property
    @pulumi.getter(name="noteChannel")
    def note_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive note events notifications.
        """
        return pulumi.get(self, "note_channel")

    @property
    @pulumi.getter(name="noteEvents")
    def note_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for note events.
        """
        return pulumi.get(self, "note_events")

    @property
    @pulumi.getter(name="notifyOnlyBrokenPipelines")
    def notify_only_broken_pipelines(self) -> pulumi.Output[bool]:
        """
        Send notifications for broken pipelines.
        """
        return pulumi.get(self, "notify_only_broken_pipelines")

    @property
    @pulumi.getter(name="notifyOnlyDefaultBranch")
    def notify_only_default_branch(self) -> pulumi.Output[bool]:
        """
        DEPRECATED: This parameter has been replaced with `branches_to_be_notified`.
        """
        return pulumi.get(self, "notify_only_default_branch")

    @property
    @pulumi.getter(name="pipelineChannel")
    def pipeline_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive pipeline events notifications.
        """
        return pulumi.get(self, "pipeline_channel")

    @property
    @pulumi.getter(name="pipelineEvents")
    def pipeline_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for pipeline events.
        """
        return pulumi.get(self, "pipeline_events")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        ID of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pushChannel")
    def push_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive push events notifications.
        """
        return pulumi.get(self, "push_channel")

    @property
    @pulumi.getter(name="pushEvents")
    def push_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for push events.
        """
        return pulumi.get(self, "push_events")

    @property
    @pulumi.getter(name="tagPushChannel")
    def tag_push_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive tag push events notifications.
        """
        return pulumi.get(self, "tag_push_channel")

    @property
    @pulumi.getter(name="tagPushEvents")
    def tag_push_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for tag push events.
        """
        return pulumi.get(self, "tag_push_events")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        Username to use.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def webhook(self) -> pulumi.Output[str]:
        """
        Webhook URL (ex.: https://hooks.slack.com/services/...)
        """
        return pulumi.get(self, "webhook")

    @property
    @pulumi.getter(name="wikiPageChannel")
    def wiki_page_channel(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the channel to receive wiki page events notifications.
        """
        return pulumi.get(self, "wiki_page_channel")

    @property
    @pulumi.getter(name="wikiPageEvents")
    def wiki_page_events(self) -> pulumi.Output[bool]:
        """
        Enable notifications for wiki page events.
        """
        return pulumi.get(self, "wiki_page_events")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

