/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import org.jmol.api.JmolBioResolver;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Polymer;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.CarbohydrateMonomer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.viewer.JmolConstants;

public final class Resolver
implements JmolBioResolver {
    public Group distinguishAndPropagateGroup(Chain chain, String string, int n, int n2, int n3, int n4, int[] nArray, Atom[] atomArray) {
        int n5 = n3 - 1;
        int n6 = 0;
        int n7 = JmolConstants.ATOMID_MAX;
        while (--n7 >= 0) {
            nArray[n7] = Integer.MIN_VALUE;
        }
        n7 = n3;
        while (--n7 >= n2) {
            byte by = atomArray[n7].getAtomID();
            if (by <= 0) continue;
            if (by < 14) {
                n6 |= 1 << by;
            }
            nArray[by] = n7;
        }
        if (n5 < n2) {
            throw new NullPointerException();
        }
        if ((n6 & 0xE) == 14) {
            return AminoMonomer.validateAndAllocate(chain, string, n, n2, n5, nArray, atomArray);
        }
        if (n6 == 4) {
            return AlphaMonomer.validateAndAllocate(chain, string, n, n2, n5, nArray);
        }
        if ((n6 & 0x1FC0) == 8128) {
            return NucleicMonomer.validateAndAllocate(chain, string, n, n2, n5, nArray);
        }
        if (n6 == 8192) {
            return PhosphorusMonomer.validateAndAllocate(chain, string, n, n2, n5, nArray);
        }
        if (JmolConstants.checkCarbohydrate((String)string)) {
            return CarbohydrateMonomer.validateAndAllocate(chain, string, n, n2, n5);
        }
        return null;
    }

    public Polymer buildBioPolymer(Group group, Group[] groupArray, int n, boolean bl) {
        return group instanceof Monomer && ((Monomer)group).getBioPolymer() == null ? BioPolymer.allocateBioPolymer(groupArray, n, bl) : null;
    }

    public void clearBioPolymers(Group[] groupArray, int n, BitSet bitSet) {
        for (int i = 0; i < n; ++i) {
            Monomer monomer;
            Group group = groupArray[i];
            if (!(group instanceof Monomer) || (monomer = (Monomer)group).getBioPolymer() == null || bitSet != null && bitSet.get(monomer.getModelIndex())) continue;
            monomer.setBioPolymer(null, -1);
        }
    }
}

