"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const eks = require("@aws-cdk/aws-eks");
const cdk = require("@aws-cdk/core");
const index_1 = require("./index");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'cdk-kubesphere-integ', { env });
        // create a default KubeSphere on a new Amazon EKS cluster
        new index_1.KubeSphere(stack, 'KubeSphere', {
            appStore: true,
            nodegroupOptions: {
                capacityType: eks.CapacityType.SPOT,
                instanceTypes: [
                    new ec2.InstanceType('t3.large'),
                    new ec2.InstanceType('m5.large'),
                    new ec2.InstanceType('c5.large'),
                ],
                desiredSize: 3,
            },
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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