/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.magic.command;

import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.scala.magic.command.EnableSparkSupportMagicCommand;
import com.twosigma.beakerx.scala.magic.command.SparkInitCommandFactory;
import java.util.ArrayList;
import java.util.List;

class EnableSparkSupportMagicInitConfiguration
implements EnableSparkSupportMagicCommand.EnableSparkSupportMagicConfiguration {
    private SparkInitCommandFactory initCommandFactory;

    public EnableSparkSupportMagicInitConfiguration(SparkInitCommandFactory initCommandFactory) {
        this.initCommandFactory = initCommandFactory;
    }

    @Override
    public MagicCommandOutcomeItem run(MagicCommandExecutionParam param) {
        return this.enableSparkMagicCommand(param);
    }

    @Override
    public boolean isInit() {
        return true;
    }

    private MagicCommandOutcomeItem enableSparkMagicCommand(MagicCommandExecutionParam param) {
        List<SparkInitCommandFactory.Command> commands = this.createCommands(param);
        for (SparkInitCommandFactory.Command command : commands) {
            MagicCommandOutcomeItem item = command.run();
            if (item.getStatus().equals((Object)MagicCommandOutcomeItem.Status.OK)) continue;
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, command.getErrorMessage(), MessageCreator.get());
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, "Spark support enabled", MessageCreator.get());
    }

    private List<SparkInitCommandFactory.Command> createCommands(MagicCommandExecutionParam param) {
        ArrayList<SparkInitCommandFactory.Command> commands = new ArrayList<SparkInitCommandFactory.Command>();
        commands.add(this.initCommandFactory.addSparkexJar());
        commands.add(this.initCommandFactory.loadSparkSupportMagicClass());
        commands.add(this.initCommandFactory.runOptions(param));
        commands.add(this.initCommandFactory.loadSparkFrom_SPARK_HOME_IfIsNotOnClasspath());
        commands.add(this.initCommandFactory.loadLatestVersionOfSparkIfIsNotOnClasspath(param));
        commands.add(this.initCommandFactory.loadSparkSupportMagic(param));
        return commands;
    }
}

