/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.scala.serializers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectDeserializer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef;
import scala.collection.JavaConverters;
import scala.collection.mutable.Map;

public class ScalaMapDeserializer
implements ObjectDeserializer {
    private static final Logger logger = LoggerFactory.getLogger((String)ScalaMapDeserializer.class.getName());
    private final BeakerObjectConverter parent;

    public ScalaMapDeserializer(BeakerObjectConverter p) {
        this.parent = p;
    }

    public boolean canBeUsed(JsonNode n) {
        return n.isObject() && (!n.has("type") || !this.parent.isKnownBeakerType(n.get("type").asText()));
    }

    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        HashMap<String, Object> o = new HashMap<String, Object>();
        try {
            logger.debug("using custom map deserializer");
            Iterator e = n.fields();
            while (e.hasNext()) {
                Map.Entry ee = (Map.Entry)e.next();
                o.put((String)ee.getKey(), this.parent.deserialize((JsonNode)ee.getValue(), mapper));
            }
        }
        catch (Exception e) {
            logger.error("exception deserializing Map {}", (Object)e.getMessage());
            o = null;
        }
        if (o != null) {
            return ((Map)JavaConverters.mapAsScalaMapConverter(o).asScala()).toMap(Predef.conforms());
        }
        return null;
    }
}

