/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.ErrorPrinter;
import com.twosigma.beakerx.widget.SparkEngineBase;
import com.twosigma.beakerx.widget.SparkEngineNoUI;
import com.twosigma.beakerx.widget.SparkSessionBuilder;
import com.twosigma.beakerx.widget.SparkSessionBuilderFactory;
import com.twosigma.beakerx.widget.SparkVariable;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.SparkConf;

public class SparkEngineNoUIImpl
extends SparkEngineBase
implements SparkEngineNoUI {
    private SparkSessionBuilderFactory sparkSessionBuilderFactory;

    SparkEngineNoUIImpl(SparkSessionBuilder sparkSessionBuilder, SparkSessionBuilderFactory sparkSessionBuilderFactory) {
        super(sparkSessionBuilder, SparkEngineNoUIImpl.errorPrinter());
        this.sparkSessionBuilderFactory = sparkSessionBuilderFactory;
    }

    @Override
    public TryResult configure(KernelFunctionality kernel, Message parentMessage) {
        SparkConf sparkConf = this.newSparkConf();
        this.sparkSessionBuilder = this.sparkSessionBuilderFactory.newInstance(sparkConf);
        TryResult sparkSessionTry = this.createSparkSession();
        if (sparkSessionTry.isError()) {
            return sparkSessionTry;
        }
        SparkVariable.putSparkSession(this.sparkSessionBuilder.getOrCreate());
        TryResult tryResultSparkContext = this.initSparkContextInShell(kernel, parentMessage);
        if (!tryResultSparkContext.isError()) {
            kernel.registerCancelHook(SparkVariable::cancelAllJobs);
        }
        return tryResultSparkContext;
    }

    private SparkConf newSparkConf() {
        SparkConf sparkConf = this.userSparkSessionBuilder.getSparkConf();
        this.configureSparkConfDefaults(sparkConf);
        this.configureSparkConf(sparkConf);
        return sparkConf;
    }

    private void configureSparkConfDefaults(SparkConf sparkConf) {
        if (!sparkConf.contains("spark.master")) {
            this.conf.getMaster().ifPresent(arg_0 -> ((SparkConf)sparkConf).setMaster(arg_0));
        }
        if (!sparkConf.contains("spark.executor.cores")) {
            this.conf.getExecutorCores().ifPresent(x -> sparkConf.set("spark.executor.cores", x));
        }
        if (!sparkConf.contains("spark.executor.memory")) {
            this.conf.getExecutorMemory().ifPresent(x -> sparkConf.set("spark.executor.memory", x));
        }
    }

    @Override
    public void stop() {
        this.sparkSessionBuilder.stop();
    }

    @Override
    public void cancelAllJobs() {
        this.sparkSessionBuilder.cancelAllJobs();
    }

    @Override
    public void cancelStage(int stageid) {
        this.sparkSessionBuilder.cancelStage(stageid);
    }

    private static ErrorPrinter errorPrinter() {
        return e -> Stream.of(e.getMessage(), e.getCause()).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(System.lineSeparator()));
    }

    public static class SparkEngineNoUIFactoryImpl
    implements SparkEngineNoUIFactory {
        @Override
        public SparkEngineNoUI create(SparkSessionBuilder sparkSessionBuilder, SparkSessionBuilderFactory sparkSessionBuilderFactory) {
            return new SparkEngineNoUIImpl(sparkSessionBuilder, sparkSessionBuilderFactory);
        }
    }

    public static interface SparkEngineNoUIFactory {
        public SparkEngineNoUI create(SparkSessionBuilder var1, SparkSessionBuilderFactory var2);
    }
}

