/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.widget.SparkListenerService;
import com.twosigma.beakerx.widget.SparkSessionBuilder;
import com.twosigma.beakerx.widget.SparkUIApi;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskStart;

public class SparkListenerServiceImpl
implements SparkListenerService {
    @Override
    public void configure(SparkSessionBuilder sparkSessionBuilder, final SparkUIApi sparkUI) {
        SparkContext sc = sparkSessionBuilder.getOrCreate().sparkContext();
        sc.addSparkListener((SparkListenerInterface)new SparkListener(){

            public void onJobStart(SparkListenerJobStart jobStart) {
                super.onJobStart(jobStart);
            }

            public void onJobEnd(SparkListenerJobEnd jobEnd) {
                super.onJobEnd(jobEnd);
            }

            public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
                super.onStageSubmitted(stageSubmitted);
                sparkUI.startStage(stageSubmitted.stageInfo().stageId(), stageSubmitted.stageInfo().numTasks());
            }

            public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
                super.onStageCompleted(stageCompleted);
                sparkUI.endStage(stageCompleted.stageInfo().stageId());
            }

            public void onTaskStart(SparkListenerTaskStart taskStart) {
                super.onTaskStart(taskStart);
                sparkUI.taskStart(taskStart.stageId(), taskStart.taskInfo().taskId());
            }

            public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
                super.onTaskEnd(taskEnd);
                String reason = taskEnd.reason().toString();
                if (reason.equals("Success")) {
                    sparkUI.taskEnd(taskEnd.stageId(), taskEnd.taskInfo().taskId());
                } else if (reason.contains("stage cancelled")) {
                    sparkUI.taskCancelled(taskEnd.stageId(), taskEnd.taskInfo().taskId());
                }
            }
        });
    }
}

