/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.InternalVariable;
import com.twosigma.beakerx.handler.Handler;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.comm.BxComm;
import com.twosigma.beakerx.kernel.comm.Comm;
import com.twosigma.beakerx.kernel.restserver.BeakerXServer;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.Foldout;
import com.twosigma.beakerx.widget.RESTButton;
import com.twosigma.beakerx.widget.SingleSparkSession;
import com.twosigma.beakerx.widget.SparkEngineWithUI;
import com.twosigma.beakerx.widget.SparkFoldout;
import com.twosigma.beakerx.widget.SparkSessionBuilder;
import com.twosigma.beakerx.widget.SparkStateGroupPanel;
import com.twosigma.beakerx.widget.SparkStateProgress;
import com.twosigma.beakerx.widget.SparkUIApi;
import com.twosigma.beakerx.widget.SparkUIFactory;
import com.twosigma.beakerx.widget.SparkUiDefaults;
import com.twosigma.beakerx.widget.SparkVariable;
import com.twosigma.beakerx.widget.VBox;
import com.twosigma.beakerx.widget.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SparkUI
extends VBox
implements SparkUIApi {
    public static final String ONE_SPARK_SESSION_MSG_ERROR = "Cannot have more than one Spark session open in the same notebook.";
    public static final String VIEW_NAME_VALUE = "SparkUIView";
    public static final String MODEL_NAME_VALUE = "SparkUIModel";
    public static final String PUT_SPARK_JOBS_IN_THE_BACKGROUND = "putSparkJobsInTheBackground";
    public static final String CANCELLED_SPARK_JOBS = "cancelledSparkJobs";
    public static final String SPARK_APP_ID = "sparkAppId";
    public static final String SPARK_UI_WEB_URL = "sparkUiWebUrl";
    public static final String START = "start";
    public static final String IS_AUTO_START = "is_auto_start";
    public static final String USER_SPARK_CONF = "user_spark_conf";
    private final KernelFunctionality kernel;
    private SparkEngineWithUI sparkEngine;
    private SparkUiDefaults sparkUiDefaults;
    private SingleSparkSession singleSparkSession;
    private Message currentParentHeader = null;
    private SparkFoldout jobPanel = null;
    private Map<Integer, SparkStateGroupPanel> progressBarMap = new HashMap<Integer, SparkStateGroupPanel>();

    public SparkUI(Comm comm, SparkEngineWithUI sparkEngine, SparkUiDefaults sparkUiDefaults, SingleSparkSession singleSparkSession, KernelFunctionality kernel) {
        super(comm, new ArrayList());
        this.sparkUiDefaults = sparkUiDefaults;
        this.sparkEngine = sparkEngine;
        this.singleSparkSession = singleSparkSession;
        this.kernel = kernel;
        this.getComm().addMsgCallbackList(new Handler[]{this::handleMessage});
        SparkVariable.putSparkUI(this);
        this.configureRESTMapping();
        this.openComm();
    }

    public SparkUI(SparkEngineWithUI sparkEngine, SparkUiDefaults sparkUiDefaults, SingleSparkSession singleSparkSession) {
        this(BxComm.createComm(), sparkEngine, sparkUiDefaults, singleSparkSession, KernelManager.get());
    }

    protected HashMap<String, Object> content(HashMap<String, Object> content) {
        this.sparkUiDefaults.loadProfiles();
        super.content(content);
        content.put("profiles", this.sparkUiDefaults.getProfiles());
        content.put("current_profile", this.sparkUiDefaults.getCurrentProfileName());
        content.put(IS_AUTO_START, this.sparkEngine.isAutoStart());
        content.put(USER_SPARK_CONF, this.getUserSparkConf());
        return content;
    }

    private Map getUserSparkConf() {
        Map<String, Object> spark_options = this.sparkUiDefaults.getProfileByName(this.sparkUiDefaults.getCurrentProfileName());
        spark_options.putAll(this.sparkEngine.getSparkEngineConf().getConfigs());
        spark_options.putAll(this.sparkEngine.getUserSparkConfAsMap());
        return spark_options;
    }

    public String getModelNameValue() {
        return MODEL_NAME_VALUE;
    }

    public String getViewNameValue() {
        return VIEW_NAME_VALUE;
    }

    public String getModelModuleValue() {
        return "beakerx";
    }

    public String getViewModuleValue() {
        return "beakerx";
    }

    @Override
    public void afterDisplay(Message parent) {
        if (this.sparkEngine.isAutoStart()) {
            this.handleAutoStart(parent);
        }
    }

    private void handleMessage(Message message) {
        Map data = (Map)message.getContent().get("data");
        Map content = (Map)data.get("content");
        String event = (String)content.get("event");
        if (event.equals(START)) {
            this.handleStartEvent(content, message);
        } else if (event.equals("stop")) {
            this.handleStopEvent();
        } else if (event.equals("save_profiles")) {
            this.handleSaveProfilesEvent(content);
        }
    }

    private void handleStopEvent() {
        this.sparkEngine.stop();
    }

    private void handleAutoStart(Message message) {
        Map<String, Object> spark_options = this.sparkUiDefaults.getProfileByName(this.sparkUiDefaults.getCurrentProfileName());
        TryResult tryResult = this.initSparkContext(message, spark_options);
        if (tryResult.isError()) {
            this.sendError(tryResult.error());
        } else {
            this.sendStartDoneEvent("auto_start");
        }
    }

    private void handleStartEvent(Map content, Message message) {
        Map payload = (Map)content.get("payload");
        Map spark_options = (Map)payload.get("spark_options");
        TryResult tryResult = this.initSparkContext(message, spark_options);
        if (tryResult.isError()) {
            this.sendError(tryResult.error());
        } else {
            String current_profile = (String)payload.get("current_profile");
            this.sparkUiDefaults.saveCurrentProfileName(current_profile);
            this.sendStartDoneEvent(START);
        }
    }

    private void sendStartDoneEvent(final String event) {
        this.getComm().sendData("event", (HashMap)new HashMap<String, String>(){
            {
                this.put(event, "done");
                this.put(SparkUI.SPARK_APP_ID, SparkUI.this.sparkEngine.getSparkAppId());
                this.put(SparkUI.SPARK_UI_WEB_URL, SparkUI.this.sparkEngine.getSparkUiWebUrl());
            }
        });
    }

    private void handleSaveProfilesEvent(Map content) {
        List payload = (List)content.get("payload");
        this.sparkUiDefaults.saveProfiles(payload);
        this.getComm().sendData("event", (HashMap)new HashMap<String, String>(){
            {
                this.put("save_profiles", "done");
            }
        });
    }

    private TryResult initSparkContext(Message parentMessage, Map sparkOptions) {
        KernelFunctionality kernel = KernelManager.get();
        if (this.singleSparkSession.isActive()) {
            return TryResult.createError((String)ONE_SPARK_SESSION_MSG_ERROR);
        }
        SparkVariable.putSparkUI(this);
        return this.createSparkContext(parentMessage, kernel, sparkOptions);
    }

    private TryResult createSparkContext(Message parentMessage, KernelFunctionality kernel, Map sparkOptions) {
        try {
            TryResult result = this.sparkEngine.createSparkContext(kernel, this, parentMessage, sparkOptions);
            if (result.isError()) {
                return TryResult.createError((String)result.error());
            }
            this.singleSparkSession.activate();
            this.applicationStart();
            return TryResult.createResult((Object)"done");
        }
        catch (Exception e) {
            return TryResult.createError((String)e.toString());
        }
    }

    private void sendError(final String text) {
        this.getComm().sendData("error", (HashMap)new HashMap<String, String>(){
            {
                this.put("message", text);
            }
        });
    }

    private void applicationStart() {
    }

    @Override
    public void applicationEnd() {
        this.singleSparkSession.inActivate();
        this.getComm().sendData("event", (HashMap)new HashMap<String, String>(){
            {
                this.put(SparkUI.this.sparkEngine.getStopContext(), "done");
            }
        });
    }

    @Override
    public void startStage(int stageId, int numTasks) {
        if (this.isStartStageFromNewCell()) {
            this.jobPanel = this.createSparkFoldout(this.jobPanel);
        }
        SparkStateProgress intProgress = new SparkStateProgress(numTasks, stageId, stageId, this.jobLink(stageId), this.stageLink(stageId));
        intProgress.init();
        Widget xButton = this.createCancelledJobsButton(stageId);
        Widget bkgButton = this.createBkgJobsButton(stageId);
        SparkStateGroupPanel sparkProgressDecorator = new SparkStateGroupPanel(intProgress, Arrays.asList(xButton, bkgButton));
        this.jobPanel.add((Widget)sparkProgressDecorator);
        this.progressBarMap.put(stageId, sparkProgressDecorator);
    }

    @Override
    public void endStage(int stageId) {
        SparkStateGroupPanel decorator = this.progressBarMap.get(stageId);
        decorator.getSparkStateProgress().hide();
    }

    @Override
    public void taskStart(int stageId, long taskId) {
        SparkStateGroupPanel decorator = this.progressBarMap.get(stageId);
        decorator.getSparkStateProgress().addActive();
    }

    @Override
    public void taskEnd(int stageId, long taskId) {
        SparkStateGroupPanel decorator = this.progressBarMap.get(stageId);
        decorator.getSparkStateProgress().addDone();
    }

    @Override
    public void taskCancelled(int stageId, long taskId) {
        SparkStateGroupPanel decorator = this.progressBarMap.get(stageId);
        decorator.getSparkStateProgress().addCancelled();
    }

    @Override
    public void cancelAllJobs() {
        this.sparkEngine.cancelAllJobs();
    }

    private void configureRESTMapping() {
        BeakerXServer beakerXServer = this.kernel.getBeakerXServer();
        beakerXServer.addPostMapping(PUT_SPARK_JOBS_IN_THE_BACKGROUND, ctx -> this.kernel.putEvaluationInToBackground());
        beakerXServer.addPostMapping("cancelledSparkJobs/:stageid", ctx -> this.sparkEngine.cancelStage(Integer.parseInt(ctx.param("stageid"))));
    }

    private boolean isStartStageFromNewCell() {
        return InternalVariable.getParentHeader() != this.currentParentHeader;
    }

    private SparkFoldout createSparkFoldout(SparkFoldout oldJobPanel) {
        this.currentParentHeader = InternalVariable.getParentHeader();
        if (oldJobPanel != null) {
            oldJobPanel.getLayout().setDisplayNone();
            oldJobPanel.close();
        }
        Foldout.FoldoutOption foldoutOption = new Foldout.FoldoutOption();
        foldoutOption.headerLabel = "Spark progress";
        SparkFoldout jobPanel = new SparkFoldout(new ArrayList(), foldoutOption);
        jobPanel.display();
        return jobPanel;
    }

    private String stageLink(int stageId) {
        return this.sparkEngine.stageLink(stageId);
    }

    private String jobLink(int jobId) {
        return this.sparkEngine.jobLink(jobId);
    }

    private Widget createCancelledJobsButton(int stageId) {
        BeakerXServer beakerXServer = KernelManager.get().getBeakerXServer();
        RESTButton xButton = new RESTButton(beakerXServer.getURL() + "cancelledSparkJobs/" + stageId);
        xButton.setTooltip("interrupt spark job");
        xButton.setDomClasses(new ArrayList<String>(Arrays.asList("bx-button", "icon-close")));
        return xButton;
    }

    private Widget createBkgJobsButton(int stageId) {
        BeakerXServer beakerXServer = KernelManager.get().getBeakerXServer();
        RESTButton bkgButton = new RESTButton(beakerXServer.getURL() + PUT_SPARK_JOBS_IN_THE_BACKGROUND);
        bkgButton.setTooltip("put spark job in the background, let it complete asynchronously");
        bkgButton.setDomClasses(new ArrayList<String>(Arrays.asList("bx-button", "icon-bg")));
        return bkgButton;
    }

    public static class SparkUIFactoryImpl
    implements SparkUIFactory {
        private SingleSparkSession singleSparkSession;

        public SparkUIFactoryImpl(SingleSparkSession singleSparkSession) {
            this.singleSparkSession = singleSparkSession;
        }

        @Override
        public SparkUI create(SparkSessionBuilder builder, SparkEngineWithUI sparkEngine, SparkUiDefaults sparkUiDefaults) {
            return new SparkUI(sparkEngine, sparkUiDefaults, this.singleSparkSession);
        }
    }
}

