/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.widget.configuration;

import com.twosigma.beakerx.widget.VBox;
import com.twosigma.beakerx.widget.Widget;
import com.twosigma.beakerx.widget.configuration.PropertyItem;
import java.util.List;
import java.util.stream.Collectors;

class PropertiesWidget {
    private final VBox widget;

    PropertiesWidget(List<PropertyItem> children) {
        this.widget = new VBox(children.stream().map(x -> x).collect(Collectors.toList()));
    }

    List<PropertyItem> getItems() {
        return this.widget.getChildren().stream().map(x -> (PropertyItem)((Object)x)).collect(Collectors.toList());
    }

    VBox getWidget() {
        return this.widget;
    }

    void add(PropertyItem propertyItem) {
        this.widget.add((Widget)propertyItem);
    }

    void disable() {
        this.getItems().forEach(PropertyItem::disable);
    }

    void enable() {
        this.getItems().forEach(PropertyItem::enable);
    }

    void remove(PropertyItem propertyItem) {
        this.getWidget().remove((Widget)propertyItem);
    }

    void remove(List<PropertyItem> propertyItems) {
        propertyItems.forEach(item -> this.getWidget().remove((Widget)item));
    }

    List<PropertyItem> findByName(String name, String value) {
        return this.getItems().stream().filter(item -> name.equals(item.getNameAsString())).filter(item -> value.equals(item.getValueAsString())).collect(Collectors.toList());
    }
}

