"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Authorizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const method_1 = require("./method");
const AUTHORIZER_SYMBOL = Symbol.for('@aws-cdk/aws-apigateway.Authorizer');
/**
 * Base class for all custom authorizers.
 *
 * @stability stable
 */
class Authorizer extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        /**
         * The authorization type of this authorizer.
         *
         * @stability stable
         */
        this.authorizationType = method_1.AuthorizationType.CUSTOM;
        Object.defineProperty(this, AUTHORIZER_SYMBOL, { value: true });
    }
    /**
     * Return whether the given object is an Authorizer.
     *
     * @stability stable
     */
    static isAuthorizer(x) {
        return x !== null && typeof (x) === 'object' && AUTHORIZER_SYMBOL in x;
    }
}
exports.Authorizer = Authorizer;
_a = JSII_RTTI_SYMBOL_1;
Authorizer[_a] = { fqn: "@aws-cdk/aws-apigateway.Authorizer", version: "1.142.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0aG9yaXplci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImF1dGhvcml6ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSx3Q0FBd0Q7QUFFeEQscUNBQTZDO0FBRzdDLE1BQU0saUJBQWlCLEdBQUcsTUFBTSxDQUFDLEdBQUcsQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFDOzs7Ozs7QUFHM0UsTUFBc0IsVUFBVyxTQUFRLGVBQVE7Ozs7SUFTL0MsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBcUI7UUFDcEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7Ozs7OztRQUhWLHNCQUFpQixHQUF1QiwwQkFBaUIsQ0FBQyxNQUFNLENBQUM7UUFLL0UsTUFBTSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsaUJBQWlCLEVBQUUsRUFBRSxLQUFLLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztLQUNqRTs7Ozs7O0lBWE0sTUFBTSxDQUFDLFlBQVksQ0FBQyxDQUFNO1FBQy9CLE9BQU8sQ0FBQyxLQUFLLElBQUksSUFBSSxPQUFNLENBQUMsQ0FBQyxDQUFDLEtBQUssUUFBUSxJQUFJLGlCQUFpQixJQUFJLENBQUMsQ0FBQztLQUN2RTs7QUFKSCxnQ0FvQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBSZXNvdXJjZSwgUmVzb3VyY2VQcm9wcyB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBBdXRob3JpemF0aW9uVHlwZSB9IGZyb20gJy4vbWV0aG9kJztcbmltcG9ydCB7IElSZXN0QXBpIH0gZnJvbSAnLi9yZXN0YXBpJztcblxuY29uc3QgQVVUSE9SSVpFUl9TWU1CT0wgPSBTeW1ib2wuZm9yKCdAYXdzLWNkay9hd3MtYXBpZ2F0ZXdheS5BdXRob3JpemVyJyk7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEF1dGhvcml6ZXIgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElBdXRob3JpemVyIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGlzQXV0aG9yaXplcih4OiBhbnkpOiB4IGlzIEF1dGhvcml6ZXIge1xuICAgIHJldHVybiB4ICE9PSBudWxsICYmIHR5cGVvZih4KSA9PT0gJ29iamVjdCcgJiYgQVVUSE9SSVpFUl9TWU1CT0wgaW4geDtcbiAgfVxuXG4gIHB1YmxpYyByZWFkb25seSBhYnN0cmFjdCBhdXRob3JpemVySWQ6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGF1dGhvcml6YXRpb25UeXBlPzogQXV0aG9yaXphdGlvblR5cGUgPSBBdXRob3JpemF0aW9uVHlwZS5DVVNUT007XG5cbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzPzogUmVzb3VyY2VQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KHRoaXMsIEFVVEhPUklaRVJfU1lNQk9MLCB7IHZhbHVlOiB0cnVlIH0pO1xuICB9XG5cbiAgLyoqXG4gICAqIENhbGxlZCB3aGVuIHRoZSBhdXRob3JpemVyIGlzIHVzZWQgZnJvbSBhIHNwZWNpZmljIFJFU1QgQVBJLlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCBfYXR0YWNoVG9BcGkocmVzdEFwaTogSVJlc3RBcGkpOiB2b2lkO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSUF1dGhvcml6ZXIge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGF1dGhvcml6ZXJJZDogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhdXRob3JpemF0aW9uVHlwZT86IEF1dGhvcml6YXRpb25UeXBlO1xufVxuIl19