"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsRestApi = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const _1 = require(".");
const stepfunctions_1 = require("./integrations/stepfunctions");
const model_1 = require("./model");
/**
 * Defines an API Gateway REST API with a Synchrounous Express State Machine as a proxy integration.
 *
 * @stability stable
 */
class StepFunctionsRestApi extends _1.RestApi {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c;
        jsiiDeprecationWarnings._aws_cdk_aws_apigateway_StepFunctionsRestApiProps(props);
        if (props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Step Functions integration is automatically defined');
        }
        if (props.stateMachine.node.defaultChild.stateMachineType !== sfn.StateMachineType.EXPRESS) {
            throw new Error('State Machine must be of type "EXPRESS". Please use StateMachineType.EXPRESS as the stateMachineType');
        }
        const stepfunctionsIntegration = stepfunctions_1.StepFunctionsIntegration.startExecution(props.stateMachine, {
            credentialsRole: role(scope, props),
            requestContext: props.requestContext,
            path: (_b = props.path) !== null && _b !== void 0 ? _b : true,
            querystring: (_c = props.querystring) !== null && _c !== void 0 ? _c : true,
            headers: props.headers,
        });
        super(scope, id, props);
        this.root.addMethod('ANY', stepfunctionsIntegration, {
            methodResponses: methodResponse(),
        });
    }
}
exports.StepFunctionsRestApi = StepFunctionsRestApi;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsRestApi[_a] = { fqn: "@aws-cdk/aws-apigateway.StepFunctionsRestApi", version: "1.142.0" };
/**
 * Defines the IAM Role for API Gateway with required permissions
 * to invoke a synchronous execution for the provided state machine
 *
 * @param scope
 * @param props
 * @returns Role - IAM Role
 */
function role(scope, props) {
    const roleName = 'StartSyncExecutionRole';
    const apiRole = new iam.Role(scope, roleName, {
        assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com'),
    });
    props.stateMachine.grantStartSyncExecution(apiRole);
    return apiRole;
}
/**
 * Defines the method response modelfor each HTTP code response
 * @returns methodResponse
 */
function methodResponse() {
    return [
        {
            statusCode: '200',
            responseModels: {
                'application/json': model_1.Model.EMPTY_MODEL,
            },
        },
        {
            statusCode: '400',
            responseModels: {
                'application/json': model_1.Model.ERROR_MODEL,
            },
        },
        {
            statusCode: '500',
            responseModels: {
                'application/json': model_1.Model.ERROR_MODEL,
            },
        },
    ];
}
//# sourceMappingURL=data:application/json;base64,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