"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const ses_generated_1 = require("./ses.generated");
/**
 * The policy for the receipt filter.
 */
var ReceiptFilterPolicy;
(function (ReceiptFilterPolicy) {
    /**
     * Allow the ip address or range.
     */
    ReceiptFilterPolicy["Allow"] = "Allow";
    /**
     * Block the ip address or range.
     */
    ReceiptFilterPolicy["Block"] = "Block";
})(ReceiptFilterPolicy = exports.ReceiptFilterPolicy || (exports.ReceiptFilterPolicy = {}));
/**
 * A receipt filter. When instantiated without props, it creates a
 * block all receipt filter.
 */
class ReceiptFilter extends cdk_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new ses_generated_1.CfnReceiptFilter(this, 'Resource', {
            filter: {
                ipFilter: {
                    cidr: (props && props.ip) || '0.0.0.0/0',
                    policy: (props && props.policy) || ReceiptFilterPolicy.Block
                },
                name: props ? props.name : undefined
            }
        });
    }
}
exports.ReceiptFilter = ReceiptFilter;
/**
 * A white list receipt filter.
 */
class WhiteListReceiptFilter extends cdk_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new ReceiptFilter(this, 'BlockAll');
        props.ips.forEach(ip => {
            new ReceiptFilter(this, `Allow${ip.replace(/[^\d]/g, '')}`, {
                ip,
                policy: ReceiptFilterPolicy.Allow
            });
        });
    }
}
exports.WhiteListReceiptFilter = WhiteListReceiptFilter;
//# sourceMappingURL=data:application/json;base64,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