"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const sns = require("@aws-cdk/aws-sns");
const cdk = require("@aws-cdk/cdk");
const ses = require("../lib");
const stack = new cdk.Stack();
/// !show
const bucket = new s3.Bucket(stack, 'Bucket');
const topic = new sns.Topic(stack, 'Topic');
new ses.ReceiptRuleSet(stack, 'RuleSet', {
    rules: [
        {
            recipients: ['hello@aws.com'],
            actions: [
                new ses.ReceiptRuleAddHeaderAction({
                    name: 'X-Special-Header',
                    value: 'aws'
                }),
                new ses.ReceiptRuleS3Action({
                    bucket,
                    objectKeyPrefix: 'emails/',
                    topic
                })
            ],
        },
        {
            recipients: ['aws.com'],
            actions: [
                new ses.ReceiptRuleSnsAction({
                    topic
                })
            ]
        }
    ]
});
/// !hide
//# sourceMappingURL=data:application/json;base64,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