"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'can create a receipt filter'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        new lib_1.ReceiptFilter(stack, 'Filter', {
            ip: '1.2.3.4/16',
            name: 'MyFilter',
            policy: lib_1.ReceiptFilterPolicy.Block
        });
        // THEN
        assert_1.expect(stack).toMatch({
            "Resources": {
                "FilterC907D6DA": {
                    "Type": "AWS::SES::ReceiptFilter",
                    "Properties": {
                        "Filter": {
                            "IpFilter": {
                                "Cidr": "1.2.3.4/16",
                                "Policy": "Block"
                            },
                            "Name": "MyFilter"
                        }
                    }
                }
            }
        });
        test.done();
    },
    'can create a white list filter'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        new lib_1.WhiteListReceiptFilter(stack, 'WhiteList', {
            ips: [
                '10.0.0.0/16',
                '1.2.3.4'
            ]
        });
        // THEN
        assert_1.expect(stack).toMatch({
            "Resources": {
                "WhiteListBlockAllAE2CDDFF": {
                    "Type": "AWS::SES::ReceiptFilter",
                    "Properties": {
                        "Filter": {
                            "IpFilter": {
                                "Cidr": "0.0.0.0/0",
                                "Policy": "Block"
                            }
                        }
                    }
                },
                "WhiteListAllow1000016F396A7F2": {
                    "Type": "AWS::SES::ReceiptFilter",
                    "Properties": {
                        "Filter": {
                            "IpFilter": {
                                "Cidr": "10.0.0.0/16",
                                "Policy": "Allow"
                            }
                        }
                    }
                },
                "WhiteListAllow1234A4DDAD4E": {
                    "Type": "AWS::SES::ReceiptFilter",
                    "Properties": {
                        "Filter": {
                            "IpFilter": {
                                "Cidr": "1.2.3.4",
                                "Policy": "Allow"
                            }
                        }
                    }
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5yZWNlaXB0LWZpbHRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRlc3QucmVjZWlwdC1maWx0ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLDRDQUF5QztBQUN6QyxzQ0FBcUM7QUFFckMsZ0NBQW9GO0FBSXBGLGlCQUFTO0lBQ1AsNkJBQTZCLENBQUMsSUFBVTtRQUN0QyxRQUFRO1FBQ1IsTUFBTSxLQUFLLEdBQUcsSUFBSSxXQUFLLEVBQUUsQ0FBQztRQUUxQixPQUFPO1FBQ1AsSUFBSSxtQkFBYSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUU7WUFDakMsRUFBRSxFQUFFLFlBQVk7WUFDaEIsSUFBSSxFQUFFLFVBQVU7WUFDaEIsTUFBTSxFQUFFLHlCQUFtQixDQUFDLEtBQUs7U0FDbEMsQ0FBQyxDQUFDO1FBRUgsT0FBTztRQUNQLGVBQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxPQUFPLENBQUM7WUFDcEIsV0FBVyxFQUFFO2dCQUNYLGdCQUFnQixFQUFFO29CQUNoQixNQUFNLEVBQUUseUJBQXlCO29CQUNqQyxZQUFZLEVBQUU7d0JBQ1osUUFBUSxFQUFFOzRCQUNSLFVBQVUsRUFBRTtnQ0FDVixNQUFNLEVBQUUsWUFBWTtnQ0FDcEIsUUFBUSxFQUFFLE9BQU87NkJBQ2xCOzRCQUNELE1BQU0sRUFBRSxVQUFVO3lCQUNuQjtxQkFDRjtpQkFDRjthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELGdDQUFnQyxDQUFDLElBQVU7UUFDekMsUUFBUTtRQUNSLE1BQU0sS0FBSyxHQUFHLElBQUksV0FBSyxFQUFFLENBQUM7UUFFMUIsT0FBTztRQUNQLElBQUksNEJBQXNCLENBQUMsS0FBSyxFQUFFLFdBQVcsRUFBRTtZQUM3QyxHQUFHLEVBQUU7Z0JBQ0gsYUFBYTtnQkFDYixTQUFTO2FBQ1Y7U0FDRixDQUFDLENBQUM7UUFFSCxPQUFPO1FBQ1AsZUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLE9BQU8sQ0FBQztZQUNwQixXQUFXLEVBQUU7Z0JBQ1gsMkJBQTJCLEVBQUU7b0JBQzNCLE1BQU0sRUFBRSx5QkFBeUI7b0JBQ2pDLFlBQVksRUFBRTt3QkFDWixRQUFRLEVBQUU7NEJBQ1IsVUFBVSxFQUFFO2dDQUNWLE1BQU0sRUFBRSxXQUFXO2dDQUNuQixRQUFRLEVBQUUsT0FBTzs2QkFDbEI7eUJBQ0Y7cUJBQ0Y7aUJBQ0Y7Z0JBQ0QsK0JBQStCLEVBQUU7b0JBQy9CLE1BQU0sRUFBRSx5QkFBeUI7b0JBQ2pDLFlBQVksRUFBRTt3QkFDWixRQUFRLEVBQUU7NEJBQ1IsVUFBVSxFQUFFO2dDQUNWLE1BQU0sRUFBRSxhQUFhO2dDQUNyQixRQUFRLEVBQUUsT0FBTzs2QkFDbEI7eUJBQ0Y7cUJBQ0Y7aUJBQ0Y7Z0JBQ0QsNEJBQTRCLEVBQUU7b0JBQzVCLE1BQU0sRUFBRSx5QkFBeUI7b0JBQ2pDLFlBQVksRUFBRTt3QkFDWixRQUFRLEVBQUU7NEJBQ1IsVUFBVSxFQUFFO2dDQUNWLE1BQU0sRUFBRSxTQUFTO2dDQUNqQixRQUFRLEVBQUUsT0FBTzs2QkFDbEI7eUJBQ0Y7cUJBQ0Y7aUJBQ0Y7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgZXhwZWN0IH0gZnJvbSAnQGF3cy1jZGsvYXNzZXJ0JztcbmltcG9ydCB7IFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY2RrJztcbmltcG9ydCB7IFRlc3QgfSBmcm9tICdub2RldW5pdCc7XG5pbXBvcnQgeyBSZWNlaXB0RmlsdGVyLCBSZWNlaXB0RmlsdGVyUG9saWN5LCBXaGl0ZUxpc3RSZWNlaXB0RmlsdGVyIH0gZnJvbSAnLi4vbGliJztcblxuLy8gdHNsaW50OmRpc2FibGU6b2JqZWN0LWxpdGVyYWwta2V5LXF1b3Rlc1xuXG5leHBvcnQgPSB7XG4gICdjYW4gY3JlYXRlIGEgcmVjZWlwdCBmaWx0ZXInKHRlc3Q6IFRlc3QpIHtcbiAgICAvLyBHSVZFTlxuICAgIGNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKCk7XG5cbiAgICAvLyBXSEVOXG4gICAgbmV3IFJlY2VpcHRGaWx0ZXIoc3RhY2ssICdGaWx0ZXInLCB7XG4gICAgICBpcDogJzEuMi4zLjQvMTYnLFxuICAgICAgbmFtZTogJ015RmlsdGVyJyxcbiAgICAgIHBvbGljeTogUmVjZWlwdEZpbHRlclBvbGljeS5CbG9ja1xuICAgIH0pO1xuXG4gICAgLy8gVEhFTlxuICAgIGV4cGVjdChzdGFjaykudG9NYXRjaCh7XG4gICAgICBcIlJlc291cmNlc1wiOiB7XG4gICAgICAgIFwiRmlsdGVyQzkwN0Q2REFcIjoge1xuICAgICAgICAgIFwiVHlwZVwiOiBcIkFXUzo6U0VTOjpSZWNlaXB0RmlsdGVyXCIsXG4gICAgICAgICAgXCJQcm9wZXJ0aWVzXCI6IHtcbiAgICAgICAgICAgIFwiRmlsdGVyXCI6IHtcbiAgICAgICAgICAgICAgXCJJcEZpbHRlclwiOiB7XG4gICAgICAgICAgICAgICAgXCJDaWRyXCI6IFwiMS4yLjMuNC8xNlwiLFxuICAgICAgICAgICAgICAgIFwiUG9saWN5XCI6IFwiQmxvY2tcIlxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICBcIk5hbWVcIjogXCJNeUZpbHRlclwiXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9XG4gICAgfSk7XG5cbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcblxuICAnY2FuIGNyZWF0ZSBhIHdoaXRlIGxpc3QgZmlsdGVyJyh0ZXN0OiBUZXN0KSB7XG4gICAgLy8gR0lWRU5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBTdGFjaygpO1xuXG4gICAgLy8gV0hFTlxuICAgIG5ldyBXaGl0ZUxpc3RSZWNlaXB0RmlsdGVyKHN0YWNrLCAnV2hpdGVMaXN0Jywge1xuICAgICAgaXBzOiBbXG4gICAgICAgICcxMC4wLjAuMC8xNicsXG4gICAgICAgICcxLjIuMy40J1xuICAgICAgXVxuICAgIH0pO1xuXG4gICAgLy8gVEhFTlxuICAgIGV4cGVjdChzdGFjaykudG9NYXRjaCh7XG4gICAgICBcIlJlc291cmNlc1wiOiB7XG4gICAgICAgIFwiV2hpdGVMaXN0QmxvY2tBbGxBRTJDRERGRlwiOiB7XG4gICAgICAgICAgXCJUeXBlXCI6IFwiQVdTOjpTRVM6OlJlY2VpcHRGaWx0ZXJcIixcbiAgICAgICAgICBcIlByb3BlcnRpZXNcIjoge1xuICAgICAgICAgICAgXCJGaWx0ZXJcIjoge1xuICAgICAgICAgICAgICBcIklwRmlsdGVyXCI6IHtcbiAgICAgICAgICAgICAgICBcIkNpZHJcIjogXCIwLjAuMC4wLzBcIixcbiAgICAgICAgICAgICAgICBcIlBvbGljeVwiOiBcIkJsb2NrXCJcbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICAgICAgXCJXaGl0ZUxpc3RBbGxvdzEwMDAwMTZGMzk2QTdGMlwiOiB7XG4gICAgICAgICAgXCJUeXBlXCI6IFwiQVdTOjpTRVM6OlJlY2VpcHRGaWx0ZXJcIixcbiAgICAgICAgICBcIlByb3BlcnRpZXNcIjoge1xuICAgICAgICAgICAgXCJGaWx0ZXJcIjoge1xuICAgICAgICAgICAgICBcIklwRmlsdGVyXCI6IHtcbiAgICAgICAgICAgICAgICBcIkNpZHJcIjogXCIxMC4wLjAuMC8xNlwiLFxuICAgICAgICAgICAgICAgIFwiUG9saWN5XCI6IFwiQWxsb3dcIlxuICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9LFxuICAgICAgICBcIldoaXRlTGlzdEFsbG93MTIzNEE0RERBRDRFXCI6IHtcbiAgICAgICAgICBcIlR5cGVcIjogXCJBV1M6OlNFUzo6UmVjZWlwdEZpbHRlclwiLFxuICAgICAgICAgIFwiUHJvcGVydGllc1wiOiB7XG4gICAgICAgICAgICBcIkZpbHRlclwiOiB7XG4gICAgICAgICAgICAgIFwiSXBGaWx0ZXJcIjoge1xuICAgICAgICAgICAgICAgIFwiQ2lkclwiOiBcIjEuMi4zLjRcIixcbiAgICAgICAgICAgICAgICBcIlBvbGljeVwiOiBcIkFsbG93XCJcbiAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfVxuICAgIH0pO1xuXG4gICAgdGVzdC5kb25lKCk7XG4gIH1cbn07XG4iXX0=