"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'can create receipt rules with second after first'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        new lib_1.ReceiptRuleSet(stack, 'RuleSet', {
            rules: [
                {
                    name: 'FirstRule',
                },
                {
                    enabled: false,
                    name: 'SecondRule',
                    recipients: ['hello@aws.com'],
                    scanEnabled: true,
                    tlsPolicy: lib_1.TlsPolicy.Require
                }
            ]
        });
        // THEN
        assert_1.expect(stack).toMatch({
            "Resources": {
                "RuleSetE30C6C48": {
                    "Type": "AWS::SES::ReceiptRuleSet"
                },
                "RuleSetRule023C3B8E1": {
                    "Type": "AWS::SES::ReceiptRule",
                    "Properties": {
                        "Rule": {
                            "Name": "FirstRule",
                            "Enabled": true
                        },
                        "RuleSetName": {
                            "Ref": "RuleSetE30C6C48"
                        }
                    }
                },
                "RuleSetRule117041B57": {
                    "Type": "AWS::SES::ReceiptRule",
                    "Properties": {
                        "Rule": {
                            "Enabled": false,
                            "Name": "SecondRule",
                            "Recipients": [
                                "hello@aws.com"
                            ],
                            "ScanEnabled": true,
                            "TlsPolicy": "Require"
                        },
                        "RuleSetName": {
                            "Ref": "RuleSetE30C6C48"
                        },
                        "After": {
                            "Ref": "RuleSetRule023C3B8E1"
                        }
                    }
                }
            }
        });
        test.done();
    },
    'export receipt rule'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        const receiptRuleSet = new lib_1.ReceiptRuleSet(stack, 'RuleSet');
        const receiptRule = receiptRuleSet.addRule('Rule');
        // WHEN
        receiptRule.export();
        // THEN
        assert_1.expect(stack).toMatch({
            "Resources": {
                "RuleSetE30C6C48": {
                    "Type": "AWS::SES::ReceiptRuleSet"
                },
                "RuleSetRule0B1D6BCA": {
                    "Type": "AWS::SES::ReceiptRule",
                    "Properties": {
                        "Rule": {
                            "Enabled": true
                        },
                        "RuleSetName": {
                            "Ref": "RuleSetE30C6C48"
                        }
                    }
                }
            },
            "Outputs": {
                "RuleSetRuleReceiptRuleName5620D98F": {
                    "Value": {
                        "Ref": "RuleSetRule0B1D6BCA"
                    },
                    "Export": {
                        "Name": "Stack:RuleSetRuleReceiptRuleName5620D98F"
                    }
                }
            }
        });
        test.done();
    },
    'import receipt rule'(test) {
        // GIVEN
        const stack = new cdk_1.Stack();
        // WHEN
        const receiptRule = lib_1.ReceiptRule.import(stack, 'ImportedRule', {
            name: 'MyRule'
        });
        const receiptRuleSet = new lib_1.ReceiptRuleSet(stack, 'RuleSet');
        receiptRuleSet.addRule('MyRule', {
            after: receiptRule
        });
        // THEN
        assert_1.expect(stack).toMatch({
            "Resources": {
                "RuleSetE30C6C48": {
                    "Type": "AWS::SES::ReceiptRuleSet"
                },
                "RuleSetMyRule60B1D107": {
                    "Type": "AWS::SES::ReceiptRule",
                    "Properties": {
                        "Rule": {
                            "Enabled": true
                        },
                        "RuleSetName": {
                            "Ref": "RuleSetE30C6C48"
                        },
                        "After": "MyRule"
                    }
                }
            },
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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