#!/usr/bin/env python
from forcebalance.molecule import *

#Make Molecule object from centroids.gro file
mol = Molecule("centroids.gro")
#Make template Molecule objects from example Psi4 input files
mol_cbs = Molecule("cbs_template.psi4in")
mol_grad = Molecule("grad_template.psi4in")

#Assign centroids.gro xyzs to both Molecule objects
mol_cbs.xyzs = mol.xyzs
mol_grad.xyzs = mol.xyzs

for i in range(len(mol.xyzs)):
    mol_cbs.write("{}/cbs.psi4in".format(i), selection=i)
    mol_grad.write("{}/grad.psi4in".format(i), selection=i)
