![Nautobot](https://raw.githubusercontent.com/nautobot/nautobot/develop/nautobot/docs/nautobot_logo.svg "Nautobot logo")

Nautobot is a Network Source of Truth and Network Automation Platform.  

> Nautobot was initially developed as a fork of NetBox (v2.10.4).  NetBox was originally developed by Jeremy Stretch at DigitalOcean and the NetBox Community.

Nautobot runs as a web application atop the [Django](https://www.djangoproject.com/) Python framework with a
[PostgreSQL](https://www.postgresql.org/) or [MySQL](https://www.mysql.com) database. 

The complete documentation for Nautobot can be found at [Read the Docs](https://nautobot.readthedocs.io/en/stable/).

Questions? Comments? Start by perusing our [GitHub discussions](https://github.com/nautobot/nautobot/discussions) for the topic you have in mind, or join us in the **#nautobot** Slack channel on [Network to Code](https://networktocode.slack.com)!

### Build Status

| Branch      | Status |
|-------------|------------|
| **main** | [![Build Status](https://github.com/nautobot/nautobot/actions/workflows/ci.yml/badge.svg?branch=main)](https://github.com/nautobot/nautobot/actions/workflows/ci.yml) |
| **develop** | [![Build Status](https://github.com/nautobot/nautobot/actions/workflows/ci.yml/badge.svg?branch=develop)](https://github.com/nautobot/nautobot/actions/workflows/ci.yml) |

### Screenshots

![Screenshot of main page](https://raw.githubusercontent.com/nautobot/nautobot/develop/nautobot/docs/media/screenshot1.png "Main page")

---

![Screenshot of rack elevation](https://raw.githubusercontent.com/nautobot/nautobot/develop/nautobot/docs/media/screenshot2.png "Rack elevation")

---

![Screenshot of prefix hierarchy](https://raw.githubusercontent.com/nautobot/nautobot/develop/nautobot/docs/media/screenshot3.png "Prefix hierarchy")

## Installation

Please see [the documentation](https://nautobot.readthedocs.io/en/stable/installation/) for instructions on installing Nautobot.

## Application Stack

Below is a simplified overview of the Nautobot application stack for reference:

![Application stack diagram](https://raw.githubusercontent.com/nautobot/nautobot/develop/nautobot/docs/media/nautobot_application_stack_high_level.png "Application stack diagram")

## Providing Feedback

The best platform for general feedback, assistance, and other discussion is our [GitHub discussions](https://github.com/nautobot/nautobot/discussions). To report a bug or request a specific feature, please open a GitHub issue using the [appropriate template](https://github.com/nautobot/nautobot/issues/new/choose).

If you are interested in contributing to the development of Nautobot, please read our [contributing guide](CONTRIBUTING.md) prior to beginning any work.

## Related projects

Please see [our wiki](https://github.com/nautobot/nautobot/wiki/Related-Projects) for a list of relevant community projects.
