# coding: utf-8

"""
    Accounting Extension

    These APIs allow you to interact with HubSpot's Accounting Extension. It allows you to: * Specify the URLs that HubSpot will use when making webhook requests to your external accounting system. * Respond to webhook calls made to your external accounting system by HubSpot   # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.crm.extensions.accounting.configuration import Configuration


class AccountingFeatures(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {"create_invoice": "CreateInvoiceFeature", "import_invoice": "ImportInvoiceFeature", "sync": "dict(str, ObjectSyncFeature)"}

    attribute_map = {"create_invoice": "createInvoice", "import_invoice": "importInvoice", "sync": "sync"}

    def __init__(self, create_invoice=None, import_invoice=None, sync=None, local_vars_configuration=None):  # noqa: E501
        """AccountingFeatures - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._create_invoice = None
        self._import_invoice = None
        self._sync = None
        self.discriminator = None

        self.create_invoice = create_invoice
        self.import_invoice = import_invoice
        self.sync = sync

    @property
    def create_invoice(self):
        """Gets the create_invoice of this AccountingFeatures.  # noqa: E501


        :return: The create_invoice of this AccountingFeatures.  # noqa: E501
        :rtype: CreateInvoiceFeature
        """
        return self._create_invoice

    @create_invoice.setter
    def create_invoice(self, create_invoice):
        """Sets the create_invoice of this AccountingFeatures.


        :param create_invoice: The create_invoice of this AccountingFeatures.  # noqa: E501
        :type: CreateInvoiceFeature
        """
        if self.local_vars_configuration.client_side_validation and create_invoice is None:  # noqa: E501
            raise ValueError("Invalid value for `create_invoice`, must not be `None`")  # noqa: E501

        self._create_invoice = create_invoice

    @property
    def import_invoice(self):
        """Gets the import_invoice of this AccountingFeatures.  # noqa: E501


        :return: The import_invoice of this AccountingFeatures.  # noqa: E501
        :rtype: ImportInvoiceFeature
        """
        return self._import_invoice

    @import_invoice.setter
    def import_invoice(self, import_invoice):
        """Sets the import_invoice of this AccountingFeatures.


        :param import_invoice: The import_invoice of this AccountingFeatures.  # noqa: E501
        :type: ImportInvoiceFeature
        """
        if self.local_vars_configuration.client_side_validation and import_invoice is None:  # noqa: E501
            raise ValueError("Invalid value for `import_invoice`, must not be `None`")  # noqa: E501

        self._import_invoice = import_invoice

    @property
    def sync(self):
        """Gets the sync of this AccountingFeatures.  # noqa: E501

        Indicates if syncing objects from the external account system into HubSpot is supported for the integration. This is a map, where the key is one of `CONTACT` or `PRODUCT`, to indicate which type of object you do or don't support syncing. For example: ```   \"sync\": {     \"CONTACT\": {       \"toHubSpot\": true     },     \"PRODUCT\": {       \"toHubSpot\": true     }   } ```   # noqa: E501

        :return: The sync of this AccountingFeatures.  # noqa: E501
        :rtype: dict(str, ObjectSyncFeature)
        """
        return self._sync

    @sync.setter
    def sync(self, sync):
        """Sets the sync of this AccountingFeatures.

        Indicates if syncing objects from the external account system into HubSpot is supported for the integration. This is a map, where the key is one of `CONTACT` or `PRODUCT`, to indicate which type of object you do or don't support syncing. For example: ```   \"sync\": {     \"CONTACT\": {       \"toHubSpot\": true     },     \"PRODUCT\": {       \"toHubSpot\": true     }   } ```   # noqa: E501

        :param sync: The sync of this AccountingFeatures.  # noqa: E501
        :type: dict(str, ObjectSyncFeature)
        """
        if self.local_vars_configuration.client_side_validation and sync is None:  # noqa: E501
            raise ValueError("Invalid value for `sync`, must not be `None`")  # noqa: E501

        self._sync = sync

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item, value.items()))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccountingFeatures):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AccountingFeatures):
            return True

        return self.to_dict() != other.to_dict()
