# Welcome to **optopy** [![Documentation Status](https://readthedocs.org/projects/optopy/badge/?version=latest)](https://optopy.readthedocs.io/en/latest/?badge=latest)
[**Docs**](https://optopy.readthedocs.io/en/latest/)
| [**Installation**](#installation)
| [**Cite**](#cite)


At present, **optopy** is a clone of [**tvopt**](https://github.com/nicola-bastianello/tvopt), but in the future it will include more functionalities, with the goal of delivering a module suited to the benchmarking of both *static* and *dynamic* optimization algorithms.

**tvopt** is a prototyping and benchmarking Python framework for time-varying (or online) optimization. The framework is modular,
and provides different tools for modeling dynamic optimization problems and to solve them with a wide range of well known
algorithms.

The documentation is available [here](https://optopy.readthedocs.io/en/latest/).
 

## Installation
**optopy** works on Python 3.7 and depends on: numpy, scipy.

### pip installation
```
pip install optopy
```

## Cite
See *tvopt* and relative reference:

```
@article{bastianello_tvopt_2020,
	title = {tvopt: {A} {Python} {Framework} for {Time}-{Varying} {Optimization}},
	url = {http://arxiv.org/abs/2011.07119},
	journal = {arXiv:2011.07119 [cs, math]},
	author = {Bastianello, Nicola},
	year = {2020}
}

```

## Author
**optopy** is developed by
[Nicola Bastianello](https://nicola-bastianello.github.io)
