import { Construct } from 'constructs';
import { VehicleModel } from './vehiclemodel';
/**
 * Interface
 */
export interface IVehicle {
    vehicleModel: VehicleModel;
    vehicleId: string;
    createIotThing: boolean;
}
/**
 * The vehicle of a specific type from which IoT FleetWise collect signals.
 */
export declare class Vehicle extends Construct {
    readonly arn: string;
    readonly vehicleModel: VehicleModel;
    readonly endpointAddress?: string;
    readonly certificateId?: string;
    readonly certificateArn?: string;
    readonly certificatePem?: string;
    readonly privateKey?: string;
    constructor(scope: Construct, id: string, props: IVehicle);
}
//# sourceMappingURL=vehicle.d.ts.map