import { Construct } from 'constructs';
import { SignalCatalog } from './signalcatalog';
export declare class VehicleInterface {
    protected intf: object;
    constructor();
    toObject(): object;
}
export declare class CanVehicleInterface extends VehicleInterface {
    constructor(interfaceId: string, name: string);
}
export declare class VehicleSignal {
    protected signal: object;
    constructor();
    toObject(): object;
}
export declare class CanVehicleSignal extends VehicleSignal {
    constructor(name: string, fullyQualifiedName: string, interfaceId: string, messageId: number, factor: number, isBigEndian: boolean, isSigned: boolean, length: number, offset: number, startBit: number);
}
export interface IVehicleModel {
    signalCatalog: SignalCatalog;
    name: string;
    description?: string;
    networkInterfaces: VehicleInterface[];
    signals: VehicleSignal[];
}
export declare class VehicleModel extends Construct {
    readonly name: string;
    readonly description: (string | undefined);
    readonly signalCatalog: SignalCatalog;
    constructor(scope: Construct, id: string, props: IVehicleModel);
}
//# sourceMappingURL=vehiclemodel.d.ts.map