"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VehicleModel = exports.CanVehicleSignal = exports.VehicleSignal = exports.CanVehicleInterface = exports.VehicleInterface = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class VehicleInterface {
    constructor() {
        this.intf = {};
    }
    toObject() {
        return (this.intf);
    }
}
exports.VehicleInterface = VehicleInterface;
_a = JSII_RTTI_SYMBOL_1;
VehicleInterface[_a] = { fqn: "cdk-aws-iotfleetwise.VehicleInterface", version: "0.0.0" };
class CanVehicleInterface extends VehicleInterface {
    constructor(interfaceId, name) {
        super();
        this.intf = {
            type: 'CAN_INTERFACE',
            interfaceId,
            canInterface: {
                canInterfaceName: name,
                protocolName: 'CAN',
                protocolVersion: '2.0b',
            },
        };
    }
}
exports.CanVehicleInterface = CanVehicleInterface;
_b = JSII_RTTI_SYMBOL_1;
CanVehicleInterface[_b] = { fqn: "cdk-aws-iotfleetwise.CanVehicleInterface", version: "0.0.0" };
class VehicleSignal {
    constructor() {
        this.signal = {};
    }
    toObject() {
        return (this.signal);
    }
}
exports.VehicleSignal = VehicleSignal;
_c = JSII_RTTI_SYMBOL_1;
VehicleSignal[_c] = { fqn: "cdk-aws-iotfleetwise.VehicleSignal", version: "0.0.0" };
class CanVehicleSignal extends VehicleSignal {
    constructor(name, fullyQualifiedName, interfaceId, messageId, factor, isBigEndian, isSigned, length, offset, startBit) {
        super();
        this.signal = {
            type: 'CAN_SIGNAL',
            fullyQualifiedName,
            interfaceId,
            canSignal: {
                canSignalName: name,
                factor,
                isBigEndian,
                isSigned,
                length,
                messageId,
                offset,
                startBit,
            },
        };
    }
}
exports.CanVehicleSignal = CanVehicleSignal;
_d = JSII_RTTI_SYMBOL_1;
CanVehicleSignal[_d] = { fqn: "cdk-aws-iotfleetwise.CanVehicleSignal", version: "0.0.0" };
class VehicleModel extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.name;
        this.signalCatalog = props.signalCatalog;
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'Lambda', {
            code: aws_cdk_lib_1.aws_lambda.AssetCode.fromAsset(path.join(__dirname, '/../src/handlers')),
            handler: 'vehiclemodelhandler.on_event',
            timeout: cdk.Duration.seconds(300),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            layers: [this.signalCatalog.lambdaLayer],
            role: this.signalCatalog.lambdaRole,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler: onEventHandler,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: {
                name: this.name,
                signal_catalog_arn: props.signalCatalog.arn,
                model_manifest_arn: `arn:aws:iotfleetwise:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:model-manifest/${this.name}`,
                description: props.description,
                network_interfaces: JSON.stringify(props.networkInterfaces.map(i => i.toObject())),
                signals: JSON.stringify(props.signals.map(s => s.toObject())),
            },
        });
        resource.node.addDependency(this.signalCatalog);
    }
}
exports.VehicleModel = VehicleModel;
_e = JSII_RTTI_SYMBOL_1;
VehicleModel[_e] = { fqn: "cdk-aws-iotfleetwise.VehicleModel", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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